/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.tools;

import de.dailab.jiac.common.aamm.AgentElementType;
import de.dailab.jiac.common.aamm.ComplexType;
import de.dailab.jiac.common.aamm.IConfiguration;
import de.dailab.jiac.common.aamm.IEntryType;
import de.dailab.jiac.common.aamm.IItemType;
import de.dailab.jiac.common.aamm.IModelBase;
import de.dailab.jiac.common.aamm.IPropertyType;
import de.dailab.jiac.common.aamm.ListPropertyType;
import de.dailab.jiac.common.aamm.MapPropertyType;
import de.dailab.jiac.common.aamm.ObjectEntryType;
import de.dailab.jiac.common.aamm.ObjectFactory;
import de.dailab.jiac.common.aamm.ObjectItemType;
import de.dailab.jiac.common.aamm.ObjectPropertyType;
import de.dailab.jiac.common.aamm.ObjectType;
import de.dailab.jiac.common.aamm.RefEntryType;
import de.dailab.jiac.common.aamm.RefItemType;
import de.dailab.jiac.common.aamm.ReferencableAgentElementType;
import de.dailab.jiac.common.aamm.ReferencableAgentType;
import de.dailab.jiac.common.aamm.ReferencableNodeType;
import de.dailab.jiac.common.aamm.ReferencableObjectType;
import de.dailab.jiac.common.aamm.ReferencePropertyType;
import de.dailab.jiac.common.aamm.ReferenceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DefinitionFlattener {
    private final ObjectFactory _factory;
    private int _syntheticId;

    DefinitionFlattener(ObjectFactory factory) {
        this._factory = factory;
        this._syntheticId = 0;
    }

    public void flatten(IConfiguration config) {
        this.flattenNodes(config);
        this.flattenAgents(config);
        this.flattenAgentElements(config);
        this.flattenObjects(config);
    }

    private void flattenNodes(IConfiguration config) {
        for (ReferencableNodeType node : config.getNodes()) {
            this.flattenProperties(config, node);
        }
    }

    private void flattenAgents(IConfiguration config) {
        for (ReferencableAgentType ragent : config.getAgents()) {
            ArrayList<ReferenceType> newAgentElementRefs = new ArrayList<ReferenceType>();
            Iterator<IModelBase> iter = ragent.getAgentElements().iterator();
            while (iter.hasNext()) {
                IModelBase current = iter.next();
                if (!(current instanceof AgentElementType)) continue;
                iter.remove();
                ReferencableAgentElementType ragentelement = this._factory.createReferencableAgentElementType();
                this.copyInto((AgentElementType)current, ragentelement);
                ragentelement.setId(ragent.getId() + "_AE_" + this._syntheticId++ + "__");
                config.getAgentElements().add(ragentelement);
                ReferenceType ref = this._factory.createReferenceType();
                current.copyMetaData(ref);
                ref.setLocalIdentifier(ragentelement.getId());
                ref.setNamespace(config.getNamespace());
                newAgentElementRefs.add(ref);
            }
            ragent.getAgentElements().addAll(newAgentElementRefs);
            this.flattenProperties(config, ragent);
        }
    }

    private void flattenAgentElements(IConfiguration config) {
        for (ReferencableAgentElementType ragentelement : config.getAgentElements()) {
            this.flattenProperties(config, ragentelement);
        }
    }

    private void flattenObjects(IConfiguration config) {
        List<ReferencableObjectType> objects = config.getObjects();
        for (int i = 0; i < objects.size(); ++i) {
            this.flattenProperties(config, objects.get(i));
        }
    }

    private void flattenProperties(IConfiguration config, ComplexType complex) {
        ArrayList<ReferencableObjectType> objects = new ArrayList<ReferencableObjectType>();
        ArrayList<ReferencePropertyType> newObjectRefs = new ArrayList<ReferencePropertyType>();
        Iterator<IPropertyType> iter = complex.getProperties().iterator();
        while (iter.hasNext()) {
            ReferencableObjectType robject;
            IModelBase current;
            IPropertyType p = iter.next();
            if (p instanceof ObjectPropertyType) {
                iter.remove();
                ReferencableObjectType robject2 = this.cloneInnerObject((ObjectPropertyType)p);
                ReferencePropertyType rpt = this._factory.createReferencePropertyType();
                rpt.setName(p.getName());
                p.copyMetaData(rpt);
                rpt.setLocalIdentifier(robject2.getId());
                rpt.setNamespace(config.getNamespace());
                objects.add(robject2);
                newObjectRefs.add(rpt);
                continue;
            }
            if (p instanceof ListPropertyType) {
                List<IItemType> items = ((ListPropertyType)p).getItems();
                for (int i = 0; i < items.size(); ++i) {
                    current = items.get(i);
                    if (!(current instanceof ObjectItemType)) continue;
                    robject = this.cloneInnerObject((ObjectItemType)current);
                    RefItemType rit = this._factory.createRefItemType();
                    current.copyMetaData(rit);
                    rit.setLocalIdentifier(robject.getId());
                    rit.setNamespace(config.getNamespace());
                    objects.add(robject);
                    items.set(i, rit);
                }
                continue;
            }
            if (!(p instanceof MapPropertyType)) continue;
            List<IEntryType> entries = ((MapPropertyType)p).getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                current = entries.get(i);
                if (!(current instanceof ObjectEntryType)) continue;
                robject = this.cloneInnerObject((ObjectEntryType)current);
                RefEntryType ret = this._factory.createRefEntryType();
                ret.setKey(current.getKey());
                current.copyMetaData(ret);
                ret.setLocalIdentifier(robject.getId());
                ret.setNamespace(config.getNamespace());
                objects.add(robject);
                entries.set(i, ret);
            }
        }
        complex.getProperties().addAll(newObjectRefs);
        config.getObjects().addAll(objects);
    }

    private ReferencableObjectType cloneInnerObject(ObjectType innerObject) {
        ReferencableObjectType robject = this._factory.createReferencableObjectType();
        this.copyInto(innerObject, robject);
        robject.setSingleton(innerObject.isSingleton());
        robject.setId("__object_" + this._syntheticId++ + "__");
        return robject;
    }

    private void copyInto(ComplexType source, ComplexType target) {
        source.copyMetaData(target);
        target.setClazz(source.getClazz());
        target.setParent(source.getParent());
        target.getProperties().addAll(source.getProperties());
        if (source instanceof AgentElementType && target instanceof ReferencableAgentElementType) {
            ((ReferencableAgentElementType)target).setDisplayName(((AgentElementType)source).getDisplayName());
        }
    }
}

