/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.tools;

import de.dailab.jiac.common.aamm.ConfigurationType;
import de.dailab.jiac.common.aamm.FrameworkType;
import de.dailab.jiac.common.aamm.IConfiguration;
import de.dailab.jiac.common.aamm.ISingleFileConfiguration;
import de.dailab.jiac.common.aamm.ObjectFactory;
import de.dailab.jiac.common.aamm.ext.MultiFileConfiguration;
import de.dailab.jiac.common.aamm.ext.SingleFileConfiguration;
import de.dailab.jiac.common.aamm.tools.MetaModelException;
import de.dailab.jiac.common.aamm.tools.ToolContext;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class MetaModelReader {
    private final ObjectFactory _factory;
    private final JAXBContext _context;
    private final FrameworkType _framework;
    private final Schema _schema;

    MetaModelReader(ObjectFactory factory, FrameworkType framework) throws MetaModelException {
        try {
            this._factory = factory;
            this._context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            this._framework = framework;
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaURL = MetaModelReader.class.getResource("/de/dailab/jiac/common/aamm/aamm-1.1.xsd");
            if (schemaURL == null) {
                System.err.println("WARN: no schema for validation found");
                this._schema = null;
            } else {
                this._schema = sf.newSchema(schemaURL);
            }
        }
        catch (Exception e) {
            throw new MetaModelException("could not create new parser instance", e);
        }
    }

    public IConfiguration read(ClassLoader loader, String namespace) throws MetaModelException {
        String fileName = ToolContext.getClasspathFileNameForNamespace(namespace);
        try {
            Enumeration<URL> urls = loader.getResources(fileName);
            ArrayList<ISingleFileConfiguration> configs = new ArrayList<ISingleFileConfiguration>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream in = url.openStream();
                if (in == null) continue;
                ISingleFileConfiguration config = this.read(namespace, url, in);
                if (config.getFramework() == this._framework) {
                    configs.add(config);
                    continue;
                }
                System.err.println("MetaModelReader - WARN: found configuration for another framework: " + config.getFramework().value());
            }
            if (configs.size() == 1) {
                return (IConfiguration)configs.get(0);
            }
            if (configs.size() > 1) {
                return new MultiFileConfiguration(configs);
            }
            throw new FileNotFoundException(fileName);
        }
        catch (Exception e) {
            if (e instanceof MetaModelException) {
                throw (MetaModelException)e;
            }
            throw new MetaModelException("could not read configuration(s) in '" + namespace + "'", e);
        }
    }

    public ISingleFileConfiguration read(String namespace, URL url, InputStream in) throws MetaModelException {
        if (in == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        try {
            Unmarshaller u = this._context.createUnmarshaller();
            u.setProperty("com.sun.xml.bind.ObjectFactory", (Object)this._factory);
            u.setSchema(this._schema);
            JAXBElement e = u.unmarshal((Source)new StreamSource(in), ConfigurationType.class);
            SingleFileConfiguration result = (SingleFileConfiguration)e.getValue();
            result.setConfigurationData(namespace, url);
            result.prepareProcessing(this._factory);
            return result;
        }
        catch (Exception e) {
            throw new MetaModelException("could not read configuration from " + url, e);
        }
    }
}

