/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.tools;

import de.dailab.jiac.common.aamm.ConfigurationType;
import de.dailab.jiac.common.aamm.IConfiguration;
import de.dailab.jiac.common.aamm.IMultiFileConfiguration;
import de.dailab.jiac.common.aamm.ISingleFileConfiguration;
import de.dailab.jiac.common.aamm.ObjectFactory;
import de.dailab.jiac.common.aamm.ext.MultiFileConfiguration;
import de.dailab.jiac.common.aamm.ext.SingleFileConfiguration;
import de.dailab.jiac.common.aamm.tools.MetaModelException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class MetaModelWriter {
    private final JAXBContext _context;
    private final ObjectFactory _factory;

    MetaModelWriter(ObjectFactory factory) throws MetaModelException {
        try {
            this._factory = factory;
            this._context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (Exception e) {
            throw new MetaModelException("could not create new parser instance", e);
        }
    }

    public void write(IConfiguration configuration, OutputStream out) throws MetaModelException {
        if (configuration instanceof SingleFileConfiguration) {
            this.write((SingleFileConfiguration)configuration, out);
        } else if (configuration instanceof MultiFileConfiguration) {
            this.mergeAndWrite((MultiFileConfiguration)configuration, out);
        } else {
            throw new IllegalArgumentException("unsupported configuration implementation: " + configuration.getClass());
        }
    }

    public void write(ISingleFileConfiguration singleConf, OutputStream out) throws MetaModelException {
        try {
            Marshaller m = this._context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.schemaLocation", (Object)"http://www.jiac.de/AAMM/1.1 http://www.jiac.de/xsd/aamm-1.1.xsd");
            singleConf.prepareMarshalling(this._factory);
            JAXBElement<ConfigurationType> jaxbElement = this._factory.createConfiguration((SingleFileConfiguration)singleConf);
            m.marshal(jaxbElement, (Result)new StreamResult(out));
        }
        catch (Exception e) {
            throw new MetaModelException("could not write configuration", e);
        }
    }

    public void mergeAndWrite(IMultiFileConfiguration multiConf, OutputStream out) throws MetaModelException {
    }
}

