/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.tools;

import de.dailab.jiac.common.aamm.FrameworkType;
import de.dailab.jiac.common.aamm.ObjectFactory;
import de.dailab.jiac.common.aamm.tools.AdaptableObjectFactory;
import de.dailab.jiac.common.aamm.tools.DefinitionFlattener;
import de.dailab.jiac.common.aamm.tools.MetaModelException;
import de.dailab.jiac.common.aamm.tools.MetaModelReader;
import de.dailab.jiac.common.aamm.tools.MetaModelWriter;

public class ToolContext {
    private static final String SUFFIX = ".xml";
    private final ObjectFactory _factory;
    private final FrameworkType _framework;

    public static String getClasspathFileNameForNamespace(String namespace) {
        return namespace.replace('.', '/') + SUFFIX;
    }

    public ToolContext(FrameworkType framework) {
        this._factory = new ObjectFactory();
        this._framework = framework;
    }

    public ToolContext(String implPackage, FrameworkType framework) {
        this._factory = new AdaptableObjectFactory(implPackage);
        this._framework = framework;
    }

    public final MetaModelWriter createWriter() throws MetaModelException {
        return new MetaModelWriter(this._factory);
    }

    public final MetaModelReader createReader() throws MetaModelException {
        return new MetaModelReader(this._factory, this._framework);
    }

    public final DefinitionFlattener createDefinitionFlattener() {
        return new DefinitionFlattener(this._factory);
    }

    public final ObjectFactory getObjectFactory() {
        return this._factory;
    }

    public final FrameworkType getFramework() {
        return this._framework;
    }
}

