/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.util;

import de.dailab.jiac.common.aamm.IEntryType;
import de.dailab.jiac.common.aamm.IItemType;
import de.dailab.jiac.common.aamm.ISimpleType;
import de.dailab.jiac.common.aamm.ListPropertyType;
import de.dailab.jiac.common.aamm.MapPropertyType;
import de.dailab.jiac.common.aamm.ReferencePropertyType;
import de.dailab.jiac.common.aamm.ReferenceType;
import de.dailab.jiac.common.aamm.SimplePropertyType;
import de.dailab.jiac.common.aamm.beans.IndexedPropertyDescriptor;
import de.dailab.jiac.common.aamm.beans.Introspector;
import de.dailab.jiac.common.aamm.beans.MappedPropertyDescriptor;
import de.dailab.jiac.common.aamm.beans.PropertyDescriptor;
import de.dailab.jiac.common.aamm.check.DefinitionChecker;
import de.dailab.jiac.common.aamm.ext.Reference;
import de.dailab.jiac.common.aamm.util.SimpleTypeHelper;
import java.lang.reflect.Method;
import java.util.List;

public final class PropertyCheckHelper {
    private PropertyCheckHelper() {
    }

    public static void checkSimpleProperty(SimplePropertyType s, PropertyDescriptor pd, DefinitionChecker.CheckerCallback cb) {
        if (pd.getClass() != PropertyDescriptor.class) {
            cb.addErrorMessage("invalid type");
            return;
        }
        s.setMetaData("setterMethodKey", pd.getWriteMethod());
        try {
            SimpleTypeHelper.setClassType(s, pd.getPropertyType());
        }
        catch (RuntimeException re) {
            cb.addErrorMessage("type issue: " + re.getMessage());
        }
    }

    public static void checkReferenceProperty(ReferencePropertyType r, PropertyDescriptor pd, DefinitionChecker.CheckerCallback cb) {
        if (pd.getClass() != PropertyDescriptor.class) {
            cb.addErrorMessage("invalid type");
            return;
        }
        r.setMetaData("setterMethodKey", pd.getWriteMethod());
        cb.enforceTypeForReference(Reference.createFrom(r), pd.getPropertyType(), "type issue");
    }

    public static void checkListProperty(ListPropertyType l, PropertyDescriptor pd, DefinitionChecker.CheckerCallback cb) {
        Method setter = null;
        Method indexedSetter = null;
        Class<?> indexedType = null;
        if (pd.getClass() == PropertyDescriptor.class) {
            Class<?> pType = pd.getPropertyType();
            if (pType == null || !pType.isArray() && !Introspector.isList(pType)) {
                cb.addErrorMessage("invalid type");
                return;
            }
            setter = pd.getWriteMethod();
            indexedType = pType.isArray() ? pType.getComponentType() : Introspector.getListComponentType(pType);
        } else if (pd instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            indexedType = ipd.getIndexedPropertyType();
            setter = ipd.getWriteMethod();
            indexedSetter = ipd.getIndexedWriteMethod();
        } else {
            cb.addErrorMessage("invalid type");
            return;
        }
        if (setter != null) {
            l.setMetaData("setterMethodKey", setter);
        }
        List<IItemType> items = l.getItems();
        for (int i = 0; i < items.size(); ++i) {
            IItemType item = items.get(i);
            if (indexedSetter != null) {
                item.setMetaData("setterMethodKey", indexedSetter);
            }
            if (item instanceof ISimpleType) {
                try {
                    SimpleTypeHelper.setClassType((ISimpleType)((Object)item), indexedType);
                }
                catch (RuntimeException re) {
                    cb.addErrorMessage("type issue with simple list item (" + i + "): " + re.getMessage());
                }
                continue;
            }
            cb.enforceTypeForReference(Reference.createFrom((ReferenceType)((Object)item)), indexedType, "type issue with reference list item (" + i + ")");
        }
    }

    public static void checkMapProperty(MapPropertyType m, PropertyDescriptor pd, DefinitionChecker.CheckerCallback cb) {
        Method setter = null;
        Method mappedSetter = null;
        Class<?> mappedType = null;
        if (pd.getClass() == PropertyDescriptor.class) {
            Class<?> pType = pd.getPropertyType();
            if (pType == null || !Introspector.isMap(pType)) {
                cb.addErrorMessage("invalid type");
                return;
            }
            setter = pd.getWriteMethod();
            mappedType = Introspector.getMapComponentType(pType);
        } else if (pd instanceof MappedPropertyDescriptor) {
            MappedPropertyDescriptor mpd = (MappedPropertyDescriptor)pd;
            mappedType = mpd.getMappedPropertyType();
            setter = mpd.getWriteMethod();
            mappedSetter = mpd.getMappedWriteMethod();
        } else {
            cb.addErrorMessage("invalid type");
            return;
        }
        if (setter != null) {
            m.setMetaData("setterMethodKey", setter);
        }
        for (IEntryType entry : m.getEntries()) {
            if (mappedSetter != null) {
                entry.setMetaData("setterMethodKey", mappedSetter);
            }
            if (entry instanceof ISimpleType) {
                try {
                    SimpleTypeHelper.setClassType((ISimpleType)((Object)entry), mappedType);
                }
                catch (RuntimeException re) {
                    cb.addErrorMessage("type issue with simple entry (key='" + entry.getKey() + "'): " + re.getMessage());
                }
                continue;
            }
            cb.enforceTypeForReference(Reference.createFrom((ReferenceType)((Object)entry)), mappedType, "type issue with reference entry (key='" + entry.getKey() + "')");
        }
    }
}

