/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.util;

import de.dailab.jiac.common.aamm.ISimpleType;
import de.dailab.jiac.common.aamm.JavaBaseType;
import de.dailab.jiac.common.aamm.beans.Introspector;

public class SimpleTypeHelper {
    static Class<?> convert(JavaBaseType type) {
        switch (type) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case CHAR: {
                return Character.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case SHORT: {
                return Short.class;
            }
            case STRING: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("unknown type '" + (Object)((Object)type) + "'");
    }

    static void setClassType(ISimpleType self, Class<?> type) {
        self.setMetaData("classtype", SimpleTypeHelper.getClassType(self, type));
    }

    static Class<?> getClassType(ISimpleType target, Class type) {
        if (target.getType() != null && Introspector.areEqual(type, Object.class)) {
            return SimpleTypeHelper.convert(target.getType());
        }
        if (Introspector.areEqual(type, Boolean.class) || Introspector.areEqual(type, Boolean.TYPE)) {
            target.setType(JavaBaseType.BOOLEAN);
        } else if (Introspector.areEqual(type, Byte.class) || Introspector.areEqual(type, Byte.TYPE)) {
            target.setType(JavaBaseType.BYTE);
        } else if (Introspector.areEqual(type, Character.class) || Introspector.areEqual(type, Character.TYPE)) {
            target.setType(JavaBaseType.CHAR);
        } else if (Introspector.areEqual(type, Double.class) || Introspector.areEqual(type, Double.TYPE)) {
            target.setType(JavaBaseType.DOUBLE);
        } else if (Introspector.areEqual(type, Float.class) || Introspector.areEqual(type, Float.TYPE)) {
            target.setType(JavaBaseType.FLOAT);
        } else if (Introspector.areEqual(type, Integer.class) || Introspector.areEqual(type, Integer.TYPE)) {
            target.setType(JavaBaseType.INT);
        } else if (Introspector.areEqual(type, Long.class) || Introspector.areEqual(type, Long.TYPE)) {
            target.setType(JavaBaseType.LONG);
        } else if (Introspector.areEqual(type, Short.class) || Introspector.areEqual(type, Short.TYPE)) {
            target.setType(JavaBaseType.SHORT);
        } else if (Introspector.areEqual(type, String.class) || Introspector.areEqual(type, Object.class)) {
            target.setType(JavaBaseType.STRING);
        }
        return type;
    }
}

