/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.config.analysis;

import de.jiac.micro.config.analysis.RuntimeGuessValue;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class BasicGuesser
implements Interpreter,
Opcodes {
    public Value newValue(Type type) {
        if (type == null) {
            return RuntimeGuessValue.UNINITIALISED_VALUE;
        }
        switch (type.getSort()) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return RuntimeGuessValue.UNSPECIFIED_INT_VALUE;
            }
            case 6: {
                return RuntimeGuessValue.UNSPECIFIED_FLOAT_VALUE;
            }
            case 7: {
                return RuntimeGuessValue.UNSPECIFIED_LONG_VALUE;
            }
            case 8: {
                return RuntimeGuessValue.UNSPECIFIED_DOUBLE_VALUE;
            }
            case 9: 
            case 10: {
                return new RuntimeGuessValue(type, null);
            }
        }
        throw new Error("Internal error");
    }

    public Value newOperation(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 1: {
                return RuntimeGuessValue.NULL_CONSTANT;
            }
            case 2: {
                return RuntimeGuessValue.IM1_CONSTANT;
            }
            case 3: {
                return RuntimeGuessValue.I0_CONSTANT;
            }
            case 4: {
                return RuntimeGuessValue.I1_CONSTANT;
            }
            case 5: {
                return RuntimeGuessValue.I2_CONSTANT;
            }
            case 6: {
                return RuntimeGuessValue.I3_CONSTANT;
            }
            case 7: {
                return RuntimeGuessValue.I4_CONSTANT;
            }
            case 8: {
                return RuntimeGuessValue.I5_CONSTANT;
            }
            case 9: {
                return RuntimeGuessValue.L0_CONSTANT;
            }
            case 10: {
                return RuntimeGuessValue.L1_CONSTANT;
            }
            case 11: {
                return RuntimeGuessValue.F0_CONSTANT;
            }
            case 12: {
                return RuntimeGuessValue.F1_CONSTANT;
            }
            case 13: {
                return RuntimeGuessValue.F2_CONSTANT;
            }
            case 14: {
                return RuntimeGuessValue.D0_CONSTANT;
            }
            case 15: {
                return RuntimeGuessValue.D1_CONSTANT;
            }
            case 16: 
            case 17: {
                return new RuntimeGuessValue(Type.INT_TYPE, ((IntInsnNode)insn).operand);
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Integer) {
                    return new RuntimeGuessValue(Type.INT_TYPE, cst);
                }
                if (cst instanceof Float) {
                    return new RuntimeGuessValue(Type.FLOAT_TYPE, cst);
                }
                if (cst instanceof Long) {
                    return new RuntimeGuessValue(Type.LONG_TYPE, cst);
                }
                if (cst instanceof Double) {
                    return new RuntimeGuessValue(Type.DOUBLE_TYPE, cst);
                }
                if (cst instanceof Type) {
                    return new RuntimeGuessValue(Type.getObjectType((String)"java/lang/Class"), ((Type)cst).getClassName());
                }
                return new RuntimeGuessValue(Type.getType(cst.getClass()), cst);
            }
            case 168: {
                return RuntimeGuessValue.RETURNADDRESS_VALUE;
            }
            case 178: {
                return this.newValue(Type.getType((String)((FieldInsnNode)insn).desc));
            }
            case 187: {
                return this.newValue(Type.getObjectType((String)((TypeInsnNode)insn).desc));
            }
        }
        throw new Error("Internal error.");
    }

    public Value copyOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        return value;
    }

    public Value unaryOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: {
                return RuntimeGuessValue.UNSPECIFIED_INT_VALUE;
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                return RuntimeGuessValue.UNSPECIFIED_FLOAT_VALUE;
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                return RuntimeGuessValue.UNSPECIFIED_LONG_VALUE;
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                return RuntimeGuessValue.UNSPECIFIED_DOUBLE_VALUE;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: {
                return null;
            }
            case 180: {
                return this.newValue(Type.getType((String)((FieldInsnNode)insn).desc));
            }
            case 188: {
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        return this.newValue(Type.getType((String)"[Z"));
                    }
                    case 5: {
                        return this.newValue(Type.getType((String)"[C"));
                    }
                    case 8: {
                        return this.newValue(Type.getType((String)"[B"));
                    }
                    case 9: {
                        return this.newValue(Type.getType((String)"[S"));
                    }
                    case 10: {
                        return this.newValue(Type.getType((String)"[I"));
                    }
                    case 6: {
                        return this.newValue(Type.getType((String)"[F"));
                    }
                    case 7: {
                        return this.newValue(Type.getType((String)"[D"));
                    }
                    case 11: {
                        return this.newValue(Type.getType((String)"[J"));
                    }
                }
                throw new AnalyzerException("Invalid array type");
            }
            case 189: {
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getType((String)("[" + Type.getObjectType((String)desc))));
            }
            case 190: {
                return RuntimeGuessValue.UNSPECIFIED_INT_VALUE;
            }
            case 191: {
                return null;
            }
            case 192: {
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getObjectType((String)desc));
            }
            case 193: {
                return RuntimeGuessValue.UNSPECIFIED_INT_VALUE;
            }
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return RuntimeGuessValue.UNSPECIFIED_INT_VALUE;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return RuntimeGuessValue.UNSPECIFIED_FLOAT_VALUE;
            }
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return RuntimeGuessValue.UNSPECIFIED_LONG_VALUE;
            }
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return RuntimeGuessValue.UNSPECIFIED_DOUBLE_VALUE;
            }
            case 50: {
                return new RuntimeGuessValue(Type.getObjectType((String)"java/lang/Object"), null);
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return RuntimeGuessValue.UNSPECIFIED_INT_VALUE;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) throws AnalyzerException {
        return null;
    }

    public Value naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        if (insn.getOpcode() == 197) {
            return this.newValue(Type.getType((String)((MultiANewArrayInsnNode)insn).desc));
        }
        return this.newValue(Type.getReturnType((String)((MethodInsnNode)insn).desc));
    }

    public Value merge(Value v, Value w) {
        return this.internalMerge((RuntimeGuessValue)v, (RuntimeGuessValue)w);
    }

    private RuntimeGuessValue internalMerge(RuntimeGuessValue v, RuntimeGuessValue w) {
        if (!v.typeEquals(w)) {
            return RuntimeGuessValue.UNINITIALISED_VALUE;
        }
        if (v.valueEquals(w)) {
            return v;
        }
        return v.getValue() != null ? v : w;
    }
}

