/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.config.analysis;

import de.jiac.micro.config.analysis.ClassInfoPool;
import de.jiac.micro.config.analysis.MethodKey;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassInfo {
    static final int LIFECYCLE_AWARE = 0;
    static final int ACTUATOR = 1;
    static final int SENSOR = 2;
    static final int HANDLE = 3;
    static final int CONNECTION_FACTORY = 4;
    static final int BEHAVIOUR = 5;
    static final int NODE_COMPONENT = 6;
    public final int version;
    public final boolean isInterface;
    public final String className;
    public final String superClassName;
    public final Map<MethodKey, Set<String>> referencedHandlesInMethods = new HashMap<MethodKey, Set<String>>();
    public final Set<String> referencedFieldClasses = new HashSet<String>();
    public final Map<MethodKey, Set<String>> referencedClassesInMethods = new HashMap<MethodKey, Set<String>>();
    final Set<String> superInterfaceNames;
    String directHandle;
    final Set<String> indirectHandles = new HashSet<String>();
    protected final HashSet<String> ancestors = new HashSet();
    private final BitSet _classStates;
    private boolean _mergedWithAncestors = false;
    private final ClassInfoPool _pool;

    public static ClassInfo createInterfaceInfo(ClassInfoPool pool, int version, String className, Set<String> superInterfaceNames) {
        return new ClassInfo(pool, version, className, null, superInterfaceNames, true);
    }

    public static ClassInfo createClassInfo(ClassInfoPool pool, int version, String className, String superClassName, Set<String> superInterfaceNames) {
        return new ClassInfo(pool, version, className, superClassName, superInterfaceNames, false);
    }

    private ClassInfo(ClassInfoPool pool, int version, String className, String superClassName, Set<String> superInterfaceNames, boolean isInterface) {
        this.version = version;
        this.className = className;
        this.superInterfaceNames = superInterfaceNames;
        this.superClassName = superClassName;
        this.isInterface = isInterface;
        this._classStates = new BitSet(7);
        this._pool = pool;
    }

    public final boolean isActuator() {
        return this.hasState(1);
    }

    public final boolean isConnectionFactory() {
        return this.hasState(4);
    }

    public final boolean isHandle() {
        return this.hasState(3);
    }

    public final boolean isLifecycleAware() {
        return this.hasState(0);
    }

    public final boolean isSensor() {
        return this.hasState(2);
    }

    public boolean isNodeComponent() {
        return !this.isInterface && this.hasState(6);
    }

    public boolean isBehaviour() {
        return !this.isInterface && this.hasState(5);
    }

    public String getProvidedHandle() {
        if (this.isActuator() || this.isNodeComponent()) {
            return this.directHandle;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isInterface ? "interface " : "class ");
        builder.append(this.className).append(": ");
        if (this.isActuator()) {
            builder.append("A ");
        }
        if (this.isConnectionFactory()) {
            builder.append("C ");
        }
        if (this.isHandle()) {
            builder.append("H ");
        }
        if (this.isLifecycleAware()) {
            builder.append("L ");
        }
        if (this.isSensor()) {
            builder.append("S ");
        }
        if (this.isBehaviour()) {
            builder.append("B ");
        }
        if (this.isNodeComponent()) {
            builder.append("N ");
        }
        builder.append(this.referencedClassesInMethods);
        builder.append(this.referencedHandlesInMethods);
        return builder.toString();
    }

    public final boolean isAssignableFrom(ClassInfo other) {
        if (other == this) {
            return true;
        }
        other.ensureMerged();
        return other.ancestors.contains(this.className);
    }

    protected final boolean hasState(int index) {
        this.ensureMerged();
        if (index >= this._classStates.length()) {
            return false;
        }
        return this._classStates.get(index);
    }

    protected final void setState(int index) {
        this._classStates.set(index);
    }

    protected void ensureMerged() {
        if (!this._mergedWithAncestors) {
            this.mergeWithAncestors();
            this._mergedWithAncestors = true;
        }
    }

    private final void mergeWithAncestors() {
        ClassInfo superInfo;
        if (!this.isInterface && (superInfo = this._pool.getClassInfo(this.superClassName)) != null) {
            superInfo.ensureMerged();
            this._classStates.or(superInfo._classStates);
            this.ancestors.add(superInfo.className);
            this.ancestors.addAll(superInfo.ancestors);
        }
        Iterator<String> iter = this.superInterfaceNames.iterator();
        while (iter.hasNext()) {
            ClassInfo superInterfaceInfo = this._pool.getClassInfo(iter.next());
            if (superInterfaceInfo == null) continue;
            superInterfaceInfo.ensureMerged();
            this._classStates.or(superInterfaceInfo._classStates);
            this.ancestors.add(superInterfaceInfo.className);
            this.ancestors.addAll(superInterfaceInfo.ancestors);
        }
    }
}

