/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.config.analysis;

import de.jiac.micro.config.analysis.ClassInfo;
import de.jiac.micro.config.analysis.MethodAnalyser;
import de.jiac.micro.config.analysis.MethodKey;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoPool {
    private final ClassLoader _classLoader;
    private final ClassInfoCreator _classInfoCreator;
    private final HashSet<String> _requestedInfo;
    private final HashMap<String, ClassInfo> _pool;

    public static boolean ignoreClass(String className) {
        return className.startsWith("java.") || className.startsWith("javax.");
    }

    public ClassInfoPool(ClassLoader classLoader) {
        this._classLoader = classLoader;
        this._requestedInfo = new HashSet();
        this._pool = new HashMap();
        this._classInfoCreator = new ClassInfoCreator();
    }

    public void requestClassInfo(String className) {
        if (ClassInfoPool.ignoreClass(className)) {
            return;
        }
        this._requestedInfo.add(className);
    }

    public void requestClassInfos(Collection<String> classNames) {
        for (String className : classNames) {
            this.requestClassInfo(className);
        }
    }

    public void buildPool() {
        while (!this._requestedInfo.isEmpty()) {
            String next = this._requestedInfo.iterator().next();
            this._requestedInfo.remove(next);
            if (!this._pool.containsKey(next)) {
                try {
                    InputStream in = this._classLoader.getResourceAsStream(next.replace('.', '/') + ".class");
                    ClassReader reader = new ClassReader(in);
                    reader.accept((ClassVisitor)this._classInfoCreator, 0);
                    this._pool.put(next, this._classInfoCreator.getInfo());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this._pool.put(next, null);
                }
            }
            this._requestedInfo.removeAll(this._pool.keySet());
        }
    }

    public ClassInfo getClassInfo(String className) {
        return this._pool.get(className);
    }

    public HashSet<ClassInfo> getDerivativeClassInfos(ClassInfo root) {
        HashSet<ClassInfo> result = new HashSet<ClassInfo>();
        for (ClassInfo ci : this._pool.values()) {
            if (ci == root || !root.isAssignableFrom(ci)) continue;
            result.add(ci);
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, ClassInfo> entry : this._pool.entrySet()) {
            if (entry.getValue() == null) {
                System.out.println("MISSING: " + entry.getKey());
                continue;
            }
            builder.append(entry.getValue().toString()).append('\n');
        }
        return builder.toString();
    }

    final class ClassInfoCreator
    extends EmptyVisitor
    implements Opcodes {
        protected String owner;
        protected ClassInfo classInfo;
        private final HashMap<String, Integer> _classStates = new HashMap();
        private final HashMap<String, Integer> _interfaceStates;

        protected ClassInfoCreator() {
            this._classStates.put("de.jiac.micro.core.AbstractNodeComponent", 6);
            this._classStates.put("de.jiac.micro.agent.AbstractActiveBehaviour", 5);
            this._classStates.put("de.jiac.micro.agent.AbstractReactiveBehaviour", 5);
            this._interfaceStates = new HashMap();
            this._interfaceStates.put("de.jiac.micro.core.IHandle", 3);
            this._interfaceStates.put("de.jiac.micro.agent.IActuator", 1);
            this._interfaceStates.put("de.jiac.micro.agent.ISensor", 2);
            this._interfaceStates.put("de.jiac.micro.core.feature.ILifecycleAware", 0);
            this._interfaceStates.put("de.jiac.micro.core.feature.IConnectionFactory", 4);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.owner = name;
            String className = name.replace('/', '.');
            HashSet<String> superInterfaceNames = new HashSet<String>();
            for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
                superInterfaceNames.add(interfaces[i].replace('/', '.'));
            }
            ClassInfoPool.this.requestClassInfos(superInterfaceNames);
            Integer state = null;
            if ((access & 0x200) > 0) {
                this.classInfo = ClassInfo.createInterfaceInfo(ClassInfoPool.this, version, className, superInterfaceNames);
                state = this._interfaceStates.get(className);
            } else {
                String superClassName = superName == null ? null : superName.replace('/', '.');
                this.classInfo = ClassInfo.createClassInfo(ClassInfoPool.this, version, className, superClassName, superInterfaceNames);
                state = this._classStates.get(className);
                if (superClassName != null) {
                    ClassInfoPool.this.requestClassInfo(superClassName);
                }
            }
            if (state != null) {
                this.classInfo.setState(state);
            }
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            String className;
            Type type = Type.getType((String)desc);
            if (type.getSort() == 9) {
                type.getElementType();
            }
            if (type.getSort() == 10 && !ClassInfoPool.ignoreClass(className = type.getClassName())) {
                ClassInfoPool.this.requestClassInfo(className);
                this.classInfo.referencedFieldClasses.add(className);
            }
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.classInfo.isInterface || (access & 0x400) != 0 || (access & 0x1000) != 0) {
                return null;
            }
            return new MethodAnalyser(this, access, name, desc, signature, exceptions);
        }

        protected ClassInfo getInfo() {
            ClassInfo result = this.classInfo;
            this.classInfo = null;
            return result;
        }

        protected void registerDependencyForMethod(MethodKey methodKey, String className) {
            if (className == null || ClassInfoPool.ignoreClass(className)) {
                return;
            }
            ClassInfoPool.this.requestClassInfo(className);
            Set<String> references = this.classInfo.referencedClassesInMethods.get(methodKey);
            references.add(className);
        }
    }
}

