/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.config.analysis;

import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AnalyzerAdapter;
import org.objectweb.asm.commons.EmptyVisitor;

class ComponentAnalyser
implements ClassVisitor,
FieldVisitor,
Opcodes {
    protected static final HashSet<String> HANDLE_SOURCES = new HashSet();
    private final HandleGetterVisitor _handleGetterVisitor = new HandleGetterVisitor();
    private final NormalMethodVisitor _normalMethodVisitor = new NormalMethodVisitor();
    private String _componentClassName;
    protected HashSet<String> requiredHandles = new HashSet();
    protected String providedHandleClassName;

    ComponentAnalyser() {
    }

    public void clear() {
        this.requiredHandles = new HashSet();
        this.providedHandleClassName = null;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this._componentClassName = name;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return this;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor result = desc.equals("()Lde/jiac/micro/core/IHandle;") && (name.equals("getHandle") || name.equals("getScopeHandle")) ? this._handleGetterVisitor.reset(this._componentClassName, access, name, desc) : this._normalMethodVisitor.reset(this._componentClassName, access, name, desc);
        return result;
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitSource(String source, String debug) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitEnd() {
    }

    static {
        HANDLE_SOURCES.add("de/jiac/micro/core/scope/Scope");
        HANDLE_SOURCES.add("de/jiac/micro/core/IAgent");
        HANDLE_SOURCES.add("de/jiac/micro/core/INode");
        HANDLE_SOURCES.add("de/jiac/micro/core/IContainer");
    }

    private final class NormalMethodVisitor
    extends MethodAnalyser {
        private String _handleClassName;
        private boolean _awaitClassName;

        protected NormalMethodVisitor() {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (this._awaitClassName) {
                return;
            }
            if (opcode == 178 && name.startsWith("class$") && desc.equals("Ljava/lang/Class;")) {
                this._awaitClassName = true;
            }
        }

        public void visitLdcInsn(Object cst) {
            if (this._awaitClassName) {
                this._handleClassName = (String)cst;
                this._awaitClassName = false;
            } else if (cst instanceof Type) {
                this._handleClassName = ((Type)cst).getClassName();
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (HANDLE_SOURCES.contains(owner) && desc.equals("(Ljava/lang/Class;)Lde/jiac/micro/core/IHandle;") && (opcode == 184 && name.equals("getScopeHandle") || opcode == 185 && name.equals("getHandle"))) {
                ComponentAnalyser.this.requiredHandles.add(this._handleClassName);
                this._handleClassName = null;
            }
        }
    }

    private final class HandleGetterVisitor
    extends MethodAnalyser {
        protected HandleGetterVisitor() {
        }

        public void visitInsn(int opcode) {
            if (opcode == 176) {
                List stack = this.stackAnalyzer.stack;
                Object s = stack.get(stack.size() - 1);
                ComponentAnalyser.this.providedHandleClassName = s instanceof Type ? ((Type)s).getClassName() : (String)s;
            }
        }
    }

    private static abstract class MethodAnalyser
    extends EmptyVisitor {
        protected AnalyzerAdapter stackAnalyzer;

        protected MethodAnalyser() {
        }

        protected final MethodVisitor reset(String owner, int access, String name, String desc) {
            this.stackAnalyzer = new AnalyzerAdapter(owner, access, name, desc, (MethodVisitor)this);
            return this.stackAnalyzer;
        }
    }
}

