/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.config.analysis;

import de.jiac.micro.config.analysis.BasicGuesser;
import de.jiac.micro.config.analysis.ClassInfo;
import de.jiac.micro.config.analysis.ClassInfoPool;
import de.jiac.micro.config.analysis.MethodKey;
import de.jiac.micro.config.analysis.RuntimeGuessValue;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

final class MethodAnalyser
extends MethodAdapter {
    protected static final HashSet<String> HANDLE_SOURCES;
    protected static final MethodKey GET_HANDLE;
    protected static final MethodKey GET_NODE_HANDLE;
    protected static final MethodKey ADD_HANDLES_ON;
    protected final ClassInfoPool.ClassInfoCreator parent;
    protected final MethodKey methodKey;

    MethodAnalyser(ClassInfoPool.ClassInfoCreator parent, int access, String name, String desc, String signature, String[] exceptions) {
        super((MethodVisitor)new MethodNode(access, name, desc, signature, exceptions));
        this.parent = parent;
        this.methodKey = new MethodKey(name, desc);
    }

    public void visitEnd() {
        final HashSet obtainedHandles = new HashSet();
        ClassInfo ci = this.parent.classInfo;
        MethodNode method = (MethodNode)this.mv;
        ci.referencedClassesInMethods.put(this.methodKey, new HashSet());
        this.processType(Type.getReturnType((String)method.desc));
        for (Type type : Type.getArgumentTypes((String)method.desc)) {
            this.processType(type);
        }
        BasicGuesser interpreter = new BasicGuesser(){

            public Value newOperation(AbstractInsnNode insn) {
                int op = insn.getOpcode();
                String className = null;
                if (op == 178) {
                    className = ((FieldInsnNode)insn).owner.replace('/', '.');
                } else if (op == 187) {
                    className = Type.getObjectType((String)((TypeInsnNode)insn).desc).getClassName();
                }
                MethodAnalyser.this.parent.registerDependencyForMethod(MethodAnalyser.this.methodKey, className);
                return super.newOperation(insn);
            }

            public Value unaryOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
                RuntimeGuessValue guessedValue;
                Type type;
                if (insn.getOpcode() == 176 && (MethodAnalyser.this.methodKey.equals(GET_HANDLE) || MethodAnalyser.this.methodKey.equals(GET_NODE_HANDLE)) && (type = (guessedValue = (RuntimeGuessValue)value).getType()) != null && guessedValue != RuntimeGuessValue.NULL_CONSTANT) {
                    MethodAnalyser.this.parent.classInfo.directHandle = type.getClassName();
                }
                return super.unaryOperation(insn, value);
            }

            public Value naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
                if (insn instanceof MethodInsnNode) {
                    RuntimeGuessValue guessValue;
                    Type type;
                    MethodInsnNode minsn = (MethodInsnNode)insn;
                    int opCode = minsn.getOpcode();
                    if (minsn.desc.endsWith(")Ljava/lang/Class;") && (minsn.name.equals("class$") || minsn.owner.equals("java/lang/Class") && minsn.name.equals("forName") || minsn.owner.endsWith("ClassLoader") && minsn.name.equals("loadClass"))) {
                        RuntimeGuessValue guessedValue = (RuntimeGuessValue)values.get(opCode == 184 ? 0 : 1);
                        String className = (String)guessedValue.getValue();
                        if (className != null) {
                            return new RuntimeGuessValue(Type.getObjectType((String)"java/lang/Class"), className);
                        }
                    } else if (HANDLE_SOURCES.contains(minsn.owner) && minsn.desc.equals("(Ljava/lang/Class;)Lde/jiac/micro/core/IHandle;") && (minsn.name.equals("getHandle") || minsn.name.equals("getScopeHandle"))) {
                        RuntimeGuessValue guessedValue = (RuntimeGuessValue)values.get(opCode == 184 ? 0 : 1);
                        String className = (String)guessedValue.getValue();
                        if (className != null) {
                            obtainedHandles.add(className);
                            MethodAnalyser.this.parent.registerDependencyForMethod(MethodAnalyser.this.methodKey, className);
                            String internalName = className.replace('.', '/');
                            return new RuntimeGuessValue(Type.getObjectType((String)internalName), null);
                        }
                    } else if (HANDLE_SOURCES.contains(minsn.owner) && minsn.name.equals("addHandle") && minsn.desc.equals("(Lde/jiac/micro/core/IHandle;)V") && (type = (guessValue = (RuntimeGuessValue)values.get(1)).getType()) != null) {
                        MethodAnalyser.this.parent.registerDependencyForMethod(MethodAnalyser.this.methodKey, type.getClassName());
                        MethodAnalyser.this.parent.classInfo.indirectHandles.add(type.getClassName());
                    }
                }
                return super.naryOperation(insn, values);
            }
        };
        Analyzer a = new Analyzer((Interpreter)interpreter);
        try {
            a.analyze(this.parent.owner, method);
        }
        catch (AnalyzerException e) {
            e.printStackTrace();
        }
        if (obtainedHandles.size() > 0) {
            ci.referencedHandlesInMethods.put(this.methodKey, obtainedHandles);
        }
    }

    private void processType(Type type) {
        if (type.getSort() == 9) {
            type = type.getElementType();
        }
        if (type.getSort() == 10) {
            this.parent.registerDependencyForMethod(this.methodKey, type.getClassName());
        }
    }

    static {
        GET_HANDLE = new MethodKey("getHandle", "()Lde/jiac/micro/core/IHandle;");
        GET_NODE_HANDLE = new MethodKey("getNodeHandle", "()Lde/jiac/micro/core/IHandle;");
        ADD_HANDLES_ON = new MethodKey("addHandlesOn", "(Lde/jiac/micro/core/scope/AgentScope;)V");
        HANDLE_SOURCES = new HashSet();
        HANDLE_SOURCES.add("de/jiac/micro/core/scope/Scope");
        HANDLE_SOURCES.add("de/jiac/micro/core/IAgent");
        HANDLE_SOURCES.add("de/jiac/micro/core/INode");
        HANDLE_SOURCES.add("de/jiac/micro/core/IContainer");
        HANDLE_SOURCES.add("de/jiac/micro/core/AbstractContainer");
    }
}

