/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.config.analysis;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.Value;

public class RuntimeGuessValue
implements Value {
    public static final RuntimeGuessValue UNINITIALISED_VALUE = new RuntimeGuessValue(null, null);
    public static final RuntimeGuessValue RETURNADDRESS_VALUE = new RuntimeGuessValue(null, null);
    public static final RuntimeGuessValue NULL_CONSTANT = new RuntimeGuessValue(Type.getObjectType((String)"java/lang/Object"), null);
    public static final RuntimeGuessValue IM1_CONSTANT = new RuntimeGuessValue(Type.INT_TYPE, -1);
    public static final RuntimeGuessValue I0_CONSTANT = new RuntimeGuessValue(Type.INT_TYPE, 0);
    public static final RuntimeGuessValue I1_CONSTANT = new RuntimeGuessValue(Type.INT_TYPE, 1);
    public static final RuntimeGuessValue I2_CONSTANT = new RuntimeGuessValue(Type.INT_TYPE, 2);
    public static final RuntimeGuessValue I3_CONSTANT = new RuntimeGuessValue(Type.INT_TYPE, 3);
    public static final RuntimeGuessValue I4_CONSTANT = new RuntimeGuessValue(Type.INT_TYPE, 4);
    public static final RuntimeGuessValue I5_CONSTANT = new RuntimeGuessValue(Type.INT_TYPE, 5);
    public static final RuntimeGuessValue L0_CONSTANT = new RuntimeGuessValue(Type.LONG_TYPE, 0L);
    public static final RuntimeGuessValue L1_CONSTANT = new RuntimeGuessValue(Type.LONG_TYPE, 1L);
    public static final RuntimeGuessValue F0_CONSTANT = new RuntimeGuessValue(Type.FLOAT_TYPE, Float.valueOf(0.0f));
    public static final RuntimeGuessValue F1_CONSTANT = new RuntimeGuessValue(Type.FLOAT_TYPE, Float.valueOf(1.0f));
    public static final RuntimeGuessValue F2_CONSTANT = new RuntimeGuessValue(Type.FLOAT_TYPE, Float.valueOf(2.0f));
    public static final RuntimeGuessValue D0_CONSTANT = new RuntimeGuessValue(Type.DOUBLE_TYPE, 0.0);
    public static final RuntimeGuessValue D1_CONSTANT = new RuntimeGuessValue(Type.DOUBLE_TYPE, 1.0);
    public static final RuntimeGuessValue UNSPECIFIED_INT_VALUE = new RuntimeGuessValue(Type.INT_TYPE, null);
    public static final RuntimeGuessValue UNSPECIFIED_FLOAT_VALUE = new RuntimeGuessValue(Type.FLOAT_TYPE, null);
    public static final RuntimeGuessValue UNSPECIFIED_LONG_VALUE = new RuntimeGuessValue(Type.LONG_TYPE, null);
    public static final RuntimeGuessValue UNSPECIFIED_DOUBLE_VALUE = new RuntimeGuessValue(Type.DOUBLE_TYPE, null);
    private final Type _type;
    private final Object _value;

    public RuntimeGuessValue(Type type, Object value) {
        this._type = type;
        this._value = value;
    }

    public Type getType() {
        return this._type;
    }

    public int getSize() {
        return this._type == Type.LONG_TYPE || this._type == Type.DOUBLE_TYPE ? 2 : 1;
    }

    public Object getValue() {
        return this._value;
    }

    public boolean equals(Object value) {
        if (value == this) {
            return true;
        }
        if (value instanceof RuntimeGuessValue) {
            RuntimeGuessValue other = (RuntimeGuessValue)value;
            return this.typeEquals(other) && this.valueEquals(other);
        }
        return false;
    }

    public boolean typeEquals(RuntimeGuessValue other) {
        if (this._type == null) {
            return other.getType() == null;
        }
        return this._type.equals((Object)other.getType());
    }

    public boolean valueEquals(RuntimeGuessValue other) {
        if (this._value == null) {
            return other.getValue() == null;
        }
        return this._value.equals(other.getValue());
    }

    public int hashCode() {
        int valHash = this._value == null ? 0 : this._value.hashCode();
        return this._type == null ? 0 : valHash ^ this._type.hashCode();
    }

    public String toString() {
        return "{" + String.valueOf(this._type) + " = " + String.valueOf(this._value) + "}";
    }
}

