/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.config.generator;

import de.dailab.jiac.common.aamm.IEntryType;
import de.dailab.jiac.common.aamm.IItemType;
import de.dailab.jiac.common.aamm.IModelBase;
import de.dailab.jiac.common.aamm.IPropertyType;
import de.dailab.jiac.common.aamm.IReferencableComplexType;
import de.dailab.jiac.common.aamm.ISimpleType;
import de.dailab.jiac.common.aamm.ListPropertyType;
import de.dailab.jiac.common.aamm.MapPropertyType;
import de.dailab.jiac.common.aamm.ReferencableAgentElementType;
import de.dailab.jiac.common.aamm.ReferencableAgentType;
import de.dailab.jiac.common.aamm.ReferencableNodeType;
import de.dailab.jiac.common.aamm.ReferencableObjectType;
import de.dailab.jiac.common.aamm.ReferencePropertyType;
import de.dailab.jiac.common.aamm.ReferenceType;
import de.dailab.jiac.common.aamm.SimplePropertyType;
import de.dailab.jiac.common.aamm.beans.Introspector;
import de.dailab.jiac.common.aamm.check.DefinitionChecker;
import de.dailab.jiac.common.aamm.check.Expression;
import de.dailab.jiac.common.aamm.ext.Reference;
import de.dailab.jiac.common.aamm.resolve.MergedConfiguration;
import de.dailab.jiac.common.aamm.resolve.ResolutionException;
import de.jiac.micro.config.analysis.ConventionEnforcer;
import de.jiac.micro.config.generator.AbstractConfiguration;
import de.jiac.micro.config.generator.AgentConfiguration;
import de.jiac.micro.config.generator.GeneratorException;
import de.jiac.micro.config.generator.NodeConfiguration;
import de.jiac.micro.config.util.MicroJIACToolContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationGenerator {
    private final ClassLoader _loader;
    private final Logger _logger;
    private final DateFormat _dateFormat;

    private ConfigurationGenerator(ClassLoader loader, Logger log) {
        this._loader = loader;
        this._logger = log;
        this._dateFormat = DateFormat.getDateTimeInstance();
    }

    public AbstractConfiguration[] generate(String packageName, MergedConfiguration configuration) throws ResolutionException {
        ArrayList<AbstractConfiguration> result = new ArrayList<AbstractConfiguration>();
        for (Reference nodeReference : configuration.nodesToUse) {
            HashSet<String> fqacn = new HashSet<String>();
            String className = nodeReference.toJavaIdentifier();
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            ReferencableNodeType node = configuration.getNode(nodeReference);
            this.writeHeader(writer);
            this.visitNode(configuration, writer, node, packageName, className, fqacn);
            writer.flush();
            writer.close();
            result.add(new NodeConfiguration(packageName + "." + className, buffer.getBuffer(), fqacn.toArray(new String[fqacn.size()])));
        }
        for (Reference agentReference : configuration.agentsToUse) {
            String className = agentReference.toJavaIdentifier();
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            ReferencableAgentType agent = configuration.getAgent(agentReference);
            this.writeHeader(writer);
            this.visitAgent(configuration, writer, agent, packageName, className);
            writer.flush();
            writer.close();
            result.add(new AgentConfiguration(packageName + "." + className, buffer.getBuffer()));
        }
        return result.toArray(new AbstractConfiguration[result.size()]);
    }

    public AbstractConfiguration[] generate(File targetDir, String packageName, MergedConfiguration configuration) throws IOException, ResolutionException {
        HashSet<AbstractConfiguration> descriptors = new HashSet<AbstractConfiguration>();
        for (Reference nodeReference : configuration.nodesToUse) {
            HashSet<String> fqacn = new HashSet<String>();
            String className = nodeReference.toJavaIdentifier();
            File sourceFile = new File(targetDir, className + ".java");
            PrintWriter writer = new PrintWriter(new FileOutputStream(sourceFile));
            ReferencableNodeType node = configuration.getNode(nodeReference);
            this.writeHeader(writer);
            this.visitNode(configuration, writer, node, packageName, className, fqacn);
            writer.flush();
            writer.close();
            descriptors.add(new NodeConfiguration(packageName + "." + className, null, fqacn.toArray(new String[fqacn.size()])));
        }
        for (Reference agentReference : configuration.agentsToUse) {
            String className = agentReference.toJavaIdentifier();
            File sourceFile = new File(targetDir, className + ".java");
            PrintWriter writer = new PrintWriter(new FileOutputStream(sourceFile));
            ReferencableAgentType agent = configuration.getAgent(agentReference);
            this.writeHeader(writer);
            this.visitAgent(configuration, writer, agent, packageName, className);
            writer.flush();
            writer.close();
            descriptors.add(new AgentConfiguration(packageName + "." + className, null));
        }
        return descriptors.toArray(new AbstractConfiguration[descriptors.size()]);
    }

    protected void visitNode(MergedConfiguration configuration, PrintWriter writer, ReferencableNodeType nodeType, String packageName, String className, HashSet<String> fullQualifiedAgentConfigurationNames) {
        String id = this.getJavaExpression(Reference.createFor(nodeType).toString());
        String displayName = this.getJavaExpression(nodeType.getDisplayName() == null ? nodeType.getId() : nodeType.getDisplayName());
        this._logger.info("generate configuration class: " + className);
        writer.println("package " + packageName + ";");
        writer.println("import de.jiac.micro.core.*;");
        writer.println("import de.jiac.micro.internal.core.*;");
        writer.println();
        writer.println("public class " + className + " extends AbstractNodeConfiguration {");
        writer.println("\t");
        this._logger.debug("generate constructor of node configuration");
        writer.println("\tpublic " + className + "() {");
        writer.println("\t\tsuper(" + id + ", " + displayName + ", " + nodeType.getClazz() + ".class, new String[]{");
        Iterator<ReferenceType> iter = nodeType.getAgentRefs().iterator();
        while (iter.hasNext()) {
            ReferenceType agentRef = iter.next();
            String fullQualifiedAgentConfigurationName = packageName + "." + Reference.createFrom(agentRef).toJavaIdentifier();
            fullQualifiedAgentConfigurationNames.add(fullQualifiedAgentConfigurationName);
            writer.append("\t\t\t\"").append(fullQualifiedAgentConfigurationName).print('\"');
            if (iter.hasNext()) {
                writer.print(',');
            }
            writer.println();
        }
        writer.println("\t\t});");
        writer.println("\t}");
        writer.println();
        HashSet<Reference> toProcess = new HashSet<Reference>();
        this._logger.debug("generate 'configureNode(AbstractNode node)'");
        writer.println("\tprotected void configureNode(AbstractNode node) {");
        this.insertPropertySetters("\t\t", writer, nodeType, "node", toProcess);
        writer.println("\t}");
        writer.println();
        this._logger.debug("generate get<full-qualified-id> object methods");
        HashSet<Reference> processed = new HashSet<Reference>();
        do {
            HashSet<Reference> temporarySet = new HashSet<Reference>(toProcess);
            toProcess.clear();
            for (Reference ref : temporarySet) {
                this.visitObject("\t", writer, configuration, ref, toProcess);
                processed.add(ref);
            }
            toProcess.removeAll(processed);
        } while (!toProcess.isEmpty());
        writer.println("}");
    }

    protected void visitAgent(MergedConfiguration configuration, PrintWriter writer, ReferencableAgentType agentType, String packageName, String className) throws ResolutionException {
        String id = this.getJavaExpression(Reference.createFor(agentType).toString());
        String displayName = this.getJavaExpression(agentType.getDisplayName() == null ? agentType.getId() : agentType.getDisplayName());
        Hashtable<String, ReferencableAgentType> properties = new Hashtable<String, ReferencableAgentType>();
        properties.put(id, agentType);
        this._logger.info("generate configuration class: " + className);
        writer.println("package " + packageName + ";");
        writer.println("import de.jiac.micro.core.*;");
        writer.println("import de.jiac.micro.internal.core.*;");
        writer.println();
        writer.println("public class " + className + " extends AbstractAgentConfiguration {");
        writer.println("\t");
        this._logger.debug("generate constructor of agent configuration");
        writer.println("\tpublic " + className + "() {");
        writer.append("\t\tsuper(").append(id).append(", ").append(displayName).append(", ").append(agentType.getClazz()).println(".class);");
        writer.println("\t}");
        writer.println();
        HashSet<Reference> toProcess = new HashSet<Reference>();
        this._logger.debug("generate 'configureAgent(AbstractAgent agent)'");
        writer.println("\tprotected void configureAgent(AbstractAgent agent){");
        for (IModelBase agentElementReference : agentType.getAgentElements()) {
            ReferencableAgentElementType ae = configuration.getAgentElement(agentElementReference);
            Reference ref = Reference.createFor(ae);
            toProcess.add(ref);
            writer.append("\t\t").append("agent.addAgentElement(get").append(ref.toJavaIdentifier()).println("());");
        }
        this.insertPropertySetters("\t\t", writer, agentType, "agent", toProcess);
        writer.println("\t}");
        writer.println();
        this._logger.debug("generate get<full-qualified-id> object methods");
        HashSet<Reference> processed = new HashSet<Reference>();
        do {
            HashSet<Reference> temporarySet = new HashSet<Reference>(toProcess);
            toProcess.clear();
            for (Reference ref : temporarySet) {
                this.visitObject("\t", writer, configuration, ref, toProcess);
                processed.add(ref);
            }
            toProcess.removeAll(processed);
        } while (!toProcess.isEmpty());
        writer.println("}");
    }

    protected void visitObject(String indent, PrintWriter writer, MergedConfiguration config, Reference ref, HashSet<Reference> toProcess) {
        String workIndent;
        IReferencableComplexType object = config.cache.get(ref);
        boolean singleton = object instanceof ReferencableObjectType && ((ReferencableObjectType)object).isSingleton();
        String identifier = ref.toJavaIdentifier();
        if (singleton) {
            writer.println(indent + "private " + object.getClazz() + " " + identifier + "= null;");
        }
        writer.println(indent + "protected final " + object.getClazz() + " get" + identifier + "() {");
        if (singleton) {
            writer.println(indent + "\tif(" + identifier + " == null) {");
            workIndent = indent + "\t\t";
            writer.println(workIndent + identifier + "= new " + object.getClazz() + "();");
        } else {
            workIndent = indent + "\t";
            writer.println(workIndent + object.getClazz() + " " + identifier + "= new " + object.getClazz() + "();");
        }
        this.insertPropertySetters(workIndent, writer, object, identifier, toProcess);
        if (singleton) {
            writer.println(indent + "\t}");
        }
        writer.println(indent + "\treturn " + identifier + ";");
        writer.println(indent + "}");
    }

    protected void visitSimpleProperty(String indent, PrintWriter writer, String variable, SimplePropertyType simplePropertyType) {
        Method setter = (Method)simplePropertyType.getMetaData("setterMethodKey");
        writer.append(indent);
        this.insertCastExpression(writer, variable, setter.getDeclaringClass());
        writer.println("." + setter.getName() + "(" + this.getJavaExpression(simplePropertyType) + ");");
    }

    private void insertListPropertyArrayInitialisation(String indent, PrintWriter writer, String typeName, List<IItemType> list, HashSet<Reference> toProcess) {
        writer.println("new " + typeName + "[]{");
        Iterator<IItemType> iter = list.iterator();
        while (iter.hasNext()) {
            IItemType item = iter.next();
            writer.print(indent + "\t");
            if (item instanceof ReferenceType) {
                Reference ref = Reference.createFrom((ReferenceType)((Object)item));
                toProcess.add(ref);
                writer.print("get" + ref.toJavaIdentifier() + "()");
            } else {
                writer.print(this.getJavaExpression((ISimpleType)((Object)item)));
            }
            writer.println(iter.hasNext() ? "," : "");
        }
        writer.print(indent + "}");
    }

    private void insertListPropertyListInitialisation(String indent, PrintWriter writer, String listVariable, Class<?> listType, List<IItemType> list, HashSet<Reference> toProcess) {
        String addMethod;
        try {
            Class<?> vectorClass = Introspector.loadClass(listType, "java.util.Vector");
            if (vectorClass.isAssignableFrom(listType)) {
                writer.println(indent + listType.getName() + " " + listVariable + "= new " + listType.getName() + "();");
                addMethod = "addElement";
            } else {
                if (listType.isInterface()) {
                    writer.println(indent + "java.util.ArrayList " + listVariable + "= new java.util.ArrayList();");
                } else {
                    writer.println(indent + listType.getName() + " " + listVariable + "= " + listType.getName() + "();");
                }
                addMethod = "add";
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        for (IItemType item : list) {
            writer.print(indent + listVariable + "." + addMethod + "(");
            if (item instanceof ReferenceType) {
                Reference ref = Reference.createFrom((ReferenceType)((Object)item));
                toProcess.add(ref);
                writer.print("get" + ref.toJavaIdentifier() + "()");
            } else {
                writer.print(this.getJavaExpression((ISimpleType)((Object)item)));
            }
            writer.println(");");
        }
    }

    protected void visitListProperty(String indent, PrintWriter writer, String variable, ListPropertyType listPropertyType, HashSet<Reference> toProcess) {
        List<IItemType> list = listPropertyType.getItems();
        if (list.size() <= 0) {
            return;
        }
        Method setter = (Method)listPropertyType.getMetaData("setterMethodKey");
        if (setter != null) {
            Class<?> paramType = setter.getParameterTypes()[0];
            if (paramType.isArray()) {
                writer.append(indent);
                this.insertCastExpression(writer, variable, setter.getDeclaringClass());
                writer.print("." + setter.getName() + "(");
                this.insertListPropertyArrayInitialisation(indent, writer, paramType.getComponentType().getName(), list, toProcess);
                writer.println(");");
            } else {
                String listVariable = listPropertyType.getName();
                this.insertListPropertyListInitialisation(indent, writer, listVariable, paramType, list, toProcess);
                writer.append(indent);
                this.insertCastExpression(writer, listVariable, setter.getDeclaringClass());
                writer.println("." + setter.getName() + "(" + listVariable + ");");
            }
        } else {
            Method indexedSetter = null;
            int last = list.size() - 1;
            for (int i = 0; i <= last; ++i) {
                IItemType item = list.get(i);
                if (indexedSetter == null) {
                    indexedSetter = (Method)item.getMetaData("setterMethodKey");
                }
                writer.append(indent);
                this.insertCastExpression(writer, variable, indexedSetter.getDeclaringClass());
                writer.print("." + indexedSetter.getName() + "(" + i + ", ");
                if (item instanceof ReferenceType) {
                    Reference ref = Reference.createFrom((ReferenceType)((Object)item));
                    toProcess.add(ref);
                    writer.print("get" + ref.toJavaIdentifier() + "()");
                } else {
                    writer.print(this.getJavaExpression((ISimpleType)((Object)item)));
                }
                writer.println(");");
            }
        }
    }

    protected void visitMapProperty(String indent, PrintWriter writer, String variable, MapPropertyType mapPropertyType, HashSet<Reference> toProcess) {
        Method setter = (Method)mapPropertyType.getMetaData("setterMethodKey");
        if (setter != null) {
            Class<?> paramType = setter.getParameterTypes()[0];
            String typeName = paramType.isInterface() ? "java.util.Hashtable" : paramType.getName();
            writer.println(indent + typeName + " " + mapPropertyType.getName() + "= new " + typeName + "();");
            for (IEntryType entry : mapPropertyType.getEntries()) {
                writer.print(indent + mapPropertyType.getName() + ".put(" + this.getJavaExpression(entry.getKey()) + ", ");
                if (entry instanceof ReferenceType) {
                    Reference ref = Reference.createFrom((ReferenceType)((Object)entry));
                    toProcess.add(ref);
                    writer.print("get" + ref.toJavaIdentifier() + "()");
                } else {
                    writer.print(this.getJavaExpression((ISimpleType)((Object)entry)));
                }
                writer.println(");");
                writer.append(indent);
                this.insertCastExpression(writer, variable, setter.getDeclaringClass());
                writer.println("." + setter.getName() + "(" + mapPropertyType.getName() + ");");
            }
        } else {
            Method mappedSetter = null;
            for (IEntryType entry : mapPropertyType.getEntries()) {
                if (mappedSetter == null) {
                    mappedSetter = (Method)entry.getMetaData("setterMethodKey");
                }
                writer.append(indent);
                this.insertCastExpression(writer, variable, mappedSetter.getDeclaringClass());
                writer.print("." + mappedSetter.getName() + "(" + this.getJavaExpression(entry.getKey()) + ", ");
                if (entry instanceof ReferenceType) {
                    Reference ref = Reference.createFrom((ReferenceType)((Object)entry));
                    toProcess.add(ref);
                    writer.print("get" + ref.toJavaIdentifier() + "()");
                } else {
                    writer.print(this.getJavaExpression((ISimpleType)((Object)entry)));
                }
                writer.println(");");
            }
        }
    }

    protected void visitObjectProperty(String indent, PrintWriter writer, String variable, ReferencePropertyType objectReferencePropertyType, HashSet<Reference> toProcess) {
        Method setter = (Method)objectReferencePropertyType.getMetaData("setterMethodKey");
        Reference ref = Reference.createFrom(objectReferencePropertyType);
        toProcess.add(ref);
        writer.append(indent);
        this.insertCastExpression(writer, variable, setter.getDeclaringClass());
        writer.println("." + setter.getName() + "(get" + ref.toJavaIdentifier() + "());");
    }

    private String getJavaExpression(ISimpleType value) {
        Expression expr = Expression.parseAndConvertToJavaExpression(value.getValue(), this._loader);
        return expr.convertToJavaExpression((Class)value.getMetaData("classtype"));
    }

    private String getJavaExpression(String string) {
        Expression expr = Expression.parseAndConvertToJavaExpression(string, this._loader);
        return expr.convertToJavaExpression(String.class);
    }

    private void insertCastExpression(PrintWriter writer, String variable, Class<?> type) {
        writer.append("((").append(type.getName()).append(')').append(variable).append(')');
    }

    private void insertPropertySetters(String workIndent, PrintWriter writer, IReferencableComplexType object, String identifier, HashSet<Reference> toProcess) {
        for (IPropertyType property : object.getProperties()) {
            if (property instanceof SimplePropertyType) {
                this.visitSimpleProperty(workIndent, writer, identifier, (SimplePropertyType)property);
                continue;
            }
            if (property instanceof ListPropertyType) {
                this.visitListProperty(workIndent, writer, identifier, (ListPropertyType)property, toProcess);
                continue;
            }
            if (property instanceof MapPropertyType) {
                this.visitMapProperty(workIndent, writer, identifier, (MapPropertyType)property, toProcess);
                continue;
            }
            this.visitObjectProperty(workIndent, writer, identifier, (ReferencePropertyType)property, toProcess);
        }
    }

    private void writeHeader(PrintWriter writer) {
        writer.println("//");
        writer.println("// This file was generated by the Configuration Generator for MicroJIAC.");
        writer.println("// Any modifications to this file will be lost upon re-running the configurator!");
        writer.append("// Generated on: ").println(this._dateFormat.format(new Date(System.currentTimeMillis())));
        writer.println("//");
        writer.println();
        writer.println();
    }

    public static AbstractConfiguration[] execute(String applicationNamespace, ClassLoader loader, Logger log) throws Exception {
        String packageName = "de.jiac.micro.internal.latebind";
        MicroJIACToolContext context = new MicroJIACToolContext(loader);
        ConfigurationGenerator generator = new ConfigurationGenerator(context.getLoader(), log);
        MergedConfiguration conf = context.createResolver().resolveAndMerge(applicationNamespace);
        DefinitionChecker.CheckerResult checkerResult = context.createChecker().flattenAndCheck(conf);
        for (String warning : checkerResult.warnings) {
            log.warn(warning);
        }
        for (String error : checkerResult.errors) {
            log.error(error);
        }
        if (checkerResult.hasErrors()) {
            throw new GeneratorException("checker has found errors");
        }
        return generator.generate(packageName, conf);
    }

    public static AbstractConfiguration[] execute(File rootDirectory, String applicationNamespace, ClassLoader loader, Logger log) throws Exception {
        String packageName = "de.jiac.micro.internal.latebind";
        File lateBindDirectory = new File(rootDirectory, packageName.replace('.', File.separatorChar));
        if (!lateBindDirectory.exists()) {
            lateBindDirectory.mkdirs();
        }
        MicroJIACToolContext context = new MicroJIACToolContext(loader);
        ConfigurationGenerator generator = new ConfigurationGenerator(context.getLoader(), log);
        MergedConfiguration conf = context.createResolver().resolveAndMerge(applicationNamespace);
        DefinitionChecker.CheckerResult checkerResult = context.createChecker().flattenAndCheck(conf);
        for (String warning : checkerResult.warnings) {
            log.warn(warning);
        }
        for (String error : checkerResult.errors) {
            log.error(error);
        }
        if (checkerResult.hasErrors()) {
            throw new GeneratorException("checker has found errors");
        }
        ConventionEnforcer analyser = context.createEnforcer();
        analyser.analyseAndEnforce(conf);
        return generator.generate(lateBindDirectory, packageName, conf);
    }
}

