/*
 * Decompiled with CFR 0.152.
 */
package de.jmens.google.authenticator;

import de.jmens.google.authenticator.OtpGenerator;

public class OneTimePassVerifier {
    private static final OtpGenerator algorithm = new OtpGenerator();
    private byte[] secret;
    private long timestamp = System.currentTimeMillis();
    private int window = 3;

    public static OneTimePassVerifier newVerifier(String secret) {
        return new OneTimePassVerifier(secret.getBytes());
    }

    public static OneTimePassVerifier newVerifier(byte[] secret) {
        return new OneTimePassVerifier(secret);
    }

    private OneTimePassVerifier(byte[] secret) {
        this.secret = secret;
    }

    public OneTimePassVerifier withTimeWindow(int seconds) {
        this.window = seconds;
        return this;
    }

    public OneTimePassVerifier forTimestamp(long milliseconds) {
        this.timestamp = milliseconds;
        return this;
    }

    public boolean checkCode(long code) {
        return algorithm.verify(new String(this.secret), code, this.timestamp, this.window);
    }

    public long getCode() {
        return algorithm.getCode(new String(this.secret), this.timestamp);
    }
}

