/*
 * Decompiled with CFR 0.152.
 */
package de.jmens.google.authenticator;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.stream.IntStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;

public final class OtpGenerator {
    public static OtpGenerator newOtpGenerator() {
        return new OtpGenerator();
    }

    OtpGenerator() {
    }

    public boolean verify(String secret, long code) {
        return code == this.getCode(secret);
    }

    public boolean verify(String secret, long code, long timestamp) {
        return code == this.getCode(secret, timestamp);
    }

    public boolean verify(String secret, long code, int window) {
        byte[] decodedSecret = this.decode(secret);
        long timestamp = System.currentTimeMillis();
        return IntStream.range(0, window).boxed().anyMatch(i -> code == (long)this.getCode(decodedSecret, timestamp - (long)(i * 1000)) || code == (long)this.getCode(decodedSecret, timestamp + (long)(i * 1000)));
    }

    public boolean verify(String secret, long code, long timestamp, int window) {
        byte[] decodedSecret = this.decode(secret);
        return IntStream.range(0, window).boxed().anyMatch(i -> code == (long)this.getCode(decodedSecret, timestamp - (long)(i * 1000)) || code == (long)this.getCode(decodedSecret, timestamp + (long)(i * 1000)));
    }

    public long getCode(String secret) {
        return this.getCode(secret, System.currentTimeMillis());
    }

    public long getCode(String secret, long timestamp) {
        return this.getCode(this.decode(secret), timestamp);
    }

    private int getCode(byte[] key, long timestamp) {
        byte[] data = this.buildData(timestamp / 1000L);
        byte[] hash = this.hashData(key, data);
        return this.truncateHash(hash);
    }

    private byte[] buildData(long timestamp) {
        byte[] data = new byte[8];
        long value = timestamp / 30L;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        return data;
    }

    private byte[] hashData(byte[] key, byte[] data) {
        try {
            SecretKeySpec signKey = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signKey);
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to verify code", e);
        }
    }

    private int truncateHash(byte[] hash) {
        int offset = hash[19] & 0xF;
        long result = 0L;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result |= (long)(hash[offset + i] & 0xFF);
        }
        result &= Integer.MAX_VALUE;
        return (int)(result %= 1000000L);
    }

    private byte[] decode(String secret) {
        return new Base32().decode(secret);
    }
}

