/*
 * Decompiled with CFR 0.152.
 */
package de.jmens.google.authenticator;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Optional;

public class QrCodeGenerator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<byte[]> generateQRCodePng(String secret, String application, int size) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            String text = MessageFormat.format("otpauth://totp/{0}?secret={1}", URLEncoder.encode(application, "UTF-8"), URLEncoder.encode(secret, "UTF-8"));
            EnumMap<EncodeHintType, Object> hintMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
            hintMap.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
            hintMap.put(EncodeHintType.MARGIN, (Object)1);
            hintMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.H);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, size, size, hintMap);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)output);
            Optional<byte[]> optional = Optional.ofNullable(output.toByteArray());
            return optional;
        }
        catch (WriterException | IOException e) {
            return Optional.empty();
        }
    }
}

