/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.service;

import de.jnkconsulting.e3dc.easyrscp.api.connection.ConnectionPool;
import de.jnkconsulting.e3dc.easyrscp.api.connection.HomePowerPlantConnection;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Frame;
import de.jnkconsulting.e3dc.easyrscp.api.service.DBSummaryService;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.HistoryData;
import de.jnkconsulting.e3dc.easyrscp.service.DefaultDBSummaryService;
import de.jnkconsulting.e3dc.easyrscp.service.converter.RequestResponseFrameConvert;
import de.jnkconsulting.e3dc.easyrscp.service.converter.db.DailySummaryConverter;
import de.jnkconsulting.e3dc.easyrscp.service.converter.db.MonthlySummaryConverter;
import de.jnkconsulting.e3dc.easyrscp.service.converter.db.YearlySummaryConverter;
import de.jnkconsulting.e3dc.easyrscp.service.creator.FrameCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.db.ReadDailySummaryCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.db.ReadMonthlySummaryCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.db.ReadYearlySummaryCreator;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/service/DefaultDBSummaryService;", "Lde/jnkconsulting/e3dc/easyrscp/api/service/DBSummaryService;", "connectionPool", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/ConnectionPool;", "convertFrameToDailySummary", "Lde/jnkconsulting/e3dc/easyrscp/service/converter/RequestResponseFrameConvert;", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/HistoryData;", "convertFrameToMonthlySummary", "convertFrameToYearlySummary", "createRequestDailySummaryFrame", "Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;", "Ljava/time/LocalDate;", "createRequestMonthlySummaryFrame", "Ljava/time/YearMonth;", "createRequestYearlySummaryFrame", "Ljava/time/Year;", "(Lde/jnkconsulting/e3dc/easyrscp/api/connection/ConnectionPool;Lde/jnkconsulting/e3dc/easyrscp/service/converter/RequestResponseFrameConvert;Lde/jnkconsulting/e3dc/easyrscp/service/converter/RequestResponseFrameConvert;Lde/jnkconsulting/e3dc/easyrscp/service/converter/RequestResponseFrameConvert;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;)V", "logger", "Lmu/KLogger;", "readDailySummary", "day", "readMonthlySummary", "yearMonth", "readYearlySummary", "year", "jnk-easy-rscp-service"})
public final class DefaultDBSummaryService
implements DBSummaryService {
    @NotNull
    private final ConnectionPool connectionPool;
    @NotNull
    private final RequestResponseFrameConvert<HistoryData> convertFrameToDailySummary;
    @NotNull
    private final RequestResponseFrameConvert<HistoryData> convertFrameToMonthlySummary;
    @NotNull
    private final RequestResponseFrameConvert<HistoryData> convertFrameToYearlySummary;
    @NotNull
    private final FrameCreator<LocalDate> createRequestDailySummaryFrame;
    @NotNull
    private final FrameCreator<YearMonth> createRequestMonthlySummaryFrame;
    @NotNull
    private final FrameCreator<Year> createRequestYearlySummaryFrame;
    @NotNull
    private final KLogger logger;

    public DefaultDBSummaryService(@NotNull ConnectionPool connectionPool, @NotNull RequestResponseFrameConvert<HistoryData> convertFrameToDailySummary, @NotNull RequestResponseFrameConvert<HistoryData> convertFrameToMonthlySummary, @NotNull RequestResponseFrameConvert<HistoryData> convertFrameToYearlySummary, @NotNull FrameCreator<LocalDate> createRequestDailySummaryFrame, @NotNull FrameCreator<YearMonth> createRequestMonthlySummaryFrame, @NotNull FrameCreator<Year> createRequestYearlySummaryFrame) {
        Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter(convertFrameToDailySummary, (String)"convertFrameToDailySummary");
        Intrinsics.checkNotNullParameter(convertFrameToMonthlySummary, (String)"convertFrameToMonthlySummary");
        Intrinsics.checkNotNullParameter(convertFrameToYearlySummary, (String)"convertFrameToYearlySummary");
        Intrinsics.checkNotNullParameter(createRequestDailySummaryFrame, (String)"createRequestDailySummaryFrame");
        Intrinsics.checkNotNullParameter(createRequestMonthlySummaryFrame, (String)"createRequestMonthlySummaryFrame");
        Intrinsics.checkNotNullParameter(createRequestYearlySummaryFrame, (String)"createRequestYearlySummaryFrame");
        this.connectionPool = connectionPool;
        this.convertFrameToDailySummary = convertFrameToDailySummary;
        this.convertFrameToMonthlySummary = convertFrameToMonthlySummary;
        this.convertFrameToYearlySummary = convertFrameToYearlySummary;
        this.createRequestDailySummaryFrame = createRequestDailySummaryFrame;
        this.createRequestMonthlySummaryFrame = createRequestMonthlySummaryFrame;
        this.createRequestYearlySummaryFrame = createRequestYearlySummaryFrame;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    public /* synthetic */ DefaultDBSummaryService(ConnectionPool connectionPool, RequestResponseFrameConvert requestResponseFrameConvert, RequestResponseFrameConvert requestResponseFrameConvert2, RequestResponseFrameConvert requestResponseFrameConvert3, FrameCreator frameCreator, FrameCreator frameCreator2, FrameCreator frameCreator3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            requestResponseFrameConvert = new DailySummaryConverter();
        }
        if ((n & 4) != 0) {
            requestResponseFrameConvert2 = new MonthlySummaryConverter();
        }
        if ((n & 8) != 0) {
            requestResponseFrameConvert3 = new YearlySummaryConverter();
        }
        if ((n & 0x10) != 0) {
            frameCreator = new ReadDailySummaryCreator();
        }
        if ((n & 0x20) != 0) {
            frameCreator2 = new ReadMonthlySummaryCreator();
        }
        if ((n & 0x40) != 0) {
            frameCreator3 = new ReadYearlySummaryCreator();
        }
        this(connectionPool, requestResponseFrameConvert, requestResponseFrameConvert2, requestResponseFrameConvert3, frameCreator, frameCreator2, frameCreator3);
    }

    @NotNull
    public HistoryData readDailySummary(@NotNull LocalDate day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        return (HistoryData)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, HistoryData>(this, day){
            final /* synthetic */ DefaultDBSummaryService this$0;
            final /* synthetic */ LocalDate $day;
            {
                this.this$0 = $receiver;
                this.$day = $day;
                super(1);
            }

            @NotNull
            public final HistoryData invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Frame request = (Frame)DefaultDBSummaryService.access$getCreateRequestDailySummaryFrame$p(this.this$0).invoke(this.$day);
                DefaultDBSummaryService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(this.$day, request){
                    final /* synthetic */ LocalDate $day;
                    final /* synthetic */ Frame $request;
                    {
                        this.$day = $day;
                        this.$request = $request;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Requesting summary of day " + this.$day + ": " + this.$request;
                    }
                });
                Frame response = it.send(request);
                DefaultDBSummaryService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(this.$day, response){
                    final /* synthetic */ LocalDate $day;
                    final /* synthetic */ Frame $response;
                    {
                        this.$day = $day;
                        this.$response = $response;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Received summary of day " + this.$day + ": " + this.$response;
                    }
                });
                return (HistoryData)DefaultDBSummaryService.access$getConvertFrameToDailySummary$p(this.this$0).invoke(request, response);
            }
        });
    }

    @NotNull
    public HistoryData readMonthlySummary(@NotNull YearMonth yearMonth) {
        Intrinsics.checkNotNullParameter((Object)yearMonth, (String)"yearMonth");
        return (HistoryData)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, HistoryData>(this, yearMonth){
            final /* synthetic */ DefaultDBSummaryService this$0;
            final /* synthetic */ YearMonth $yearMonth;
            {
                this.this$0 = $receiver;
                this.$yearMonth = $yearMonth;
                super(1);
            }

            @NotNull
            public final HistoryData invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Frame request = (Frame)DefaultDBSummaryService.access$getCreateRequestMonthlySummaryFrame$p(this.this$0).invoke(this.$yearMonth);
                DefaultDBSummaryService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(this.$yearMonth, request){
                    final /* synthetic */ YearMonth $yearMonth;
                    final /* synthetic */ Frame $request;
                    {
                        this.$yearMonth = $yearMonth;
                        this.$request = $request;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Requesting summary of month " + this.$yearMonth + ": " + this.$request;
                    }
                });
                Frame response = it.send(request);
                DefaultDBSummaryService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(this.$yearMonth, response){
                    final /* synthetic */ YearMonth $yearMonth;
                    final /* synthetic */ Frame $response;
                    {
                        this.$yearMonth = $yearMonth;
                        this.$response = $response;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Received summary of month " + this.$yearMonth + ": " + this.$response;
                    }
                });
                return (HistoryData)DefaultDBSummaryService.access$getConvertFrameToMonthlySummary$p(this.this$0).invoke(request, response);
            }
        });
    }

    @NotNull
    public HistoryData readYearlySummary(@NotNull Year year) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        return (HistoryData)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, HistoryData>(this, year){
            final /* synthetic */ DefaultDBSummaryService this$0;
            final /* synthetic */ Year $year;
            {
                this.this$0 = $receiver;
                this.$year = $year;
                super(1);
            }

            @NotNull
            public final HistoryData invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Frame request = (Frame)DefaultDBSummaryService.access$getCreateRequestYearlySummaryFrame$p(this.this$0).invoke(this.$year);
                DefaultDBSummaryService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(this.$year, request){
                    final /* synthetic */ Year $year;
                    final /* synthetic */ Frame $request;
                    {
                        this.$year = $year;
                        this.$request = $request;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Requesting summary of year " + this.$year + ": " + this.$request;
                    }
                });
                Frame response = it.send(request);
                DefaultDBSummaryService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(this.$year, response){
                    final /* synthetic */ Year $year;
                    final /* synthetic */ Frame $response;
                    {
                        this.$year = $year;
                        this.$response = $response;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Received summary of year " + this.$year + ": " + this.$response;
                    }
                });
                return (HistoryData)DefaultDBSummaryService.access$getConvertFrameToYearlySummary$p(this.this$0).invoke(request, response);
            }
        });
    }

    public static final /* synthetic */ FrameCreator access$getCreateRequestDailySummaryFrame$p(DefaultDBSummaryService $this) {
        return $this.createRequestDailySummaryFrame;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(DefaultDBSummaryService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ RequestResponseFrameConvert access$getConvertFrameToDailySummary$p(DefaultDBSummaryService $this) {
        return $this.convertFrameToDailySummary;
    }

    public static final /* synthetic */ FrameCreator access$getCreateRequestMonthlySummaryFrame$p(DefaultDBSummaryService $this) {
        return $this.createRequestMonthlySummaryFrame;
    }

    public static final /* synthetic */ RequestResponseFrameConvert access$getConvertFrameToMonthlySummary$p(DefaultDBSummaryService $this) {
        return $this.convertFrameToMonthlySummary;
    }

    public static final /* synthetic */ FrameCreator access$getCreateRequestYearlySummaryFrame$p(DefaultDBSummaryService $this) {
        return $this.createRequestYearlySummaryFrame;
    }

    public static final /* synthetic */ RequestResponseFrameConvert access$getConvertFrameToYearlySummary$p(DefaultDBSummaryService $this) {
        return $this.convertFrameToYearlySummary;
    }
}

