/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.service.converter;

import de.jnkconsulting.e3dc.easyrscp.api.bytes.ByteHelperKt;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Data;
import de.jnkconsulting.e3dc.easyrscp.api.frame.DataParser;
import de.jnkconsulting.e3dc.easyrscp.api.frame.DataType;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Frame;
import de.jnkconsulting.e3dc.easyrscp.api.frame.tags.RSCPTag;
import de.jnkconsulting.e3dc.easyrscp.service.converter.FrameConverter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0011\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/service/converter/StringFrameConverter;", "Lde/jnkconsulting/e3dc/easyrscp/service/converter/FrameConverter;", "", "omitAuthenticationCredentials", "", "(Z)V", "convertData", "toPrint", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Data;", "level", "", "parser", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/DataParser;", "invoke", "frame", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Frame;", "shouldMask", "Companion", "jnk-easy-rscp-service"})
@SourceDebugExtension(value={"SMAP\nStringFrameConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringFrameConverter.kt\nde/jnkconsulting/e3dc/easyrscp/service/converter/StringFrameConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1855#2,2:66\n1855#2,2:68\n*S KotlinDebug\n*F\n+ 1 StringFrameConverter.kt\nde/jnkconsulting/e3dc/easyrscp/service/converter/StringFrameConverter\n*L\n29#1:66,2\n41#1:68,2\n*E\n"})
public final class StringFrameConverter
implements FrameConverter<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean omitAuthenticationCredentials;
    @NotNull
    private static final Set<RSCPTag> TAGS_TO_OMIT;

    public StringFrameConverter(boolean omitAuthenticationCredentials) {
        this.omitAuthenticationCredentials = omitAuthenticationCredentials;
    }

    public /* synthetic */ StringFrameConverter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @NotNull
    public String invoke(@NotNull Frame frame) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        StringBuilder out = stringBuilder = new StringBuilder().append("Timestamp:\t" + frame.getTimestamp() + "\n").append("WithChecksum:\t" + frame.isChecksumEnabled() + "\n");
        boolean bl = false;
        Iterable $this$forEach$iv = frame.getData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Data it = (Data)element$iv;
            boolean bl2 = false;
            out.append(this.convertData(it, 1, frame.getParser()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String convertData(Data toPrint, int level, DataParser parser) {
        String tabs = StringsKt.repeat((CharSequence)"\t", (int)level);
        Object object = new byte[]{toPrint.getType()};
        StringBuilder result = new StringBuilder().append(tabs + "Tag:\t" + toPrint.tagObject().getNamespace() + "." + toPrint.tagObject() + " - " + ByteHelperKt.toHexString((byte[])toPrint.getTag()) + "\n").append(tabs + "Type:\t" + toPrint.typeObject() + " - " + ByteHelperKt.toHexString((byte[])object) + "\n");
        if (toPrint.typeObject() == DataType.CONTAINER) {
            void $this$forEach$iv;
            object = toPrint.valueAsContainer(parser);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Data it = (Data)element$iv;
                boolean bl = false;
                result.append(this.convertData(it, level + 1, parser)).append("\n");
            }
        } else {
            result.append(tabs + "Value:\t");
            if (this.shouldMask(toPrint)) {
                result.append("*** - ***\n");
            } else {
                result.append(toPrint.valueAsString() + " - " + ByteHelperKt.toHexString((byte[])toPrint.getValue()) + "\n");
            }
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean shouldMask(Data toPrint) {
        return this.omitAuthenticationCredentials && CollectionsKt.contains((Iterable)TAGS_TO_OMIT, (Object)toPrint.tagObject());
    }

    public StringFrameConverter() {
        this(false, 1, null);
    }

    static {
        Object[] objectArray = new RSCPTag[]{RSCPTag.AUTHENTICATION_USER, RSCPTag.AUTHENTICATION_PASSWORD, RSCPTag.REQ_SET_ENCRYPTION_PASSPHRASE};
        TAGS_TO_OMIT = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/service/converter/StringFrameConverter$Companion;", "", "()V", "TAGS_TO_OMIT", "", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/tags/RSCPTag;", "getTAGS_TO_OMIT", "()Ljava/util/Set;", "jnk-easy-rscp-service"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<RSCPTag> getTAGS_TO_OMIT() {
            return TAGS_TO_OMIT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

