/**
 * NestedJsonConfig.java
 *
 * Copyright 2016 Joshua Schnabel (github@joshua-schnabel.de)
 * 
 * Created: 02.11.2016 12:53:52
 * Part of: jsConfig
 * 
 * For licence informations check the LICENCE file!
 */
package de.joshuaschnabel.config.json;

/**
 * @author Joshua Schnabel
 *
 */
public class NestedJsonConfig extends JsonConfig
{

	private JsonConfig defaultConfig;

	/**
	 * 
	 *
	 * @param defaultConfig
	 * @see NestedJsonConfig
	 */
	public NestedJsonConfig(JsonConfig defaultConfig)
	{
		super();
		this.defaultConfig = defaultConfig;
	}

	@Override
	public String getProperty(String path)
	{
		String value = super.getProperty(path);
		if (value == null) return this.defaultConfig.getProperty(path);
		return value;
	}
}
