/**
 * ConfigFolder.java
 *
 * Copyright 2016 Joshua Schnabel (github@joshua-schnabel.de)
 * 
 * Created: 29.10.2016 10:40:28
 * Part of: jsConfig
 * 
 * For licence informations check the LICENCE file!
 */
package de.joshuaschnabel.config.json.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

/**
 * @author Joshua Schnabel
 *
 */
public class ConfigFolder extends ConfigObject implements Iterable<ConfigObject>
{
	private HashSet<ConfigObject> entries;

	/**
	 * @param name
	 *
	 * @see ConfigFolder
	 */
	public ConfigFolder(String name)
	{
		super(name);
		this.entries = new HashSet<>();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Iterable#iterator()
	 */
	@Override
	public Iterator<ConfigObject> iterator()
	{
		return this.entries.iterator();
	}

	/**
	 * Get element by name
	 * 
	 * @param name
	 *           of element
	 * @return element
	 */
	public ConfigObject getByName(String name)
	{
		for (ConfigObject configObject : this)
		{
			if (name.equals(configObject.getName())) return configObject;
		}
		return null;
	}

	/**
	 * @param configEntry
	 * @return {@link ArrayList#add(Object)}
	 */
	public boolean add(ConfigObject configEntry)
	{
		return this.entries.add(configEntry);
	}

	// /**
	// * @param configEntry
	// * @return @see {@link ArrayList#remove(Object)}
	// */
	// public boolean remove(ConfigObject configEntry)
	// {
	// return this.entries.remove(configEntry);
	// }

	/**
	 * @param name
	 * @return boolean value
	 */
	public boolean existsByName(String name)
	{
		return getByName(name) != null;
	}

	/**
	 * @return elememnt count
	 */
	public int entriesSize()
	{
		return this.entries.size();
	}

}
