/**
 * ConfigObject.java
 *
 * Copyright 2016 Joshua Schnabel (github@joshua-schnabel.de)
 * 
 * Created: 29.10.2016 10:36:55
 * Part of: jsConfig
 * 
 * For licence informations check the LICENCE file!
 */
package de.joshuaschnabel.config.json.objects;

/**
 * @author Joshua Schnabel
 *
 */

public abstract class ConfigObject
{
	private String name;

	/**
	 * Abstract Config Object
	 *
	 * @param name
	 *           Name of the ConfigObject
	 * @see ConfigObject
	 */
	public ConfigObject(String name)
	{
		this.name = name;
	}

	/**
	 * @return the name
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * @param class1
	 * @return boolean value
	 */
	public boolean is(Class<?> class1)
	{
		return this.getClass().equals(class1);
	}

}
