/**
 * JsonSerializer.java
 *
 * Copyright 2016 Joshua Schnabel
 * 
 * Created: 08.11.2016 21:34:19
 * Part of: jsConfig
 * 
 * For licence informations check the LICENCE file!
 */
package de.joshuaschnabel.config.json.serializer;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonObject.Member;

import de.joshuaschnabel.config.json.objects.ConfigEntry;
import de.joshuaschnabel.config.json.objects.ConfigFolder;
import de.joshuaschnabel.config.json.objects.ConfigObject;

/**
 * @author Joshua Schnabel
 *
 *         TODO Description
 *
 */
public class JsonSerializer
{

	/**
	 * Deserialize a ConfigFolder to a JsonObject
	 * 
	 * @param folder
	 *           - a ConfigFolder
	 * @return a serialised JsonObject
	 */
	public static JsonObject serialize(ConfigFolder folder)
	{
		JsonObject object = Json.object();

		for (ConfigObject element : folder)
		{
			serializeRecursive(object, element);
		}

		return object;
	}

	private static void serializeRecursive(JsonObject object, ConfigObject element)
	{
		if (element.is(ConfigFolder.class))
		{
			JsonObject tobject = Json.object();
			object.add(element.getName(), tobject);

			for (ConfigObject co : (ConfigFolder) element)
			{
				serializeRecursive(tobject, co);
			}

		}
		else
		{
			ConfigEntry entry = (ConfigEntry) element;
			object.add(entry.getName(), entry.getValue());
		}
	}

	/**
	 * Deserialize a JsonObject to a ConfigFolder
	 * 
	 * @param object
	 *           - JsonObject
	 * @return a ConfigFolder
	 */
	public static ConfigFolder deserialize(JsonObject object)
	{
		ConfigFolder root = new ConfigFolder("root");

		deserializeRecursive(object, root);

		return root;
	}

	/**
	 * @param object
	 * @param root
	 */
	private static void deserializeRecursive(JsonObject object, ConfigFolder root)
	{
		for (Member member : object)
		{
			if (member.getValue().isString())
			{
				root.add(new ConfigEntry(member.getName(), member.getValue().asString()));
			}
			else
			{
				ConfigFolder folder = new ConfigFolder(member.getName());
				root.add(folder);
				deserializeRecursive(member.getValue().asObject(), folder);
			}
		}

	}

}
