/*
 * Decompiled with CFR 0.152.
 */
package de.joshuaschnabel.config;

import de.joshuaschnabel.config.json.JsonConfig;
import de.joshuaschnabel.config.json.NestedJsonConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;

public class Config {
    private String appname;
    private String classPath;
    private JsonConfig config;
    private Set<String> flags = new HashSet<String>();

    public Config(String appname, String classPath, String[] args) throws IOException, URISyntaxException {
        this.appname = appname;
        this.classPath = classPath;
        this.loadConfig(args);
    }

    private void loadConfig(String[] args) throws IOException, URISyntaxException {
        JsonConfig fixedConfig;
        JsonConfig defaultConfig = this.loadLocalConfig(new JsonConfig());
        JsonConfig externalConfig = this.loadExternalConfig(defaultConfig);
        JsonConfig argumentConfig = this.loadRunntimeArgs(args, externalConfig);
        this.config = fixedConfig = this.loadFixedConfig(argumentConfig);
    }

    private JsonConfig loadRunntimeArgs(String[] args, JsonConfig jsonConfig) {
        NestedJsonConfig argConfig = new NestedJsonConfig(jsonConfig);
        for (String arg : args) {
            Object[] splits;
            if (arg.startsWith("--")) {
                if (arg.contains("=")) {
                    splits = arg.split("=");
                    argConfig.setProperty(splits[0].substring(2, splits[0].length()), (String)splits[1]);
                    continue;
                }
                this.addFlag(arg.substring(2, arg.length()));
                continue;
            }
            if (!arg.startsWith("-")) continue;
            splits = arg.toCharArray();
            for (int i = 1; i < splits.length; ++i) {
                char c = splits[i];
                this.addFlag(String.valueOf(c));
            }
        }
        if (!argConfig.isEmpty()) {
            return argConfig;
        }
        return jsonConfig;
    }

    private void addFlag(String substring) {
        this.flags.add(substring);
    }

    private JsonConfig loadExternalConfig(JsonConfig localConfig) throws URISyntaxException, IOException {
        String path = Config.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        File externalNestedJsonConfigFile = new File(path + "/" + this.appname + ".json");
        NestedJsonConfig exteralConfig = null;
        if (externalNestedJsonConfigFile.exists()) {
            try (FileInputStream stream = new FileInputStream(externalNestedJsonConfigFile);){
                exteralConfig = new NestedJsonConfig(localConfig);
                exteralConfig.load(stream);
            }
            catch (FileNotFoundException e) {
                return localConfig;
            }
            return exteralConfig;
        }
        return localConfig;
    }

    private JsonConfig loadLocalConfig(JsonConfig argumentNestedJsonConfig) throws IOException {
        return Config.loadConfigFromClasspath(this.classPath + "/" + this.appname + ".json", argumentNestedJsonConfig);
    }

    private JsonConfig loadFixedConfig(JsonConfig argumentNestedJsonConfig) throws IOException {
        return Config.loadConfigFromClasspath(this.classPath + "/" + this.appname + "_fixed.json", argumentNestedJsonConfig);
    }

    private static JsonConfig loadConfigFromClasspath(String path, JsonConfig argumentConfig) throws IOException {
        NestedJsonConfig config = new NestedJsonConfig(argumentConfig);
        config.load(Config.class.getClass().getResourceAsStream(path));
        return config;
    }

    public String getValue(String name) {
        return this.config.getProperty(name);
    }

    public boolean isFlagSet(String name) {
        return this.flags.contains(name);
    }
}

