/*
 * Decompiled with CFR 0.152.
 */
package de.joshuaschnabel.config.json;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.WriterConfig;
import de.joshuaschnabel.config.json.objects.ConfigEntry;
import de.joshuaschnabel.config.json.objects.ConfigFolder;
import de.joshuaschnabel.config.json.objects.ConfigObject;
import de.joshuaschnabel.config.json.serializer.JsonSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class JsonConfig {
    private static final String ROOT = "root";
    private ConfigFolder root = new ConfigFolder("root");

    public void load(InputStream is) throws IOException {
        this.load(new InputStreamReader(is, Charset.forName("UTF-8")));
    }

    public void load(Reader ir) throws IOException {
        this.root = JsonSerializer.deserialize(Json.parse((Reader)ir).asObject());
    }

    public void save(OutputStream os) throws IOException {
        this.save(new OutputStreamWriter(os, Charset.forName("UTF-8")));
    }

    public void save(Writer ow) throws IOException {
        JsonObject jsonValue = JsonSerializer.serialize(this.root);
        jsonValue.writeTo(ow, WriterConfig.MINIMAL);
        ow.close();
    }

    public void setProperty(String path, String value) {
        ConfigObject element;
        String[] names = path.split("/");
        String entryName = names[names.length - 1];
        ConfigFolder folder = this.findFolder(names);
        if (folder == null) {
            folder = this.createFolder(names);
        }
        if ((element = folder.getByName(entryName)) == null) {
            folder.add(new ConfigEntry(entryName, value));
        } else {
            ((ConfigEntry)element).setValue(value);
        }
    }

    private ConfigFolder findFolder(String[] names) {
        return this.findFolderRecursiv(this.root, Arrays.copyOfRange(names, 0, Math.max(names.length - 1, 0)));
    }

    private ConfigFolder findFolderRecursiv(ConfigFolder currentElement, String[] names) {
        if (names.length > 0) {
            String name = names[0];
            ConfigObject element = currentElement.getByName(name);
            if (element != null && element.is(ConfigFolder.class)) {
                return this.findFolderRecursiv((ConfigFolder)element, Arrays.copyOfRange(names, 1, names.length));
            }
            return null;
        }
        return currentElement;
    }

    private ConfigFolder createFolder(String[] names) {
        return this.createFolderRecursiv(this.root, Arrays.copyOfRange(names, 0, Math.max(names.length - 1, 0)));
    }

    private ConfigFolder createFolderRecursiv(ConfigFolder currentElement, String[] names) {
        if (names.length > 0) {
            ConfigObject element;
            String name = names[0];
            if (!currentElement.existsByName(name)) {
                currentElement.add(new ConfigFolder(name));
            }
            if (!(element = currentElement.getByName(name)).is(ConfigFolder.class)) {
                throw new IllegalStateException("Folder with Name " + name + " in " + JsonConfig.getName(names) + " couldn't be obend! Element is no Folder!");
            }
            return this.createFolderRecursiv((ConfigFolder)element, Arrays.copyOfRange(names, 1, names.length));
        }
        return currentElement;
    }

    private static String getName(String[] names) {
        String name = "/";
        for (int j = 0; j < names.length; ++j) {
            name = name + names[j] + "/";
        }
        return name;
    }

    public String getProperty(String path) {
        ConfigObject element;
        String[] names = path.split("/");
        String entryName = names[names.length - 1];
        ConfigFolder folder = this.findFolder(names);
        if (folder != null && (element = folder.getByName(entryName)) != null && element.is(ConfigEntry.class)) {
            return ((ConfigEntry)element).getValue();
        }
        return null;
    }

    public String getProperty(String path, String defaultValue) {
        String value = this.getProperty(path);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean isEmpty() {
        return this.root.entriesSize() == 0;
    }
}

