/*
 * Decompiled with CFR 0.152.
 */
package de.joshuaschnabel.config.json.serializer;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import de.joshuaschnabel.config.json.objects.ConfigEntry;
import de.joshuaschnabel.config.json.objects.ConfigFolder;
import de.joshuaschnabel.config.json.objects.ConfigObject;

public class JsonSerializer {
    public static JsonObject serialize(ConfigFolder folder) {
        JsonObject object = Json.object();
        for (ConfigObject element : folder) {
            JsonSerializer.serializeRecursive(object, element);
        }
        return object;
    }

    private static void serializeRecursive(JsonObject object, ConfigObject element) {
        if (element.is(ConfigFolder.class)) {
            JsonObject tobject = Json.object();
            object.add(element.getName(), (JsonValue)tobject);
            for (ConfigObject co : (ConfigFolder)element) {
                JsonSerializer.serializeRecursive(tobject, co);
            }
        } else {
            ConfigEntry entry = (ConfigEntry)element;
            object.add(entry.getName(), entry.getValue());
        }
    }

    public static ConfigFolder deserialize(JsonObject object) {
        ConfigFolder root = new ConfigFolder("root");
        JsonSerializer.deserializeRecursive(object, root);
        return root;
    }

    private static void deserializeRecursive(JsonObject object, ConfigFolder root) {
        for (JsonObject.Member member : object) {
            if (member.getValue().isString()) {
                root.add(new ConfigEntry(member.getName(), member.getValue().asString()));
                continue;
            }
            ConfigFolder folder = new ConfigFolder(member.getName());
            root.add(folder);
            JsonSerializer.deserializeRecursive(member.getValue().asObject(), folder);
        }
    }
}

