/*
 * Decompiled with CFR 0.152.
 */
package de.joshuaschnabel.l18n;

import com.eclipsesource.json.Json;
import de.joshuaschnabel.l18n.I18n;
import de.joshuaschnabel.l18n.Translation;
import de.joshuaschnabel.l18n.exception.LanguageNotSupportedException;
import de.joshuaschnabel.l18n.json.JsonTranslationDeserializer;
import de.joshuaschnabel.l18n.scanner.ResourceScanner;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;

public class I18nMultiFile
extends I18n {
    public I18nMultiFile(Locale defaultLanguage) {
        super(defaultLanguage);
    }

    @Override
    protected void checkIfLanguageIsLoaded(Locale language) {
        if (!this.getSupportedLanguages().contains(language)) {
            throw new LanguageNotSupportedException("Language " + language.getDisplayName() + " is not supported");
        }
        this.getTranslations().put(language, I18nMultiFile.loadLanguageFromMultiFile(this.getLanguages().get(language)));
    }

    private static Translation loadLanguageFromMultiFile(String filePath) {
        Translation translation;
        InputStream is = I18n.class.getClass().getResourceAsStream("/" + filePath);
        try (InputStreamReader reader = new InputStreamReader(is, Charset.forName("UTF-8"));){
            translation = JsonTranslationDeserializer.deserialiseTranslation(Json.parse((Reader)reader).asObject());
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while loading '" + filePath + "'! (" + e.toString() + ")");
        }
        return translation;
    }

    @Override
    protected void loadLanguages() {
        Set<String> filelist = ResourceScanner.getResources("jsI18n.translations", ".*\\.tns");
        for (String filePath : filelist) {
            Translation translation = I18nMultiFile.loadLanguageFromMultiFile(filePath);
            for (Locale locale : translation.getLanguages()) {
                this.addSupportedLanguages(locale, filePath);
            }
        }
    }
}

