/*
 * Decompiled with CFR 0.152.
 */
package de.joshuaschnabel.l18n.json;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import de.joshuaschnabel.l18n.Translation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class JsonTranslationDeserializer {
    public static List<Translation> deserialise(JsonObject object) {
        ArrayList<Translation> translations = new ArrayList<Translation>();
        for (JsonObject.Member member : object) {
            translations.add(JsonTranslationDeserializer.deserialiseTranslation(member.getValue().asObject()));
        }
        return translations;
    }

    public static Translation deserialiseTranslation(JsonObject object) {
        ArrayList<Locale> languages = new ArrayList<Locale>();
        for (JsonValue member : object.get("language").asArray()) {
            languages.add(Locale.forLanguageTag(member.asString()));
        }
        Translation translation = new Translation(languages);
        for (JsonObject.Member member : object) {
            if (member.getName().equals("language")) continue;
            translation.addString(member.getName(), member.getValue().asString());
        }
        return translation;
    }
}

