/*
 * Decompiled with CFR 0.152.
 */
package de.joshuaschnabel.l18n;

import de.joshuaschnabel.l18n.Translation;
import de.joshuaschnabel.l18n.exception.LanguageNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class I18n {
    private Locale defaultLanguage;
    private Locale currentLanguage;
    private Map<Locale, String> supportedLanguages = new HashMap<Locale, String>();
    private Map<Locale, Translation> translations = new HashMap<Locale, Translation>();

    public I18n(Locale defaultLanguage) {
        this.loadLanguages();
        this.defaultLanguage = defaultLanguage;
        this.selectLanguage();
    }

    private static Locale getSystemLanguage() {
        return Locale.getDefault(Locale.Category.DISPLAY);
    }

    private void selectLanguage() throws IllegalStateException {
        try {
            this.setLanguage(I18n.getSystemLanguage());
        }
        catch (LanguageNotSupportedException e) {
            try {
                this.setLanguage(this.defaultLanguage);
            }
            catch (LanguageNotSupportedException e1) {
                throw new IllegalStateException("Default-language not supported (" + e1.getMessage() + ")");
            }
        }
    }

    public void setLanguage(Locale language) throws LanguageNotSupportedException {
        if (!this.getSupportedLanguages().contains(language)) {
            throw new LanguageNotSupportedException(language + " not supported");
        }
        this.currentLanguage = language;
    }

    public Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public Locale getCurrentLanguage() {
        return this.currentLanguage;
    }

    public String getTranslationString(String identifier) {
        if (this.getTranslationString(identifier, this.currentLanguage) == null) {
            return this.getTranslationString(identifier, this.defaultLanguage);
        }
        return this.getTranslationString(identifier, this.currentLanguage);
    }

    public String getTranslationString(String identifier, Locale language) throws LanguageNotSupportedException {
        this.checkIfLanguageIsLoaded(language);
        return this.getTranslations().get(language).getString(identifier);
    }

    public String getTranslationString(String identifier, Object ... args) {
        return String.format(this.currentLanguage, this.getTranslationString(identifier), args);
    }

    protected abstract void checkIfLanguageIsLoaded(Locale var1);

    protected abstract void loadLanguages();

    protected void setTranslations(Map<Locale, Translation> translations) {
        this.translations = translations;
    }

    protected void setSupportedLanguages(Map<Locale, String> supportedLanguages) {
        this.supportedLanguages = supportedLanguages;
    }

    protected Map<Locale, String> getLanguages() {
        return this.supportedLanguages;
    }

    public List<Locale> getSupportedLanguages() {
        return Collections.unmodifiableList(new ArrayList<Locale>(this.supportedLanguages.keySet()));
    }

    protected void addSupportedLanguages(Locale locale, String path) {
        this.supportedLanguages.put(locale, path);
    }

    protected Map<Locale, Translation> getTranslations() {
        return this.translations;
    }
}

