/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.maven.plugins.hibernate4ddl;

import de.jpdigital.maven.plugins.hibernate4ddl.Dialect;
import de.jpdigital.maven.plugins.hibernate4ddl.EntityFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.tools.hbm2ddl.EnversSchemaGenerator;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Mojo(name="gen-ddl", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class GenerateDdlMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-resources/sql/ddl/auto", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(required=true)
    private String[] packages;
    @Parameter(required=true)
    private String[] dialects;
    @Parameter(required=false)
    private boolean useEnvers;
    @Parameter(required=false)
    private boolean createDropStatments;
    @Parameter(defaultValue="${basedir}/src/main/resources/META-INF/persistence.xml", required=false)
    private File persistenceXml;
    @Component
    private transient MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean result;
        File outputDir = this.outputDirectory;
        this.getLog().info((CharSequence)String.format("Generating DDL SQL files in %s.", outputDir.getAbsolutePath()));
        if (!outputDir.exists() && !(result = outputDir.mkdirs())) {
            throw new MojoFailureException("Failed to create output directory for SQL DDL files.");
        }
        HashSet<Dialect> dialectsList = new HashSet<Dialect>();
        for (String dialect : this.dialects) {
            this.convertDialect(dialect, dialectsList);
        }
        HashSet entityClasses = new HashSet();
        for (String packageName : this.packages) {
            Set<Class<?>> packageEntities = EntityFinder.forPackage(this.project, this.getLog(), packageName).findEntities();
            entityClasses.addAll(packageEntities);
        }
        this.getLog().info((CharSequence)String.format("Found %d entities.", entityClasses.size()));
        for (Dialect dialect : dialectsList) {
            this.generateDdl(dialect, entityClasses);
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String[] getPackages() {
        return Arrays.copyOf(this.packages, this.packages.length);
    }

    public void setPackages(String ... packages) {
        this.packages = Arrays.copyOf(packages, packages.length);
    }

    public String[] getDialects() {
        return Arrays.copyOf(this.dialects, this.dialects.length);
    }

    public void setDialects(String ... dialects) {
        this.dialects = Arrays.copyOf(dialects, dialects.length);
    }

    public boolean isUseEnvers() {
        return this.useEnvers;
    }

    public void setUseEnvers(boolean useEnvers) {
        this.useEnvers = useEnvers;
    }

    public boolean isCreateDropStatments() {
        return this.createDropStatments;
    }

    public void setCreateDropStatements(boolean createDropStatments) {
        this.createDropStatments = createDropStatments;
    }

    public File getPersistenceXml() {
        return this.persistenceXml;
    }

    public void setPersistenceXml(File persistenceXml) {
        this.persistenceXml = persistenceXml;
    }

    private void convertDialect(String dialect, Set<Dialect> dialectsList) throws MojoFailureException {
        try {
            dialectsList.add(Dialect.valueOf(dialect.toUpperCase(Locale.ENGLISH)));
        }
        catch (IllegalArgumentException ex) {
            StringBuffer buffer = new StringBuffer();
            for (Dialect avilable : Dialect.values()) {
                buffer.append(avilable.toString()).append('\n');
            }
            throw new MojoFailureException(String.format("Can't convert the configured dialect '%s' to a dialect classname. Available dialects are:%n%s", dialect, buffer.toString()), (Throwable)ex);
        }
    }

    private void generateDdl(Dialect dialect, Set<Class<?>> entityClasses) throws MojoFailureException {
        Path tmpDir;
        Configuration configuration = new Configuration(){
            private static final long serialVersionUID = 8818333354983681885L;

            public String[] generateSchemaCreationScript(org.hibernate.dialect.Dialect dialect) throws HibernateException {
                ArrayList<String> statements = new ArrayList<String>();
                statements.addAll(Arrays.asList(super.generateSchemaCreationScript(dialect)));
                ArrayList<String> beforeTablesStatements = new ArrayList<String>();
                Iterator iterator = statements.iterator();
                while (iterator.hasNext()) {
                    String statement = ((String)iterator.next()).toLowerCase();
                    if (!statement.startsWith("create schema") && !statement.startsWith("create domain")) continue;
                    beforeTablesStatements.add(statement);
                    iterator.remove();
                }
                for (String beforeTablesStatement : beforeTablesStatements) {
                    statements.add(0, beforeTablesStatement);
                }
                return statements.toArray(new String[statements.size()]);
            }
        };
        this.processPersistenceXml(configuration);
        if (this.createDropStatments) {
            configuration.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        } else {
            configuration.setProperty("hibernate.hbm2ddl.auto", "create");
        }
        for (Class<?> entityClass : entityClasses) {
            configuration.addAnnotatedClass(entityClass);
        }
        configuration.setProperty("hibernate.dialect", dialect.getDialectClass());
        SchemaExport export = this.useEnvers ? new EnversSchemaGenerator(configuration).export() : new SchemaExport(configuration);
        export.setDelimiter(";");
        try {
            tmpDir = Files.createTempDirectory("maven-hibernate-ddl-plugin", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new MojoFailureException("Failed to create work dir.", (Throwable)ex);
        }
        export.setOutputFile(String.format("%s/%s.sql", tmpDir.toString(), dialect.name().toLowerCase(Locale.ENGLISH)));
        export.setFormat(true);
        if (this.createDropStatments) {
            export.execute(true, false, false, false);
        } else {
            export.execute(true, false, false, true);
        }
        this.writeOutputFile(dialect, tmpDir);
    }

    private void processPersistenceXml(Configuration configuration) {
        if (this.persistenceXml != null) {
            this.getLog().info((CharSequence)"persistence.xml available, locking for properties...");
            try (FileInputStream inStream = new FileInputStream(this.persistenceXml);){
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse((InputStream)inStream, (DefaultHandler)new PersistenceXmlHandler(configuration));
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)"Failed to open persistence.xml. Not processing properties.", (Throwable)ex);
            }
            catch (ParserConfigurationException | SAXException ex) {
                this.getLog().error((CharSequence)"Error parsing persistence.xml. Not processing properties", (Throwable)ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeOutputFile(Dialect dialect, Path tmpDir) throws MojoFailureException {
        this.createOutputDir();
        Path outputFilePath = this.createOutputFilePath(dialect);
        Path tmpFilePath = Paths.get(String.format("%s/%s.sql", tmpDir.toString(), dialect.name().toLowerCase(Locale.ENGLISH)), new String[0]);
        if (Files.exists(outputFilePath, new LinkOption[0])) {
            String tmpFileData;
            String outputFileData;
            try {
                outputFileData = new String(Files.readAllBytes(outputFilePath), Charset.forName("UTF-8"));
                tmpFileData = new String(Files.readAllBytes(tmpFilePath), Charset.forName("UTF-8"));
            }
            catch (IOException ex) {
                throw new MojoFailureException(String.format("Failed to check if DDL file content has changed: %s", ex.getMessage()), (Throwable)ex);
            }
            try {
                if (tmpFileData.equals(outputFileData)) return;
                Files.deleteIfExists(outputFilePath);
                Files.copy(tmpFilePath, outputFilePath, new CopyOption[0]);
                return;
            }
            catch (IOException ex) {
                throw new MojoFailureException(String.format("Failed to copy DDL file content from tmp file to output file: %s", ex.getMessage()), (Throwable)ex);
            }
        }
        try {
            Files.copy(tmpFilePath, outputFilePath, new CopyOption[0]);
            return;
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Failed to copy tmp file to output file: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    private void createOutputDir() throws MojoFailureException {
        Path outputDir = this.outputDirectory.toPath();
        if (Files.exists(outputDir, new LinkOption[0])) {
            if (!Files.isDirectory(outputDir, new LinkOption[0])) {
                throw new MojoFailureException("A file with the name of the output directory already exists but is not a directory.");
            }
        } else {
            try {
                Files.createDirectory(outputDir, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new MojoFailureException(String.format("Failed to create the output directory: %s", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private Path createOutputFilePath(Dialect dialect) {
        String dirPath = this.outputDirectory.getAbsolutePath().endsWith("/") ? this.outputDirectory.getAbsolutePath().substring(0, this.outputDirectory.getAbsolutePath().length()) : this.outputDirectory.getAbsolutePath();
        return Paths.get(String.format("%s/%s.sql", dirPath, dialect.name().toLowerCase(Locale.ENGLISH)), new String[0]);
    }

    private class PersistenceXmlHandler
    extends DefaultHandler {
        private final transient Configuration configuration;

        public PersistenceXmlHandler(Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            GenerateDdlMojo.this.getLog().info((CharSequence)String.format("Found element with uri = '%s', localName = '%s', qName = '%s'...", uri, localName, qName));
            if ("property".equals(qName)) {
                String propertyName = attributes.getValue("name");
                String propertyValue = attributes.getValue("value");
                if (propertyName != null && !propertyName.isEmpty() && propertyValue != null && !propertyValue.isEmpty()) {
                    GenerateDdlMojo.this.getLog().info((CharSequence)String.format("Found property %s = %s in persistence.xml", propertyName, propertyValue));
                    this.configuration.setProperty(propertyName, propertyValue);
                }
            }
        }
    }
}

