/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.maven.plugins.hibernate4ddl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;

final class EntityFinder {
    private final transient Reflections reflections;

    private EntityFinder(Reflections reflections) {
        this.reflections = reflections;
    }

    public static EntityFinder forPackage(MavenProject project, Log log, String packageName) throws MojoFailureException {
        Reflections reflections;
        if (project == null) {
            reflections = new Reflections(new Object[]{ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])});
        } else {
            List classPathElems;
            try {
                classPathElems = project.getCompileClasspathElements();
            }
            catch (DependencyResolutionRequiredException ex) {
                throw new MojoFailureException("Failed to resolve project classpath.", (Throwable)ex);
            }
            ArrayList<URL> classPathUrls = new ArrayList<URL>();
            for (String classPathElem : classPathElems) {
                log.info((CharSequence)String.format("Adding classpath elemement '%s'...", classPathElem));
                classPathUrls.add(EntityFinder.classPathElemToUrl(classPathElem));
            }
            log.info((CharSequence)"Classpath URLs:");
            for (URL url : classPathUrls) {
                log.info((CharSequence)String.format("\t%s", url.toString()));
            }
            ClassLoader classLoader = AccessController.doPrivileged(new ClassLoaderCreator(classPathUrls));
            reflections = new Reflections(new Object[]{ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[]{classLoader})});
        }
        return new EntityFinder(reflections);
    }

    public Set<Class<?>> findEntities() {
        HashSet entityClasses = new HashSet();
        Set classesWithEntity = this.reflections.getTypesAnnotatedWith(Entity.class);
        for (Class entityClass : classesWithEntity) {
            entityClasses.add(entityClass);
        }
        return entityClasses;
    }

    private static URL classPathElemToUrl(String classPathElem) throws MojoFailureException {
        URL url;
        File file = new File(classPathElem);
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new MojoFailureException(String.format("Failed to convert classpath element '%s' to an URL.", classPathElem), (Throwable)ex);
        }
        return url;
    }

    private static class ClassLoaderCreator
    implements PrivilegedAction<ClassLoader> {
        private final transient List<URL> classPathUrls;

        public ClassLoaderCreator(List<URL> classPathUrls) {
            this.classPathUrls = classPathUrls;
        }

        @Override
        public ClassLoader run() {
            URLClassLoader classLoader = new URLClassLoader(this.classPathUrls.toArray(new URL[this.classPathUrls.size()]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(classLoader);
            return classLoader;
        }
    }
}

