/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.maven.plugins.hibernate5ddl;

import de.jpdigital.maven.plugins.hibernate5ddl.DdlGenerator;
import de.jpdigital.maven.plugins.hibernate5ddl.Dialect;
import de.jpdigital.maven.plugins.hibernate5ddl.EntityFinder;
import de.jpdigital.maven.plugins.hibernate5ddl.OutputFileWriter;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="gen-ddl", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class GenerateDdlMojo
extends AbstractMojo {
    private static final String[] DEFAULT_PROPERTIES_TO_USE = new String[]{"format_sql", "use_sql_comments", "hibernate.id.new_generator_mappings", "org.hibernate.envers.audit_strategy"};
    @Parameter(defaultValue="${project.build.directory}/generated-resources/sql/ddl/auto", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(required=false, defaultValue="")
    private String outputFileNamePrefix = "";
    @Parameter(required=false, defaultValue="")
    private String outputFileNameSuffix = "";
    @Parameter(required=false)
    private boolean omitDialectFromFileName;
    @Parameter(required=true)
    private String[] packages;
    @Parameter(required=false)
    private String[] dialects;
    @Parameter(required=false)
    private String[] customDialects;
    @Parameter(required=false)
    private boolean createDropStatements;
    @Parameter(defaultValue="${basedir}/src/main/resources/META-INF/persistence.xml", required=false)
    private File persistenceXml;
    @Parameter(required=false)
    private String[] persistencePropertiesToUse;
    @Parameter(defaultValue="${project}", readonly=true)
    private transient MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean result;
        File outputDir = this.outputDirectory;
        this.getLog().info((CharSequence)String.format("Generating DDL SQL files in %s.", outputDir.getAbsolutePath()));
        if (!outputDir.exists() && !(result = outputDir.mkdirs())) {
            throw new MojoFailureException("Failed to create output directory for SQL DDL files.");
        }
        HashSet entityClasses = new HashSet();
        for (String packageName : this.packages) {
            Set<Class<?>> packageEntities = EntityFinder.forPackage(this.project, this.getLog(), packageName).findEntities();
            entityClasses.addAll(packageEntities);
        }
        this.getLog().info((CharSequence)String.format("Found %d entities.", entityClasses.size()));
        ServiceLoader<DdlGenerator> serviceLoader = ServiceLoader.load(DdlGenerator.class);
        if (!serviceLoader.iterator().hasNext()) {
            throw new MojoFailureException(String.format("No implementation of '%s' is available.", DdlGenerator.class.getName()));
        }
        DdlGenerator ddlGenerator = serviceLoader.iterator().next();
        for (Dialect dialect : this.convertDialects()) {
            ddlGenerator.generateDdl(dialect, entityClasses, this);
        }
        if (this.customDialects != null) {
            for (String customDialect : this.customDialects) {
                ddlGenerator.generateDdl(customDialect, entityClasses, this);
            }
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getOutputFileNamePrefix() {
        return this.outputFileNamePrefix;
    }

    public void setOutputFileNamePrefix(String outputFileNamePrefix) {
        this.outputFileNamePrefix = outputFileNamePrefix;
    }

    public String getOutputFileNameSuffix() {
        return this.outputFileNameSuffix;
    }

    public void setOutputFileNameSuffix(String outputFileNameSuffix) {
        this.outputFileNameSuffix = outputFileNameSuffix;
    }

    public boolean isOmitDialectFromFileName() {
        return this.omitDialectFromFileName;
    }

    public void setOmitDialectFromFileName(boolean omitDialectFromFileName) {
        this.omitDialectFromFileName = omitDialectFromFileName;
    }

    public String[] getPackages() {
        return Arrays.copyOf(this.packages, this.packages.length);
    }

    public void setPackages(String ... packages) {
        this.packages = Arrays.copyOf(packages, packages.length);
    }

    public String[] getDialects() {
        return Arrays.copyOf(this.dialects, this.dialects.length);
    }

    public void setDialects(String ... dialects) {
        this.dialects = Arrays.copyOf(dialects, dialects.length);
    }

    public String[] getCustomDialects() {
        return Arrays.copyOf(this.customDialects, this.customDialects.length);
    }

    public void setCustomDialects(String ... customDialects) {
        this.customDialects = Arrays.copyOf(customDialects, customDialects.length);
    }

    public boolean isCreateDropStatements() {
        return this.createDropStatements;
    }

    public void setCreateDropStatements(boolean createDropStatments) {
        this.createDropStatements = createDropStatments;
    }

    public File getPersistenceXml() {
        return this.persistenceXml;
    }

    public void setPersistenceXml(File persistenceXml) {
        this.persistenceXml = persistenceXml;
    }

    public String[] getPersistencePropertiesToUse() {
        if (this.persistencePropertiesToUse == null || this.persistencePropertiesToUse.length == 0) {
            return Arrays.copyOf(DEFAULT_PROPERTIES_TO_USE, DEFAULT_PROPERTIES_TO_USE.length);
        }
        return Arrays.copyOf(this.persistencePropertiesToUse, this.persistencePropertiesToUse.length);
    }

    public void setPersistencePropertiesToUse(String ... persistencePropertiesToUse) {
        this.persistencePropertiesToUse = persistencePropertiesToUse == null ? null : Arrays.copyOf(persistencePropertiesToUse, persistencePropertiesToUse.length);
    }

    private Set<Dialect> convertDialects() throws MojoFailureException {
        HashSet<Dialect> dialectsList = new HashSet<Dialect>();
        if (this.dialects != null) {
            for (String dialect : this.dialects) {
                this.convertDialect(dialect, dialectsList);
            }
        }
        return dialectsList;
    }

    private void convertDialect(String dialect, Set<Dialect> dialectsList) throws MojoFailureException {
        try {
            dialectsList.add(Dialect.valueOf(dialect.toUpperCase(Locale.ENGLISH)));
        }
        catch (IllegalArgumentException ex) {
            StringBuffer buffer = new StringBuffer();
            for (Dialect avilable : Dialect.values()) {
                buffer.append(avilable.toString()).append('\n');
            }
            throw new MojoFailureException(String.format("Can't convert the configured dialect '%s' to a dialect classname. Available dialects are:%n%s", dialect, buffer.toString()), (Throwable)ex);
        }
    }

    protected void writeOutputFile(String dialectClassName, Path tmpDir) throws MojoFailureException {
        OutputFileWriter writer = new OutputFileWriter(this.outputDirectory);
        writer.setOmitDialectFromFileName(this.omitDialectFromFileName && this.dialects.length == 1);
        writer.setOutputFileNamePrefix(this.outputFileNamePrefix);
        writer.setOutputFileNameSuffix(this.outputFileNameSuffix);
        writer.writeOutputFile(dialectClassName, tmpDir);
    }

    public String getDialectNameFromClassName(String dialectClassName) {
        int pos = dialectClassName.lastIndexOf(46);
        if (dialectClassName.toLowerCase(Locale.ROOT).endsWith("dialect")) {
            return dialectClassName.substring(pos + 1, dialectClassName.length() - "dialect".length()).toLowerCase(Locale.ROOT);
        }
        return dialectClassName.substring(pos + 1).toLowerCase(Locale.ROOT);
    }
}

