/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.maven.plugins.hibernate6ddl;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.PackageInfo;
import io.github.classgraph.ScanResult;
import jakarta.persistence.Converter;
import jakarta.persistence.Entity;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class EntityFinder {
    private static final Set<String> PACKAGE_LEVEL_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.hibernate.annotations.AnyMetaDef", "org.hibernate.annotations.AnyMetaDefs", "org.hibernate.annotations.FetchProfile", "org.hibernate.annotations.FetchProfile.FetchOverride", "org.hibernate.annotations.FetchProfiles", "org.hibernate.annotations.FilterDef", "org.hibernate.annotations.FilterDefs", "org.hibernate.annotations.GenericGenerator", "org.hibernate.annotations.GenericGenerators", "org.hibernate.annotations.NamedNativeQueries", "org.hibernate.annotations.NamedNativeQuery", "org.hibernate.annotations.NamedQueries", "org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.TypeDef", "org.hibernate.annotations.TypeDefs")));
    private final ClassLoader classLoader;
    private final ScanResult scanResult;

    private EntityFinder(ScanResult scanResult, ClassLoader classLoader) {
        this.scanResult = scanResult;
        this.classLoader = classLoader;
    }

    public static EntityFinder forClassPath(MavenProject project, Log log, boolean includeTestClasses) throws MojoFailureException {
        Objects.requireNonNull(project, "Parameter project is null");
        ArrayList classPathElements = new ArrayList();
        try {
            classPathElements.addAll(project.getCompileClasspathElements());
            if (includeTestClasses) {
                classPathElements.addAll(project.getTestClasspathElements());
            }
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoFailureException("Failed to resolve project classpath.", (Throwable)ex);
        }
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        for (String classPathElem : classPathElements) {
            log.info((CharSequence)String.format("Adding classpath elemement '%s'...", classPathElem));
            classPathUrls.add(EntityFinder.classPathElemToUrl(classPathElem));
        }
        log.info((CharSequence)"Classpath URLs:");
        for (URL url : classPathUrls) {
            log.info((CharSequence)String.format("\t%s", url.toString()));
        }
        ClassLoader classLoader = AccessController.doPrivileged(new ClassLoaderCreator(classPathUrls));
        ScanResult scanResult = new ClassGraph().enableAllInfo().addClassLoader(classLoader).scan();
        return new EntityFinder(scanResult, classLoader);
    }

    public static EntityFinder forPackage(MavenProject project, Log log, String packageName, boolean includeTestClasses) throws MojoFailureException {
        ClassLoader classLoader;
        ScanResult scanResult;
        if (project == null) {
            scanResult = new ClassGraph().enableAllInfo().acceptPackages(new String[]{packageName}).scan();
            classLoader = scanResult.getClass().getClassLoader();
        } else {
            ArrayList classPathElements = new ArrayList();
            try {
                classPathElements.addAll(project.getCompileClasspathElements());
                if (includeTestClasses) {
                    classPathElements.addAll(project.getTestClasspathElements());
                }
            }
            catch (DependencyResolutionRequiredException ex) {
                throw new MojoFailureException("Failed to resolve project classpath.", (Throwable)ex);
            }
            ArrayList<URL> classPathUrls = new ArrayList<URL>();
            for (String classPathElement : classPathElements) {
                log.info((CharSequence)String.format("Adding classpath elemement '%s'...", classPathElement));
                classPathUrls.add(EntityFinder.classPathElemToUrl(classPathElement));
            }
            log.info((CharSequence)"Classpath URLs:");
            for (URL url : classPathUrls) {
                log.info((CharSequence)String.format("\t%s", url.toString()));
            }
            classLoader = AccessController.doPrivileged(new ClassLoaderCreator(classPathUrls));
            scanResult = new ClassGraph().enableAllInfo().addClassLoader(classLoader).acceptPackages(new String[]{packageName}).scan();
        }
        return new EntityFinder(scanResult, classLoader);
    }

    public Set<Class<?>> findEntities() {
        HashSet entityClasses = new HashSet();
        entityClasses.addAll(this.scanResult.getClassesWithAnnotation(Entity.class).stream().map(ClassInfo::loadClass).collect(Collectors.toSet()));
        entityClasses.addAll(this.scanResult.getClassesWithAnnotation(Converter.class).stream().map(ClassInfo::loadClass).collect(Collectors.toSet()));
        return entityClasses;
    }

    public Set<Package> findPackages() {
        return this.scanResult.getPackageInfo().filter(this::acceptPackagesWithPackageLevelAnnotations).stream().map(PackageInfo::getName).map(name -> this.classLoader.getDefinedPackage((String)name)).collect(Collectors.toSet());
    }

    private static URL classPathElemToUrl(String classPathElem) throws MojoFailureException {
        URL url;
        File file = new File(classPathElem);
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new MojoFailureException(String.format("Failed to convert classpath element '%s' to an URL.", classPathElem), (Throwable)ex);
        }
        return url;
    }

    private boolean acceptPackagesWithPackageLevelAnnotations(PackageInfo packageInfo) {
        boolean hasPackageLevelAnnotation = false;
        for (String packageLevelAnnotation : PACKAGE_LEVEL_ANNOTATIONS) {
            hasPackageLevelAnnotation = hasPackageLevelAnnotation || packageInfo.hasAnnotation(packageLevelAnnotation);
        }
        return hasPackageLevelAnnotation;
    }

    private static class ClassLoaderCreator
    implements PrivilegedAction<ClassLoader> {
        private final transient List<URL> classPathUrls;

        public ClassLoaderCreator(List<URL> classPathUrls) {
            this.classPathUrls = classPathUrls;
        }

        @Override
        public ClassLoader run() {
            URLClassLoader classLoader = new URLClassLoader((URL[])this.classPathUrls.toArray(URL[]::new), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(classLoader);
            return classLoader;
        }
    }
}

