/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.maven.plugins.hibernate6ddl;

import de.jpdigital.maven.plugins.hibernate6ddl.OutputFileWriterParameters;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.apache.maven.plugin.MojoFailureException;

public class OutputFileWriter {
    private final OutputFileWriterParameters parameters;

    OutputFileWriter(OutputFileWriterParameters parameters) {
        this.parameters = parameters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeOutputFile(String dialectClassName, Path tmpDir) throws MojoFailureException {
        this.createOutputDir();
        Path outputFilePath = this.createOutputFilePath(dialectClassName);
        Path tmpFilePath = Paths.get(String.format("%s/%s.sql", tmpDir.toString(), this.getDialectNameFromClassName(dialectClassName)), new String[0]);
        if (Files.exists(outputFilePath, new LinkOption[0])) {
            String tmpFileData;
            String outputFileData;
            try {
                outputFileData = new String(Files.readAllBytes(outputFilePath), Charset.forName("UTF-8"));
                tmpFileData = new String(Files.readAllBytes(tmpFilePath), Charset.forName("UTF-8"));
            }
            catch (IOException ex) {
                throw new MojoFailureException(String.format("Failed to check if DDL file content has changed: %s", ex.getMessage()), (Throwable)ex);
            }
            try {
                if (tmpFileData.equals(outputFileData)) return;
                Files.deleteIfExists(outputFilePath);
                Files.copy(tmpFilePath, outputFilePath, new CopyOption[0]);
                return;
            }
            catch (IOException ex) {
                throw new MojoFailureException(String.format("Failed to copy DDL file content from tmp file to output file: %s", ex.getMessage()), (Throwable)ex);
            }
        }
        try {
            Files.copy(tmpFilePath, outputFilePath, new CopyOption[0]);
            return;
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Failed to copy tmp file to output file: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    private void createOutputDir() throws MojoFailureException {
        Path outputDir = this.parameters.getOutputDirectory().toPath();
        if (Files.exists(outputDir, new LinkOption[0])) {
            if (!Files.isDirectory(outputDir, new LinkOption[0])) {
                throw new MojoFailureException("A file with the name of the output directory already exists but is not a directory.");
            }
        } else {
            try {
                Files.createDirectory(outputDir, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new MojoFailureException(String.format("Failed to create the output directory: %s", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private Path createOutputFilePath(String dialectClassName) {
        String dirPath = this.parameters.getOutputDirectory().getAbsolutePath().endsWith("/") ? this.parameters.getOutputDirectory().getAbsolutePath().substring(0, this.parameters.getOutputDirectory().getAbsolutePath().length()) : this.parameters.getOutputDirectory().getAbsolutePath();
        StringBuffer fileNameBuffer = new StringBuffer();
        fileNameBuffer.append(this.parameters.getOutputFileNamePrefix());
        if (!this.parameters.isOmitDialectFromFileName() || this.isFileNamePrefixEmpty() && this.isFileNameSuffixEmpty()) {
            fileNameBuffer.append(this.getDialectNameFromClassName(dialectClassName));
        }
        fileNameBuffer.append(this.parameters.getOutputFileNameSuffix());
        return Paths.get(String.format("%s/%s.sql", dirPath, fileNameBuffer.toString()), new String[0]);
    }

    private String getDialectNameFromClassName(String dialectClassName) {
        int pos = dialectClassName.lastIndexOf(46);
        if (dialectClassName.toLowerCase(Locale.ROOT).endsWith("dialect")) {
            return dialectClassName.substring(pos + 1, dialectClassName.length() - "dialect".length()).toLowerCase(Locale.ROOT);
        }
        return dialectClassName.substring(pos + 1).toLowerCase(Locale.ROOT);
    }

    private boolean isFileNamePrefixEmpty() {
        return this.isBlank(this.parameters.getOutputFileNamePrefix());
    }

    private boolean isFileNameSuffixEmpty() {
        return this.isBlank(this.parameters.getOutputFileNameSuffix());
    }

    private boolean isBlank(String str) {
        char[] characters;
        if (str == null || str.isEmpty()) {
            return true;
        }
        for (char character : characters = str.toCharArray()) {
            if (Character.isWhitespace(character)) continue;
            return false;
        }
        return true;
    }
}

