/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.maven.plugins.hibernate6ddl;

import de.jpdigital.maven.plugins.hibernate6ddl.DdlGenerator;
import de.jpdigital.maven.plugins.hibernate6ddl.Dialect;
import de.jpdigital.maven.plugins.hibernate6ddl.GenerateDdlMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DdlGeneratorHibernate64
implements DdlGenerator {
    public void generateDdl(String dialectClassName, Set<Package> packages, Set<Class<?>> entityClasses, GenerateDdlMojo mojo) throws MojoFailureException {
        Path path;
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
        this.processPersistenceXml(registryBuilder, mojo);
        if (mojo.isCreateDropStatements()) {
            registryBuilder.applySetting("hibernate.hbm2ddl.auto", (Object)"create-drop");
        } else {
            registryBuilder.applySetting("hibernate.hbm2ddl.auto", (Object)"create");
        }
        registryBuilder.applySetting("hibernate.dialect", (Object)dialectClassName);
        if (!mojo.getPersistenceProperties().isEmpty()) {
            mojo.getLog().info((CharSequence)"Applying persistence properties set in POM...");
            Map<String, Object> properties = mojo.getPersistenceProperties().entrySet().stream().filter(property -> !((String)property.getKey()).equals("hibernate.hbm2ddl.auto")).filter(property -> !((String)property.getKey()).equals("hibernate.dialect")).collect(Collectors.toMap(property -> (String)property.getKey(), property -> property.getValue()));
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                mojo.getLog().info((CharSequence)String.format("Setting peristence property %s = %s", entry.getKey(), entry.getValue()));
            }
            registryBuilder.applySettings(properties);
        }
        StandardServiceRegistry standardRegistry = registryBuilder.build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)standardRegistry);
        if (packages.isEmpty()) {
            System.err.println("No packages to process.");
        }
        for (Package package_ : packages) {
            System.err.printf("will process package %s%n", package_.getName());
            metadataSources.addPackage(package_);
        }
        for (Class<?> clazz : entityClasses) {
            metadataSources.addAnnotatedClass(clazz);
        }
        SchemaExport schemaExport = new SchemaExport();
        schemaExport.setDelimiter(";");
        try {
            path = Files.createTempDirectory("hibernate5-ddl-maven-plugin", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new MojoFailureException("Failed to create work dir.", (Throwable)ex);
        }
        Metadata metadata = metadataSources.buildMetadata();
        schemaExport.setManageNamespaces(true);
        schemaExport.setOutputFile(String.format("%s/%s.sql", path.toString(), mojo.getDialectNameFromClassName(dialectClassName)));
        schemaExport.setFormat(true);
        if (mojo.isCreateDropStatements()) {
            schemaExport.execute(EnumSet.of(TargetType.SCRIPT), SchemaExport.Action.BOTH, metadata);
        } else {
            schemaExport.execute(EnumSet.of(TargetType.SCRIPT), SchemaExport.Action.CREATE, metadata);
        }
        mojo.writeOutputFile(dialectClassName, path);
        try {
            Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException ex) {
            throw new MojoFailureException("Failed to clean up temporary files.", (Throwable)ex);
        }
    }

    public void generateDdl(Dialect dialect, Set<Package> packages, Set<Class<?>> entityClasses, GenerateDdlMojo mojo) throws MojoFailureException {
        this.generateDdl(dialect.getDialectClassName(), packages, entityClasses, mojo);
    }

    private void processPersistenceXml(StandardServiceRegistryBuilder registryBuilder, GenerateDdlMojo mojo) {
        Log log = mojo.getLog();
        File persistenceXml = mojo.getPersistenceXml();
        if (persistenceXml != null) {
            if (Files.exists(persistenceXml.toPath(), new LinkOption[0])) {
                try (FileInputStream inputStream = new FileInputStream(mojo.getPersistenceXml());){
                    log.info((CharSequence)"persistence.xml found, looking for properties...");
                    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                    parser.parse((InputStream)inputStream, (DefaultHandler)new PersistenceXmlHandler(registryBuilder, mojo.getLog(), new HashSet<String>(Arrays.asList(mojo.getPersistencePropertiesToUse()))));
                }
                catch (IOException ex) {
                    log.error((CharSequence)"Failed to open persistence.xml. Not processing properties.", (Throwable)ex);
                }
                catch (ParserConfigurationException | SAXException ex) {
                    log.error((CharSequence)"Error parsing persistence.xml. Not processing properties", (Throwable)ex);
                }
            } else {
                log.warn((CharSequence)String.format("persistence.xml file '%s' does not exist. Ignoring.", persistenceXml.getPath()));
            }
        }
    }

    private static class PersistenceXmlHandler
    extends DefaultHandler {
        private final transient StandardServiceRegistryBuilder registryBuilder;
        private final transient Set<String> propertiesToUse;
        private final transient Log log;

        public PersistenceXmlHandler(StandardServiceRegistryBuilder registryBuilder, Log log, Set<String> propertiesToUse) {
            this.registryBuilder = registryBuilder;
            this.log = log;
            this.propertiesToUse = propertiesToUse;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.log.info((CharSequence)String.format("Found element with uri = '%s', localName = '%s', qName = '%s'...", uri, localName, qName));
            if ("property".equals(qName) && this.propertiesToUse.contains(attributes.getValue("name"))) {
                String propertyName = attributes.getValue("name");
                String propertyValue = attributes.getValue("value");
                if (propertyName != null && !propertyName.isEmpty() && propertyValue != null && !propertyValue.isEmpty()) {
                    this.log.info((CharSequence)String.format("Found property %s = %s in persistence.xml", propertyName, propertyValue));
                    this.registryBuilder.applySetting(propertyName, (Object)propertyValue);
                }
            }
        }
    }
}

