/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.SingleExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SingleExplanationGeneratorImpl;
import com.clarkparsia.owlapi.explanation.util.OntologyUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlackBoxExplanation
extends SingleExplanationGeneratorImpl
implements SingleExplanationGenerator {
    public static final int DEFAULT_INITIAL_EXPANSION_LIMIT = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(BlackBoxExplanation.class.getName());
    private static final int DEFAULT_FAST_PRUNING_WINDOW_SIZE = 10;
    private final Set<OWLEntity> objectsExpandedWithDefiningAxioms = new HashSet<OWLEntity>();
    private final Set<OWLEntity> objectsExpandedWithReferencingAxioms = new HashSet<OWLEntity>();
    private final Set<OWLAxiom> expandedWithDefiningAxioms = new HashSet<OWLAxiom>();
    private final Set<OWLAxiom> expandedWithReferencingAxioms = new HashSet<OWLAxiom>();
    private final int initialExpansionLimit = 50;
    private final OWLOntologyManager man;
    protected Set<OWLAxiom> debuggingAxioms = new LinkedHashSet<OWLAxiom>();
    @Nullable
    private OWLOntology debuggingOntology;
    private int expansionLimit = 50;
    private int fastPruningWindowSize;
    private int satTestCount;

    public BlackBoxExplanation(OWLOntology ontology, OWLReasonerFactory reasonerFactory, OWLReasoner reasoner) {
        super(ontology, reasonerFactory, reasoner);
        this.man = ontology.getOWLOntologyManager();
    }

    private static <N extends OWLAxiom> int addMax(Set<N> source, Set<N> dest, int limit) {
        int count = 0;
        for (OWLAxiom obj : source) {
            if (count == limit) break;
            if (obj instanceof OWLAnnotationAxiom || !dest.add(obj)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void dispose() {
        this.reset();
        this.getReasoner().dispose();
    }

    private void reset() {
        if (this.debuggingOntology != null) {
            this.man.removeOntology(OWLAPIPreconditions.verifyNotNull(this.debuggingOntology));
            this.debuggingOntology = null;
        }
        this.debuggingAxioms.clear();
        this.objectsExpandedWithDefiningAxioms.clear();
        this.objectsExpandedWithReferencingAxioms.clear();
        this.expandedWithDefiningAxioms.clear();
        this.expandedWithReferencingAxioms.clear();
        this.expansionLimit = 50;
    }

    @Override
    public Set<OWLAxiom> getExplanation(OWLClassExpression unsatClass) {
        if (!this.getDefinitionTracker().isDefined(unsatClass)) {
            return Collections.emptySet();
        }
        try {
            ++this.satTestCount;
            if (this.isFirstExplanation() && this.getReasoner().isSatisfiable(unsatClass)) {
                return Collections.emptySet();
            }
            this.reset();
            this.expandUntilUnsatisfiable(unsatClass);
            this.pruneUntilMinimal(unsatClass);
            this.removeDeclarations();
            return new HashSet<OWLAxiom>(this.debuggingAxioms);
        }
        catch (OWLException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private int expandAxioms() {
        int added;
        int axiomsAdded = 0;
        int remainingSpace = this.expansionLimit;
        double expansionFactor = 1.25;
        for (OWLAxiom ax : new ArrayList<OWLAxiom>(this.debuggingAxioms)) {
            if (!this.expandedWithDefiningAxioms.add(ax)) continue;
            for (OWLEntity curObj : OWLAPIStreamUtils.asList(ax.signature())) {
                if (this.objectsExpandedWithDefiningAxioms.contains(curObj)) continue;
                added = this.expandWithDefiningAxioms(curObj, remainingSpace);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithDefiningAxioms.add(curObj);
            }
        }
        if (axiomsAdded > 0) {
            return axiomsAdded;
        }
        for (OWLAxiom ax : new ArrayList<OWLAxiom>(this.debuggingAxioms)) {
            if (!this.expandedWithReferencingAxioms.add(ax)) continue;
            for (OWLEntity curObj : OWLAPIStreamUtils.asList(ax.signature())) {
                if (this.objectsExpandedWithReferencingAxioms.contains(curObj)) continue;
                added = this.expandWithReferencingAxioms(curObj, this.expansionLimit);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithReferencingAxioms.add(curObj);
            }
        }
        return axiomsAdded;
    }

    private int expandWithDefiningAxioms(OWLEntity obj, int limit) {
        HashSet expansionAxioms = new HashSet();
        this.getOntology().importsClosure().forEach(ont -> {
            boolean referenceFound = false;
            if (obj instanceof OWLClass) {
                referenceFound = OWLAPIStreamUtils.add(expansionAxioms, ont.axioms((OWLClass)obj));
            } else if (obj.isOWLObjectProperty()) {
                referenceFound = OWLAPIStreamUtils.add(expansionAxioms, ont.axioms(obj.asOWLObjectProperty()));
            } else if (obj.isOWLDataProperty()) {
                referenceFound = OWLAPIStreamUtils.add(expansionAxioms, ont.axioms(obj.asOWLDataProperty()));
            } else if (obj instanceof OWLIndividual) {
                referenceFound = OWLAPIStreamUtils.add(expansionAxioms, ont.axioms((OWLIndividual)((Object)obj)));
            }
            if (!referenceFound) {
                expansionAxioms.add(this.man.getOWLDataFactory().getOWLDeclarationAxiom(obj));
            }
        });
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxExplanation.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private int expandWithReferencingAxioms(OWLEntity obj, int limit) {
        Set<OWLAxiom> expansionAxioms = OWLAPIStreamUtils.asUnorderedSet(this.getOntology().referencingAxioms(obj, Imports.INCLUDED));
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxExplanation.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private void performFastPruning(OWLClassExpression unsatClass) throws OWLException {
        HashSet<OWLAxiom> axiomWindow = new HashSet<OWLAxiom>();
        Object[] axioms = this.debuggingAxioms.toArray();
        LOGGER.info("Fast pruning: ");
        LOGGER.info("     - Window size: {}", (Object)this.fastPruningWindowSize);
        int windowCount = this.debuggingAxioms.size() / this.fastPruningWindowSize;
        for (int currentWindow = 0; currentWindow < windowCount; ++currentWindow) {
            axiomWindow.clear();
            int startIndex = currentWindow * this.fastPruningWindowSize;
            int endIndex = startIndex + this.fastPruningWindowSize;
            for (int axiomIndex = startIndex; axiomIndex < endIndex; ++axiomIndex) {
                OWLAxiom currentAxiom = (OWLAxiom)axioms[axiomIndex];
                axiomWindow.add(currentAxiom);
                this.debuggingAxioms.remove(currentAxiom);
            }
            if (!this.isSatisfiable(unsatClass)) continue;
            this.debuggingAxioms.addAll(axiomWindow);
        }
        axiomWindow.clear();
        int remainingAxiomsCount = this.debuggingAxioms.size() % this.fastPruningWindowSize;
        if (remainingAxiomsCount > 0) {
            for (int fragmentIndex = windowCount * this.fastPruningWindowSize; fragmentIndex < axioms.length; ++fragmentIndex) {
                OWLAxiom curAxiom = (OWLAxiom)axioms[fragmentIndex];
                axiomWindow.add(curAxiom);
                this.debuggingAxioms.remove(curAxiom);
            }
            if (this.isSatisfiable(unsatClass)) {
                this.debuggingAxioms.addAll(axiomWindow);
            }
        }
        LOGGER.info("    - End of fast pruning");
    }

    private void performSlowPruning(OWLClassExpression unsatClass) throws OWLException {
        ArrayList<OWLAxiom> axiomsCopy = new ArrayList<OWLAxiom>(this.debuggingAxioms);
        for (OWLAxiom ax : axiomsCopy) {
            this.debuggingAxioms.remove(ax);
            if (!this.isSatisfiable(unsatClass)) continue;
            this.debuggingAxioms.add(ax);
        }
    }

    private boolean isSatisfiable(OWLClassExpression unsatClass) throws OWLException {
        try {
            this.createDebuggingOntology();
            OWLReasoner reasoner = this.getReasonerFactory().createNonBufferingReasoner(OWLAPIPreconditions.verifyNotNull(this.debuggingOntology));
            if (OntologyUtils.containsUnreferencedEntity(OWLAPIPreconditions.verifyNotNull(this.debuggingOntology), unsatClass)) {
                reasoner.dispose();
                return true;
            }
            ++this.satTestCount;
            boolean sat = reasoner.isSatisfiable(unsatClass);
            reasoner.dispose();
            return sat;
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Illegal argument found - satisfiability cannot be checked for {} because of {}", (Object)unsatClass, (Object)e);
            return false;
        }
    }

    private void createDebuggingOntology() throws OWLException {
        if (this.debuggingOntology != null) {
            this.man.removeOntology(OWLAPIPreconditions.verifyNotNull(this.debuggingOntology));
        }
        this.debuggingOntology = this.man.createOntology(this.debuggingAxioms);
    }

    private void resetSatisfiabilityTestCounter() {
        this.satTestCount = 0;
    }

    private void expandUntilUnsatisfiable(OWLClassExpression unsatClass) throws OWLException {
        this.resetSatisfiabilityTestCounter();
        if (unsatClass.isAnonymous()) {
            OWLClass owlThing = this.man.getOWLDataFactory().getOWLThing();
            OWLSubClassOfAxiom axiom = this.man.getOWLDataFactory().getOWLSubClassOfAxiom(unsatClass, owlThing);
            this.debuggingAxioms.add(axiom);
            this.expandAxioms();
            this.debuggingAxioms.remove(axiom);
        } else {
            this.expandWithDefiningAxioms((OWLClass)unsatClass, this.expansionLimit);
        }
        LOGGER.info("Initial axiom count: {}", (Object)this.debuggingAxioms.size());
        int totalAdded = 0;
        int expansionCount = 0;
        while (this.isSatisfiable(unsatClass)) {
            LOGGER.info("Expanding axioms (expansion {})", (Object)expansionCount);
            ++expansionCount;
            int numberAdded = this.expandAxioms();
            totalAdded += numberAdded;
            LOGGER.info("    ... expanded by {}", (Object)numberAdded);
            if (numberAdded != 0) continue;
            LOGGER.info("ERROR! Cannot find SOS axioms!");
            this.debuggingAxioms.clear();
            return;
        }
        LOGGER.info("Total number of axioms added: {}", (Object)totalAdded);
    }

    protected void pruneUntilMinimal(OWLClassExpression unsatClass) throws OWLException {
        LOGGER.info("FOUND CLASH! Pruning {} axioms...", (Object)this.debuggingAxioms.size());
        this.resetSatisfiabilityTestCounter();
        LOGGER.info("Fast pruning...");
        this.fastPruningWindowSize = 10;
        this.performFastPruning(unsatClass);
        LOGGER.info("... end of fast pruning. Axioms remaining: {}", (Object)this.debuggingAxioms.size());
        LOGGER.info("Performed {} satisfiability tests during fast pruning", (Object)this.satTestCount);
        int totalSatTests = this.satTestCount;
        this.resetSatisfiabilityTestCounter();
        LOGGER.info("Slow pruning...");
        this.performSlowPruning(unsatClass);
        LOGGER.info("... end of slow pruning");
        LOGGER.info("Performed {} satisfiability tests during slow pruning", (Object)this.satTestCount);
        LOGGER.info("Total number of satisfiability tests performed: {}", (Object)(totalSatTests += this.satTestCount));
    }

    private void removeDeclarations() {
        this.debuggingAxioms = OWLAPIStreamUtils.asUnorderedSet(this.debuggingAxioms.stream().filter(ax -> !(ax instanceof OWLDeclarationAxiom)));
    }

    public String toString() {
        return "BlackBox";
    }
}

