/*
 * Decompiled with CFR 0.152.
 */
package openllet.aterm.pure;

import java.util.ArrayList;
import java.util.List;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.aterm.ATermPlaceholder;
import openllet.aterm.Visitor;
import openllet.aterm.pure.ATermImpl;
import openllet.aterm.pure.PureFactory;
import openllet.atom.SList;
import openllet.shared.hash.HashFunctions;
import openllet.shared.hash.SharedObject;

public class ATermListImpl
extends ATermImpl
implements ATermList {
    public static final String _illegalListIndex = "illegal list index: ";
    private ATerm _first;
    private ATermList _next;
    private int _length;

    protected ATermListImpl(PureFactory factory) {
        super(factory);
    }

    protected ATermListImpl(PureFactory factory, ATerm first, ATermList next) {
        super(factory);
        this._first = first;
        this._next = next;
        this._length = first == null && next == null ? 0 : 1 + next.getLength();
        this.setHashCode(this.hashFunction());
    }

    protected void init(int hashCode, ATerm first, ATermList next) {
        super.init(hashCode);
        this._first = first;
        this._next = next;
        this._length = first == null && next == null ? 0 : 1 + next.getLength();
    }

    @Override
    public int getType() {
        return 4;
    }

    protected void initHashCode(ATerm first, ATermList next) {
        this._first = first;
        this._next = next;
        this.setHashCode(this.hashFunction());
        this._length = first == null && next == null ? 0 : 1 + next.getLength();
    }

    @Override
    public SharedObject duplicate() {
        return this;
    }

    @Override
    public boolean equivalent(SharedObject obj) {
        if (obj instanceof ATermList) {
            ATermList peer = (ATermList)((Object)obj);
            if (peer.getType() != this.getType()) {
                return false;
            }
            return peer.getFirst() == this._first && peer.getNext() == this._next;
        }
        return false;
    }

    @Override
    public ATermList insert(ATerm head) {
        return this.getPureFactory().makeList(head, this);
    }

    protected ATermList make(ATerm head, ATermList tail) {
        return this.getPureFactory().makeList(head, tail);
    }

    @Override
    public ATermList getEmpty() {
        return this.getPureFactory().makeList();
    }

    @Override
    protected boolean match(ATerm pattern, List<Object> list) {
        if (pattern.getType() == 4) {
            ATermAppl appl;
            ATerm ph_type;
            ATermList l = (ATermList)pattern;
            if (l.isEmpty()) {
                return this.isEmpty();
            }
            if (((ATerm)l.getFirst()).getType() == 5 && (ph_type = ((ATermPlaceholder)l.getFirst()).getPlaceholder()).getType() == 1 && (appl = (ATermAppl)ph_type).getName().equals("list") && appl.getArguments().isEmpty()) {
                list.add(this);
                return true;
            }
            if (!this.isEmpty()) {
                List<Object> submatches = this._first.match((ATerm)l.getFirst());
                if (submatches == null) {
                    return false;
                }
                list.addAll(submatches);
                submatches = this._next.match(l.getNext());
                if (submatches == null) {
                    return false;
                }
                list.addAll(submatches);
                return true;
            }
            return l.isEmpty();
        }
        return super.match(pattern, list);
    }

    @Override
    public ATerm make(List<Object> args) {
        if (this._first == null) {
            return this;
        }
        ATerm head = this._first.make(args);
        ATermList tail = (ATermList)this._next.make(args);
        if (ATermListImpl.isListPlaceHolder(this._first)) {
            return head;
        }
        return tail.insert(head);
    }

    private static boolean isListPlaceHolder(ATerm pattern) {
        ATermAppl appl;
        AFun afun;
        ATerm type;
        return pattern.getType() == 5 && (type = ((ATermPlaceholder)pattern).getPlaceholder()).getType() == 1 && (afun = (appl = (ATermAppl)type).getAFun()).getName().equals("list") && afun.getArity() == 0 && !afun.isQuoted();
    }

    @Override
    public boolean isEmpty() {
        return this._first == null && this._next == null;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public ATerm getFirst() {
        return this._first;
    }

    @Override
    public ATermList getNext() {
        return this._next;
    }

    @Override
    public ATerm getLast() {
        ATermList cur = this;
        while (!cur.getNext().isEmpty()) {
            cur = cur.getNext();
        }
        return (ATerm)cur.getFirst();
    }

    private void raiseArgumentException(int startPos) {
        throw new IllegalArgumentException("start (" + startPos + ") > length of list (" + this._length + ")");
    }

    @Override
    public int indexOf(ATerm el, int start) {
        int i;
        int startPos = start;
        if (startPos < 0) {
            startPos += this._length + 1;
        }
        if (startPos > this._length) {
            this.raiseArgumentException(startPos);
        }
        ATermList cur = this;
        for (i = 0; i < startPos; ++i) {
            cur = cur.getNext();
        }
        while (!cur.isEmpty() && cur.getFirst() != el) {
            cur = cur.getNext();
            ++i;
        }
        return cur.isEmpty() ? -1 : i;
    }

    @Override
    public int lastIndexOf(ATerm el, int start) {
        int result;
        int startPos = start;
        if (startPos < 0) {
            startPos += this._length + 1;
        }
        if (startPos > this._length) {
            this.raiseArgumentException(startPos);
        }
        if (startPos > 0 && (result = this._next.lastIndexOf(el, startPos - 1)) >= 0) {
            return result + 1;
        }
        if (this._first == el) {
            return 0;
        }
        return -1;
    }

    @Override
    public SList<ATerm> concat(SList<ATerm> rhs) {
        if (this.isEmpty()) {
            return rhs;
        }
        if (this._next.isEmpty()) {
            return rhs.insert(this._first);
        }
        return this._next.concat(rhs).insert(this._first);
    }

    @Override
    public ATermList concat(ATermList rhs) {
        if (this.isEmpty()) {
            return rhs;
        }
        if (this._next.isEmpty()) {
            return rhs.insert(this._first);
        }
        return this._next.concat(rhs).insert(this._first);
    }

    @Override
    public ATermList append(ATerm el) {
        return this.concat(this.getEmpty().insert(el));
    }

    @Override
    public ATerm elementAt(int index) {
        if (0 > index || index >= this._length) {
            throw new IllegalArgumentException(_illegalListIndex + index);
        }
        ATermList cur = this;
        for (int i = 0; i < index; ++i) {
            cur = cur.getNext();
        }
        return (ATerm)cur.getFirst();
    }

    @Override
    public ATermList remove(ATerm el) {
        if (this._first == el) {
            return this._next;
        }
        ATermList result = this._next.remove(el);
        if (result == this._next) {
            return this;
        }
        return result.insert(this._first);
    }

    @Override
    public ATermList removeElementAt(int index) {
        if (0 > index || index > this._length) {
            throw new IllegalArgumentException(_illegalListIndex + index);
        }
        if (index == 0) {
            return this._next;
        }
        return this._next.removeElementAt(index - 1).insert(this._first);
    }

    @Override
    public ATermList removeAll(ATerm el) {
        if (this._first == el) {
            return this._next.removeAll(el);
        }
        ATermList result = this._next.removeAll(el);
        if (result == this._next) {
            return this;
        }
        return result.insert(this._first);
    }

    @Override
    public ATermList insertAt(ATerm el, int i) {
        if (0 > i || i > this._length) {
            throw new IllegalArgumentException(_illegalListIndex + i);
        }
        if (i == 0) {
            return this.insert(el);
        }
        return this._next.insertAt(el, i - 1).insert(this._first);
    }

    @Override
    public ATermList getPrefix() {
        if (this.isEmpty()) {
            return this;
        }
        ATermList cur = this;
        ArrayList elems = new ArrayList();
        while (true) {
            if (cur.getNext().isEmpty()) {
                cur = this.getPureFactory().getEmpty();
                for (int i = elems.size() - 1; i >= 0; --i) {
                    cur = cur.insert((ATerm)elems.get(i));
                }
                return cur;
            }
            elems.add(cur.getFirst());
            cur = cur.getNext();
        }
    }

    @Override
    public ATermList getSlice(int start, int end) {
        int i;
        int size = end - start;
        ATermList list = this;
        for (i = 0; i < start; ++i) {
            list = list.getNext();
        }
        ArrayList buffer = new ArrayList(size);
        for (i = 0; i < size; ++i) {
            buffer.add(list.getFirst());
            list = list.getNext();
        }
        ATermList result = this.getPureFactory().getEmpty();
        --i;
        while (i >= 0) {
            result = result.insert((ATerm)buffer.get(i));
            --i;
        }
        return result;
    }

    @Override
    public ATermList replace(ATerm el, int i) {
        int lcv;
        if (0 > i || i > this._length) {
            throw new IllegalArgumentException(_illegalListIndex + i);
        }
        ArrayList buffer = new ArrayList(i);
        ATermList cur = this;
        for (lcv = 0; lcv < i; ++lcv) {
            buffer.add(cur.getFirst());
            cur = cur.getNext();
        }
        cur = cur.getNext();
        cur = cur.insert(el);
        --lcv;
        while (lcv >= 0) {
            cur = cur.insert((ATerm)buffer.get(lcv));
            --lcv;
        }
        return cur;
    }

    @Override
    public ATermList reverse() {
        ATermList cur = this;
        ATermList reverse = this.getEmpty();
        while (!cur.isEmpty()) {
            reverse = reverse.insert((ATerm)cur.getFirst());
            cur = cur.getNext();
        }
        return reverse;
    }

    @Override
    public ATerm dictGet(ATerm key) {
        if (this.isEmpty()) {
            return null;
        }
        ATermList pair = (ATermList)this._first;
        if (key.equals(pair.getFirst())) {
            return (ATerm)pair.getNext().getFirst();
        }
        return this._next.dictGet(key);
    }

    @Override
    public ATermList dictPut(ATerm key, ATerm value) {
        if (this.isEmpty()) {
            ATermList pair = this.getEmpty().insert(value).insert(key);
            return this.getEmpty().insert(pair);
        }
        ATermList pair = (ATermList)this._first;
        if (key.equals(pair.getFirst())) {
            pair = this.getEmpty().insert(value).insert(pair);
            return this._next.insert(pair);
        }
        return this._next.dictPut(key, value).insert(this._first);
    }

    @Override
    public ATermList dictRemove(ATerm key) {
        if (this.isEmpty()) {
            return this;
        }
        ATermList pair = (ATermList)this._first;
        if (key.equals(pair.getFirst())) {
            return this._next;
        }
        return this._next.dictRemove(key).insert(this._first);
    }

    @Override
    public ATerm accept(Visitor<ATerm> v) {
        return v.visitList(this);
    }

    @Override
    public int getNrSubTerms() {
        return this._length;
    }

    @Override
    public ATerm getSubTerm(int index) {
        return this.elementAt(index);
    }

    @Override
    public ATerm setSubTerm(int index, ATerm t) {
        return this.replace(t, index);
    }

    protected int findEmptyHashCode() {
        int magic = 0;
        for (int x = Integer.MIN_VALUE; x < Integer.MAX_VALUE; ++x) {
            int a = -1640531527 + (x << 16);
            int c = HashFunctions.mix(a, -1640531527, 3);
            if (c != x) continue;
            magic = x;
        }
        return magic;
    }

    private int hashFunction() {
        int a = -1640531527;
        if (this._next != null && this._first != null) {
            a += this._next.hashCode() << 8;
            a += this._first.hashCode();
        }
        return HashFunctions.mix(a, -1640531527, 3);
    }
}

