/*
 * Decompiled with CFR 0.152.
 */
package openllet.aterm.pure.binary;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermBlob;
import openllet.aterm.ATermFwdVoid;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.aterm.ATermLong;
import openllet.aterm.ATermPlaceholder;
import openllet.aterm.ATermReal;
import openllet.aterm.pure.binary.ATermMapping;

public class BinaryWriter
extends ATermFwdVoid {
    private static final int ISSHAREDFLAG = 128;
    private static final int ISFUNSHARED = 64;
    private static final int APPLQUOTED = 32;
    private static final int STACKSIZE = 256;
    private static final int MINIMUMFREESPACE = 10;
    private final Map<ATerm, Integer> _sharedTerms = new HashMap<ATerm, Integer>();
    private int _currentKey = 0;
    private final Map<AFun, Integer> _applSignatures = new HashMap<AFun, Integer>();
    private int _sigKey = 0;
    private ATermMapping[] _stack = new ATermMapping[256];
    private int _stackPosition = 0;
    private ATerm _currentTerm;
    private int _indexInTerm;
    private byte[] _tempNameWriteBuffer;
    private ByteBuffer _currentBuffer;
    private static final int SEVENBITS = 127;
    private static final int SIGNBIT = 128;
    private static final int LONGBITS = 8;

    public BinaryWriter(ATerm root) {
        ATermMapping tm;
        this._stack[this._stackPosition] = tm = new ATermMapping(root);
        this._currentTerm = root;
        this._indexInTerm = 0;
        this._tempNameWriteBuffer = null;
    }

    public void serialize(ByteBuffer buffer) {
        this._currentBuffer = buffer;
        while (this._currentTerm != null && buffer.remaining() >= 10) {
            Integer id = this._sharedTerms.get(this._currentTerm);
            if (id != null) {
                buffer.put((byte)-128);
                this.writeInt(id);
                --this._stackPosition;
            } else {
                this.visit(this._currentTerm);
                if (this._currentTerm.getType() == 4) {
                    this._stack[this._stackPosition].nextPartOfList = (ATermList)this._currentTerm;
                }
                if (this._indexInTerm != 0) break;
                this._sharedTerms.put(this._currentTerm, new Integer(this._currentKey++));
            }
            this._currentTerm = this.getNextTerm();
        }
        buffer.flip();
    }

    public boolean isFinished() {
        return this._currentTerm == null;
    }

    private ATerm getNextTerm() {
        ATerm next = null;
        this.ensureStackCapacity();
        while (next == null && this._stackPosition > -1) {
            ATermMapping current = this._stack[this._stackPosition];
            ATerm term = current.term;
            if (term.getChildCount() > current.subTermIndex + 1) {
                if (term.getType() != 4) {
                    next = term.getChildAt(++current.subTermIndex);
                } else {
                    ATermList nextList = current.nextPartOfList;
                    next = (ATerm)nextList.getFirst();
                    current.nextPartOfList = nextList.getNext();
                    ++current.subTermIndex;
                }
                ATermMapping child = new ATermMapping(next);
                this._stack[++this._stackPosition] = child;
                continue;
            }
            --this._stackPosition;
        }
        return next;
    }

    private void ensureStackCapacity() {
        int stackSize = this._stack.length;
        if (this._stackPosition + 1 == stackSize) {
            ATermMapping[] newStack = new ATermMapping[stackSize << 1];
            System.arraycopy(this._stack, 0, newStack, 0, this._stack.length);
            this._stack = newStack;
        }
    }

    private static byte getHeader(ATerm term) {
        return (byte)term.getType();
    }

    @Override
    public void voidVisitAppl(ATermAppl arg) {
        if (this._indexInTerm == 0) {
            byte header = BinaryWriter.getHeader(arg);
            AFun fun = arg.getAFun();
            Integer key = this._applSignatures.get(fun);
            if (key == null) {
                if (arg.isQuoted()) {
                    header = (byte)(header | 0x20);
                }
                this._currentBuffer.put(header);
                this.writeInt(arg.getArity());
                String name = fun.getName();
                byte[] nameBytes = name.getBytes();
                int length = nameBytes.length;
                this.writeInt(length);
                int endIndex = length;
                int remaining = this._currentBuffer.remaining();
                if (remaining < endIndex) {
                    endIndex = remaining;
                }
                this._currentBuffer.put(nameBytes, 0, endIndex);
                if (endIndex != length) {
                    this._indexInTerm = endIndex;
                    this._tempNameWriteBuffer = nameBytes;
                }
                this._applSignatures.put(fun, new Integer(this._sigKey++));
            } else {
                header = (byte)(header | 0x40);
                this._currentBuffer.put(header);
                this.writeInt(key);
            }
        } else {
            int length;
            int endIndex = length = this._tempNameWriteBuffer.length;
            int remaining = this._currentBuffer.remaining();
            if (this._indexInTerm + remaining < endIndex) {
                endIndex = this._indexInTerm + remaining;
            }
            this._currentBuffer.put(this._tempNameWriteBuffer, this._indexInTerm, endIndex - this._indexInTerm);
            this._indexInTerm = endIndex;
            if (this._indexInTerm == length) {
                this._indexInTerm = 0;
                this._tempNameWriteBuffer = null;
            }
        }
    }

    @Override
    public void voidVisitBlob(ATermBlob arg) {
        int size = arg.getBlobSize();
        if (this._indexInTerm == 0) {
            this._currentBuffer.put(BinaryWriter.getHeader(arg));
            this.writeInt(size);
        }
        byte[] blobBytes = arg.getBlobData();
        int bytesToWrite = size - this._indexInTerm;
        int remaining = this._currentBuffer.remaining();
        if (remaining < bytesToWrite) {
            bytesToWrite = remaining;
        }
        this._currentBuffer.put(blobBytes, this._indexInTerm, bytesToWrite);
        this._indexInTerm += bytesToWrite;
        if (this._indexInTerm == size) {
            this._indexInTerm = 0;
        }
    }

    @Override
    public void voidVisitInt(ATermInt arg) {
        this._currentBuffer.put(BinaryWriter.getHeader(arg));
        this.writeInt(arg.getInt());
    }

    @Override
    public void voidVisitLong(ATermLong arg) {
        this._currentBuffer.put(BinaryWriter.getHeader(arg));
        this.writeLong(arg.getLong());
    }

    @Override
    public void voidVisitList(ATermList arg) {
        byte header = BinaryWriter.getHeader(arg);
        this._currentBuffer.put(header);
        this.writeInt(arg.getLength());
    }

    @Override
    public void voidVisitPlaceholder(ATermPlaceholder arg) {
        this._currentBuffer.put(BinaryWriter.getHeader(arg));
    }

    @Override
    public void voidVisitReal(ATermReal arg) {
        this._currentBuffer.put(BinaryWriter.getHeader(arg));
        this.writeDouble(arg.getReal());
    }

    private void writeInt(int value) {
        int intValue = value;
        if ((intValue & 0xFFFFFF80) == 0) {
            this._currentBuffer.put((byte)(intValue & 0x7F));
            return;
        }
        this._currentBuffer.put((byte)(intValue & 0x7F | 0x80));
        if ((intValue & 0xFFFFC000) == 0) {
            this._currentBuffer.put((byte)(intValue >>> 7 & 0x7F));
            return;
        }
        this._currentBuffer.put((byte)(intValue >>> 7 & 0x7F | 0x80));
        if ((intValue & 0xFFE00000) == 0) {
            this._currentBuffer.put((byte)(intValue >>> 14 & 0x7F));
            return;
        }
        this._currentBuffer.put((byte)(intValue >>> 14 & 0x7F | 0x80));
        if ((intValue & 0xF0000000) == 0) {
            this._currentBuffer.put((byte)(intValue >>> 21 & 0x7F));
            return;
        }
        this._currentBuffer.put((byte)(intValue >>> 21 & 0x7F | 0x80));
        this._currentBuffer.put((byte)(intValue >>> 28 & 0x7F));
    }

    private void writeDouble(double value) {
        long longValue = Double.doubleToLongBits(value);
        this.writeLong(longValue);
    }

    private void writeLong(long value) {
        for (int i = 0; i < 8; ++i) {
            this._currentBuffer.put((byte)(value >>> i * 8));
        }
    }

    public static void writeTermToSAFFile(ATerm aTerm, File file) throws IOException {
        BinaryWriter binaryWriter = new BinaryWriter(aTerm);
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        ByteBuffer sizeBuffer = ByteBuffer.allocate(2);
        try (FileOutputStream fos = new FileOutputStream(file);
             FileChannel fc = fos.getChannel();){
            byteBuffer.put((byte)63);
            byteBuffer.flip();
            fc.write(byteBuffer);
            do {
                byteBuffer.clear();
                binaryWriter.serialize(byteBuffer);
                int blockSize = byteBuffer.limit();
                sizeBuffer.clear();
                sizeBuffer.put((byte)(blockSize & 0xFF));
                sizeBuffer.put((byte)(blockSize >>> 8 & 0xFF));
                sizeBuffer.flip();
                fc.write(sizeBuffer);
                fc.write(byteBuffer);
            } while (!binaryWriter.isFinished());
        }
    }

    public static byte[] writeTermToSAFString(ATerm aTerm) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        int totalBytesWritten = 0;
        BinaryWriter binaryWriter = new BinaryWriter(aTerm);
        do {
            ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
            binaryWriter.serialize(byteBuffer);
            buffers.add(byteBuffer);
            totalBytesWritten += byteBuffer.limit() + 2;
        } while (!binaryWriter.isFinished());
        byte[] data = new byte[totalBytesWritten];
        int position = 0;
        int numberOfBuffers = buffers.size();
        for (int i = 0; i < numberOfBuffers; ++i) {
            ByteBuffer buffer = (ByteBuffer)buffers.get(i);
            int blockSize = buffer.limit();
            data[position++] = (byte)(blockSize & 0xFF);
            data[position++] = (byte)(blockSize >>> 8 & 0xFF);
            System.arraycopy(buffer.array(), 0, data, position, blockSize);
            position += blockSize;
        }
        return data;
    }
}

