/*
 * Decompiled with CFR 0.152.
 */
package openllet.aterm.pure.owl;

import java.io.IOException;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.Visitor;
import openllet.aterm.pure.ATermImpl;
import openllet.aterm.pure.PureFactory;
import openllet.aterm.stream.BufferedOutputStreamWriter;
import openllet.shared.hash.HashFunctions;
import openllet.shared.hash.SharedObject;

public abstract class AFunOwl
extends ATermImpl
implements AFun {
    protected AFunOwl(PureFactory factory, boolean lateHashComputation) {
        super(factory);
        if (!lateHashComputation) {
            this.setHashCode(HashFunctions.hashTerm(this.getName(), this.isQuoted(), this.getArity()));
        }
    }

    protected AFunOwl(PureFactory factory) {
        super(factory);
        this.setHashCode(HashFunctions.hashTerm(this.getName(), this.isQuoted(), this.getArity()));
    }

    @Override
    public SharedObject duplicate() {
        return this;
    }

    @Override
    public boolean equivalent(SharedObject obj) {
        if (obj instanceof AFun) {
            AFun peer = (AFun)((Object)obj);
            return peer.getName().equals(this.getName()) && peer.getArity() == this.getArity() && peer.isQuoted() == this.isQuoted();
        }
        return false;
    }

    @Override
    public boolean isQuoted() {
        return false;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public int serialize(BufferedOutputStreamWriter writer) throws IOException {
        String name = this.getName();
        int bytesWritten = 0;
        if (this.isQuoted()) {
            writer.write('\"');
            ++bytesWritten;
        }
        int numberOfCharacters = name.length();
        bytesWritten += numberOfCharacters;
        block11: for (int i = 0; i < numberOfCharacters; ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '\n': {
                    writer.write('\\');
                    writer.write('n');
                    ++bytesWritten;
                    continue block11;
                }
                case '\t': {
                    writer.write('\\');
                    writer.write('t');
                    ++bytesWritten;
                    continue block11;
                }
                case '\b': {
                    writer.write('\\');
                    writer.write('b');
                    ++bytesWritten;
                    continue block11;
                }
                case '\r': {
                    writer.write('\\');
                    writer.write('r');
                    ++bytesWritten;
                    continue block11;
                }
                case '\f': {
                    writer.write('\\');
                    writer.write('f');
                    ++bytesWritten;
                    continue block11;
                }
                case '\\': {
                    writer.write('\\');
                    writer.write('\\');
                    ++bytesWritten;
                    continue block11;
                }
                case '\'': {
                    writer.write('\\');
                    writer.write('\'');
                    ++bytesWritten;
                    continue block11;
                }
                case '\"': {
                    writer.write('\\');
                    writer.write('\"');
                    ++bytesWritten;
                    continue block11;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    writer.write(c);
                    continue block11;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        writer.write(c);
                        continue block11;
                    }
                    writer.write('\\');
                    writer.write(48 + c / 64);
                    c = (char)(c % 64);
                    writer.write(48 + c / 8);
                    c = (char)(c % 8);
                    writer.write(48 + c);
                    bytesWritten += 3;
                }
            }
        }
        if (this.isQuoted()) {
            writer.write('\"');
            ++bytesWritten;
        }
        return bytesWritten;
    }

    @Override
    public String toString() {
        String name = this.getName();
        StringBuilder result = new StringBuilder(name.length());
        if (this.isQuoted()) {
            result.append('\"');
        }
        block11: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '\n': {
                    result.append('\\');
                    result.append('n');
                    continue block11;
                }
                case '\t': {
                    result.append('\\');
                    result.append('t');
                    continue block11;
                }
                case '\b': {
                    result.append('\\');
                    result.append('b');
                    continue block11;
                }
                case '\r': {
                    result.append('\\');
                    result.append('r');
                    continue block11;
                }
                case '\f': {
                    result.append('\\');
                    result.append('f');
                    continue block11;
                }
                case '\\': {
                    result.append('\\');
                    result.append('\\');
                    continue block11;
                }
                case '\'': {
                    result.append('\\');
                    result.append('\'');
                    continue block11;
                }
                case '\"': {
                    result.append('\\');
                    result.append('\"');
                    continue block11;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    result.append(c);
                    continue block11;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        result.append(c);
                        continue block11;
                    }
                    result.append('\\');
                    result.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    result.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    result.append((char)(48 + c));
                }
            }
        }
        if (this.isQuoted()) {
            result.append('\"');
        }
        return result.toString();
    }

    @Override
    public ATerm accept(Visitor<ATerm> v) {
        return v.visitAFun(this);
    }
}

