/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.abox;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.DependencySet;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.ABoxStats;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.DefaultEdge;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.IndividualIterator;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.abox.NodeMerge;
import openllet.core.boxes.rbox.RBox;
import openllet.core.boxes.rbox.Role;
import openllet.core.boxes.tbox.TBox;
import openllet.core.datatypes.DatatypeReasoner;
import openllet.core.datatypes.DatatypeReasonerImpl;
import openllet.core.datatypes.exceptions.DatatypeReasonerException;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.exceptions.UnrecognizedDatatypeException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.expressivity.Expressivity;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.cache.CachedNode;
import openllet.core.tableau.cache.CachedNodeFactory;
import openllet.core.tableau.cache.ConceptCache;
import openllet.core.tableau.cache.ConceptCacheLRU;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.SROIQIncStrategy;
import openllet.core.tableau.completion.queue.BasicCompletionQueue;
import openllet.core.tableau.completion.queue.CompletionQueue;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.queue.OptimizedBasicCompletionQueue;
import openllet.core.tableau.completion.queue.QueueElement;
import openllet.core.tracker.BranchEffectTracker;
import openllet.core.tracker.IncrementalChangeTracker;
import openllet.core.tracker.SimpleBranchEffectTracker;
import openllet.core.tracker.SimpleIncrementalChangeTracker;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Bool;
import openllet.core.utils.CandidateSet;
import openllet.core.utils.MultiMapUtils;
import openllet.core.utils.SetUtils;
import openllet.core.utils.Timer;
import openllet.core.utils.fsm.State;
import openllet.core.utils.fsm.Transition;
import openllet.core.utils.fsm.TransitionGraph;
import openllet.core.utils.iterator.MultiListIterator;
import openllet.shared.tools.Log;

public class ABoxImpl
implements ABox {
    private static final Logger _logger = Log.getLogger(ABoxImpl.class);
    private final ABoxStats _stats = new ABoxStats();
    private final DatatypeReasoner _dtReasoner;
    private final KnowledgeBase _kb;
    private final BranchEffectTracker _branchEffects;
    private final CompletionQueue _completionQueue;
    private final IncrementalChangeTracker _incChangeTracker;
    private final List<Branch> _branches;
    private final List<ATermAppl> _nodeList;
    private final Set<Clash> _assertedClashes;
    private final List<NodeMerge> _toBeMerged;
    private final Map<ATermAppl, int[]> _disjBranchStats;
    private final Map<ATermAppl, Node> _nodes;
    private volatile int _branchIndex;
    private volatile Clash _clash;
    private volatile ABox _sourceABox;
    private volatile ABox _lastCompletion;
    private volatile Clash _lastClash;
    private volatile int _anonCount = 0;
    private volatile boolean _keepLastCompletion;
    private volatile boolean _isComplete = false;
    private volatile boolean _changed = false;
    private volatile boolean _doExplanation = false;
    private volatile boolean _initialized = false;
    private volatile boolean _rulesNotApplied = false;
    private volatile boolean _syntacticUpdate = false;
    private volatile ConceptCache _cache;

    @Override
    public Logger getLogger() {
        return _logger;
    }

    @Override
    public ABoxStats getStats() {
        return this._stats;
    }

    @Override
    public List<ATermAppl> getNodeList() {
        return this._nodeList;
    }

    @Override
    public ABox getSourceABox() {
        return this._sourceABox;
    }

    @Override
    public void setSourceABox(ABox sourceABox) {
        this._sourceABox = sourceABox;
    }

    @Override
    public boolean isRulesNotApplied() {
        return this._rulesNotApplied;
    }

    @Override
    public void setRulesNotApplied(boolean rulesNotApplied) {
        this._rulesNotApplied = rulesNotApplied;
    }

    public ABoxImpl(KnowledgeBase kb) {
        this._kb = kb;
        this._nodes = Collections.synchronizedMap(new IdentityHashMap());
        this._nodeList = new ArrayList<ATermAppl>();
        this._clash = null;
        this._assertedClashes = SetUtils.create();
        this._doExplanation = false;
        this._dtReasoner = new DatatypeReasonerImpl();
        this._keepLastCompletion = false;
        this.setBranchIndex(-1);
        this._branches = new ArrayList<Branch>();
        this._disjBranchStats = Collections.synchronizedMap(new IdentityHashMap());
        this._toBeMerged = new ArrayList<NodeMerge>();
        this._rulesNotApplied = true;
        this._branchEffects = OpenlletOptions.TRACK_BRANCH_EFFECTS ? new SimpleBranchEffectTracker() : null;
        this._completionQueue = OpenlletOptions.USE_COMPLETION_QUEUE ? (OpenlletOptions.USE_OPTIMIZED_BASIC_COMPLETION_QUEUE ? new OptimizedBasicCompletionQueue(this) : new BasicCompletionQueue(this)) : null;
        this._incChangeTracker = OpenlletOptions.USE_INCREMENTAL_CONSISTENCY ? new SimpleIncrementalChangeTracker() : null;
    }

    public ABoxImpl(KnowledgeBase kb, boolean copyCache) {
        this(kb);
        if (copyCache) {
            this._cache = kb.getABox().getCache();
        }
    }

    public ABoxImpl(KnowledgeBase kb, ABoxImpl abox, ATermAppl extraIndividual, boolean copyIndividuals) {
        Object copy;
        this._kb = kb;
        Optional<Timer> timer = kb.getTimers().startTimer("cloneABox");
        this._rulesNotApplied = true;
        this._initialized = abox._initialized;
        this.setChanged(abox.isChanged());
        this.setAnonCount(abox.getAnonCount());
        this._cache = abox._cache;
        this._clash = abox._clash;
        this._dtReasoner = abox._dtReasoner;
        this._doExplanation = abox._doExplanation;
        this._disjBranchStats = abox.getDisjBranchStats();
        int extra = extraIndividual == null ? 0 : 1;
        int nodeCount = extra + (copyIndividuals ? abox._nodes.size() : 0);
        this._nodes = Collections.synchronizedMap(new IdentityHashMap(nodeCount));
        this._nodeList = new ArrayList<ATermAppl>(nodeCount);
        this._branchEffects = OpenlletOptions.TRACK_BRANCH_EFFECTS ? (copyIndividuals ? abox._branchEffects.copy() : new SimpleBranchEffectTracker()) : null;
        if (OpenlletOptions.USE_COMPLETION_QUEUE) {
            if (copyIndividuals) {
                this._completionQueue = abox._completionQueue.copy();
                this._completionQueue.setABox(this);
            } else {
                this._completionQueue = OpenlletOptions.USE_OPTIMIZED_BASIC_COMPLETION_QUEUE ? new OptimizedBasicCompletionQueue(this) : new BasicCompletionQueue(this);
            }
        } else {
            this._completionQueue = null;
        }
        if (extraIndividual != null) {
            Individual n = new Individual(extraIndividual, this, null);
            n.setNominalLevel(Integer.MAX_VALUE);
            n.setConceptRoot(true);
            n.addType(ATermUtils.TOP, DependencySet.INDEPENDENT);
            this._nodes.put(extraIndividual, n);
            this._nodeList.add(extraIndividual);
            if (OpenlletOptions.COPY_ON_WRITE) {
                this._sourceABox = abox;
            }
        }
        if (copyIndividuals) {
            this._toBeMerged = abox.getToBeMerged();
            if (this._sourceABox == null) {
                for (int i = 0; i < nodeCount - extra; ++i) {
                    ATermAppl x = abox._nodeList.get(i);
                    Node node = abox.getNode(x);
                    copy = node.copyTo(this);
                    this._nodes.put(x, (Node)copy);
                    this._nodeList.add(x);
                }
                for (Node node : this._nodes.values()) {
                    node.updateNodeReferences();
                }
            }
        } else {
            this._toBeMerged = Collections.emptyList();
            this._sourceABox = null;
            this._initialized = false;
        }
        this._incChangeTracker = OpenlletOptions.USE_INCREMENTAL_CONSISTENCY ? (copyIndividuals ? abox._incChangeTracker.copy(this) : new SimpleIncrementalChangeTracker()) : null;
        this._assertedClashes = SetUtils.create();
        for (Clash clash : abox._assertedClashes) {
            this._assertedClashes.add(clash.copyTo(this));
        }
        if (extraIndividual == null || copyIndividuals) {
            this.setBranchIndex(abox._branchIndex);
            this._branches = new ArrayList<Branch>(abox._branches.size());
            int n = abox._branches.size();
            for (int i = 0; i < n; ++i) {
                Branch branch = abox._branches.get(i);
                if (this._sourceABox == null) {
                    copy = branch.copyTo(this);
                    ((Branch)copy).setNodeCount(branch.getNodeCount() + extra);
                } else {
                    copy = branch;
                }
                this._branches.add((Branch)copy);
            }
        } else {
            this.setBranchIndex(-1);
            this._branches = new ArrayList<Branch>();
        }
        timer.ifPresent(t -> t.stop());
    }

    @Override
    public ABoxImpl copy() {
        return this.copy(this._kb);
    }

    @Override
    public ABoxImpl copy(KnowledgeBase kb) {
        return new ABoxImpl(kb, this, null, true);
    }

    @Override
    public ABoxImpl copy(ATermAppl extraIndividual, boolean copyIndividuals) {
        return new ABoxImpl(this._kb, this, extraIndividual, copyIndividuals);
    }

    @Override
    public void copyOnWrite() {
        if (this._sourceABox == null) {
            return;
        }
        Optional<Timer> timer = this._kb.getTimers().startTimer("copyOnWrite");
        ArrayList<ATermAppl> currentNodeList = new ArrayList<ATermAppl>(this._nodeList);
        int currentSize = currentNodeList.size();
        int nodeCount = this.getSourceABox().getNodes().size();
        this._nodeList.clear();
        this._nodeList.add((ATermAppl)currentNodeList.get(0));
        for (int i = 0; i < nodeCount; ++i) {
            ATermAppl x = this.getSourceABox().getNodeList().get(i);
            Node node = this._sourceABox.getNode(x);
            Node copyNode = node.copyTo(this);
            this._nodes.put(x, copyNode);
            this._nodeList.add(x);
        }
        if (currentSize > 1) {
            this._nodeList.addAll(currentNodeList.subList(1, currentSize));
        }
        for (Node node : this._nodes.values()) {
            if (!this.getSourceABox().getNodes().containsKey(node.getName())) continue;
            node.updateNodeReferences();
        }
        int n = this._branches.size();
        for (int i = 0; i < n; ++i) {
            Branch branch = this._branches.get(i);
            Branch copy = branch.copyTo(this);
            this._branches.set(i, copy);
            if (i >= this._sourceABox.getBranches().size()) {
                copy.setNodeCount(copy.getNodeCount() + nodeCount);
                continue;
            }
            copy.setNodeCount(copy.getNodeCount() + 1);
        }
        timer.ifPresent(t -> t.stop());
        this._sourceABox = null;
    }

    @Override
    public void clearCaches(boolean clearSatCache) {
        this._lastCompletion = null;
        if (clearSatCache) {
            this._cache = new ConceptCacheLRU(this._kb);
        }
    }

    @Override
    public Bool getCachedSat(ATermAppl c) {
        return this._cache.getSat(c);
    }

    @Override
    public ConceptCache getCache() {
        return this._cache;
    }

    @Override
    public CachedNode getCached(ATermAppl c) {
        if (ATermUtils.isNominal(c)) {
            return this.getIndividual(c.getArgument(0)).getSame();
        }
        return (CachedNode)this._cache.get(c);
    }

    private void cache(Individual rootNode, ATermAppl c, boolean isConsistent) {
        if (!isConsistent) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Unsatisfiable: " + ATermUtils.toString(c));
                _logger.fine("Equivalent to TOP: " + ATermUtils.toString(ATermUtils.negate(c)));
            }
            this._cache.putSat(c, false);
        } else {
            _logger.fine(() -> "Cache " + rootNode.debugString());
            this._cache.put(c, CachedNodeFactory.createNode(c, rootNode));
        }
    }

    @Override
    public Bool isKnownSubClassOf(ATermAppl c1, ATermAppl c2) {
        Bool isSubClassOf = Bool.UNKNOWN;
        CachedNode cached = this.getCached(c1);
        if (cached != null) {
            isSubClassOf = this.isType(cached, c2);
        }
        return isSubClassOf;
    }

    @Override
    public boolean isSubClassOf(ATermAppl c1, ATermAppl c2) {
        Bool isKnownSubClass;
        if (!this._doExplanation && (isKnownSubClass = this.isKnownSubClassOf(c1, c2)).isKnown()) {
            return isKnownSubClass.isTrue();
        }
        if (_logger.isLoggable(Level.FINE)) {
            long count = this._kb.getTimers().getTimer("subClassSat").map(t -> t.getCount()).orElse(0L);
            _logger.fine(count + ") Checking subclass [" + ATermUtils.toString(c1) + " " + ATermUtils.toString(c2) + "]");
        }
        ATermAppl notC2 = ATermUtils.negate(c2);
        ATermAppl c = ATermUtils.makeAnd(c1, notC2);
        Optional<Timer> timer = this._kb.getTimers().startTimer("subClassSat");
        boolean sub = !this.isSatisfiable(c, false);
        timer.ifPresent(t -> t.stop());
        _logger.fine(() -> " Result: " + sub + timer.map(t -> " (" + t.getLast() + "ms)").orElse(""));
        return sub;
    }

    @Override
    public boolean isSatisfiable(ATermAppl c) {
        boolean cacheModel = OpenlletOptions.USE_CACHING && (ATermUtils.isPrimitiveOrNegated(c) || OpenlletOptions.USE_ADVANCED_CACHING);
        return this.isSatisfiable(c, cacheModel);
    }

    @Override
    public boolean isSatisfiable(ATermAppl cParam, boolean cacheModel) {
        CachedNode cached;
        ATermAppl c = cParam;
        if ((c = ATermUtils.normalize(c)).equals(ATermUtils.BOTTOM)) {
            this._lastClash = Clash.unexplained(null, DependencySet.INDEPENDENT, "Obvious contradiction in class expression: " + ATermUtils.toString(c));
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Satisfiability for " + ATermUtils.toString(c));
        }
        if (cacheModel && (cached = this.getCached(c)) != null) {
            boolean needToCacheModel;
            boolean satisfiable = !cached.isBottom();
            boolean bl = needToCacheModel = cacheModel && !cached.isComplete();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Cached sat for " + ATermUtils.toString(c) + " is " + satisfiable);
            }
            if (!(needToCacheModel || !satisfiable && this._doExplanation)) {
                return satisfiable;
            }
        }
        ++this._stats._satisfiabilityCount;
        Optional<Timer> timer = this._kb.getTimers().startTimer("satisfiability");
        boolean isSat = this.isConsistent(Collections.emptySet(), c, cacheModel);
        timer.ifPresent(t -> t.stop());
        return isSat;
    }

    @Override
    public CandidateSet<ATermAppl> getObviousInstances(ATermAppl c) {
        return this.getObviousInstances(c, this._kb.getIndividuals());
    }

    @Override
    public CandidateSet<ATermAppl> getObviousInstances(ATermAppl cParam, Collection<ATermAppl> individuals) {
        ATermAppl c = cParam;
        c = ATermUtils.normalize(c);
        Set<ATermAppl> subs = this._kb.isClassified() && this._kb.getTaxonomy().contains(c) ? this._kb.getTaxonomy().getFlattenedSubs(c, false) : Collections.emptySet();
        subs.remove(ATermUtils.BOTTOM);
        CandidateSet<ATermAppl> cs = new CandidateSet<ATermAppl>();
        for (ATermAppl x : individuals) {
            Bool isType = this.isKnownType(x, c, subs);
            cs.add(x, isType);
        }
        return cs;
    }

    @Override
    public void getObviousTypes(ATermAppl x, List<ATermAppl> types, List<ATermAppl> nonTypes) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual pNode = this.getIndividual(x);
        pNode = !pNode.getMergeDependency(true).isIndependent() ? this.getIndividual(x) : pNode.getSame();
        pNode.getObviousTypes(types, nonTypes);
    }

    @Override
    public CandidateSet<ATermAppl> getObviousSubjects(ATermAppl p, ATermAppl o) {
        CandidateSet<ATermAppl> candidates = new CandidateSet<ATermAppl>(this._kb.getIndividuals());
        this.getObviousSubjects(p, o, candidates);
        return candidates;
    }

    @Override
    public void getSubjects(ATermAppl p, ATermAppl o, CandidateSet<ATermAppl> candidates) {
        Iterator<ATermAppl> i = candidates.iterator();
        while (i.hasNext()) {
            ATermAppl s = i.next();
            Bool hasObviousValue = this.hasObviousPropertyValue(s, p, o);
            candidates.update(s, hasObviousValue);
        }
    }

    @Override
    public void getObviousSubjects(ATermAppl p, ATermAppl o, CandidateSet<ATermAppl> candidates) {
        Iterator<ATermAppl> i = candidates.iterator();
        while (i.hasNext()) {
            ATermAppl s = i.next();
            Bool hasObviousValue = this.hasObviousPropertyValue(s, p, o);
            if (hasObviousValue.isFalse()) {
                i.remove();
                continue;
            }
            candidates.update(s, hasObviousValue);
        }
    }

    @Override
    public void getObviousObjects(ATermAppl pParam, CandidateSet<ATermAppl> candidates) {
        ATermAppl p = pParam;
        p = this.getRole(p).getInverse().getName();
        Iterator<ATermAppl> i = candidates.iterator();
        while (i.hasNext()) {
            ATermAppl s = i.next();
            Bool hasObviousValue = this.hasObviousObjectPropertyValue(s, p, null);
            candidates.update(s, hasObviousValue);
        }
    }

    @Override
    public Bool isKnownType(ATermAppl x, ATermAppl c) {
        return this.isKnownType(x, c, Collections.emptySet());
    }

    @Override
    public Bool isKnownType(ATermAppl x, ATermAppl c, Collection<ATermAppl> subs) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual pNode = this.getIndividual(x);
        boolean isIndependent = true;
        if (pNode.isMerged()) {
            isIndependent = pNode.getMergeDependency(true).isIndependent();
            pNode = pNode.getSame();
        }
        Bool isType = this.isKnownType(pNode, c, subs);
        if (isIndependent) {
            return isType;
        }
        if (isType.isTrue()) {
            return Bool.UNKNOWN;
        }
        return isType;
    }

    @Override
    public Bool isKnownType(Individual pNode, ATermAppl concept, Collection<ATermAppl> subs) {
        Bool isType = this.isType(pNode, concept);
        if (isType.isUnknown()) {
            Set<ATermAppl> concepts = ATermUtils.isAnd(concept) ? ATermUtils.listToSet((ATermList)concept.getArgument(0)) : SetUtils.singleton(concept);
            isType = Bool.TRUE;
            for (ATermAppl c : concepts) {
                Bool type = pNode.hasObviousType(c);
                if (type.isUnknown() && pNode.hasObviousType(subs)) {
                    type = Bool.TRUE;
                }
                if (type.isKnown()) {
                    isType = isType.and(type);
                    continue;
                }
                isType = Bool.UNKNOWN;
                Collection<ATermAppl> axioms = this._kb.getTBox().getAxioms(c);
                for (ATermAppl axiom : axioms) {
                    ATermAppl term = (ATermAppl)axiom.getArgument(1);
                    boolean equivalent = axiom.getAFun().equals(ATermUtils.EQCLASSFUN);
                    if (!equivalent) continue;
                    Iterator<ATermAppl> i = ATermUtils.isAnd(term) ? new MultiListIterator((ATermList)term.getArgument(0)) : Collections.singleton(term).iterator();
                    Bool knownType = Bool.TRUE;
                    while (i.hasNext() && knownType.isTrue()) {
                        term = i.next();
                        knownType = this.isKnownType(pNode, term, Collections.emptySet());
                    }
                    if (!knownType.isTrue()) continue;
                    isType = Bool.TRUE;
                    break;
                }
                if (!isType.isUnknown()) continue;
                return Bool.UNKNOWN;
            }
        }
        return isType;
    }

    private Bool isType(CachedNode pNode, ATermAppl c) {
        CachedNode cNode;
        ATermAppl notC;
        CachedNode cached;
        Bool isType = Bool.UNKNOWN;
        boolean isPrimitive = this._kb.getTBox().isPrimitive(c);
        if (isPrimitive && !pNode.isTop() && !pNode.isBottom() && pNode.isComplete()) {
            DependencySet ds = pNode.getDepends().get(c);
            if (ds == null) {
                return Bool.FALSE;
            }
            if (ds.isIndependent() && pNode.isIndependent()) {
                return Bool.TRUE;
            }
        }
        if ((cached = this.getCached(notC = ATermUtils.negate(c))) != null && cached.isComplete()) {
            isType = this._cache.isMergable(this._kb, pNode, cached).not();
        }
        if (OpenlletOptions.CHECK_NOMINAL_EDGES && isType.isUnknown() && (cNode = this.getCached(c)) != null) {
            isType = this._cache.checkNominalEdges(this._kb, pNode, cNode);
        }
        return isType;
    }

    @Override
    public boolean isSameAs(ATermAppl ind1, ATermAppl ind2) {
        ATermAppl c = ATermUtils.makeValue(ind2);
        return this.isType(ind1, c);
    }

    @Override
    public boolean isType(ATermAppl x, ATermAppl cParam) {
        ATermAppl c = cParam;
        c = ATermUtils.normalize(c);
        if (!this.doExplanation()) {
            Set<ATermAppl> subs;
            if (this._kb.isClassified() && this._kb.getTaxonomy().contains(c)) {
                subs = this._kb.getTaxonomy().getFlattenedSubs(c, false);
                subs.remove(ATermUtils.BOTTOM);
            } else {
                subs = Collections.emptySet();
            }
            Bool type = this.isKnownType(x, c, subs);
            if (type.isKnown()) {
                return type.isTrue();
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Checking type " + ATermUtils.toString(c) + " for individual " + ATermUtils.toString(x));
        }
        ATermAppl notC = ATermUtils.negate(c);
        Optional<Timer> timer = this._kb.getTimers().startTimer("isType");
        boolean isType = !this.isConsistent(SetUtils.singleton(x), notC, false);
        timer.ifPresent(Timer::stop);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Type " + isType + " " + ATermUtils.toString(c) + " for individual " + ATermUtils.toString(x));
        }
        return isType;
    }

    @Override
    public boolean existType(List<ATermAppl> inds, ATermAppl cParam) {
        ATermAppl c = ATermUtils.normalize(cParam);
        _logger.fine(() -> "Checking type " + ATermUtils.toString(c) + " for individuals " + inds.size());
        ATermAppl notC = ATermUtils.negate(c);
        boolean isType = !this.isConsistent(inds, notC, false);
        _logger.fine(() -> "Type " + isType + " " + ATermUtils.toString(c) + " for individuals " + inds.size());
        return isType;
    }

    @Override
    public Bool hasObviousPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Role prop = this.getRole(p);
        if (prop.isDatatypeRole()) {
            try {
                Object value = o == null ? null : this._dtReasoner.getValue(o);
                return this.hasObviousDataPropertyValue(s, p, value);
            }
            catch (UnrecognizedDatatypeException e) {
                _logger.warning(String.format("Returning false for property value check (%s,%s,%s) due to datatype problem with input literal: %s", s, p, o, e.getMessage()));
                return Bool.FALSE;
            }
            catch (InvalidLiteralException e) {
                _logger.warning(String.format("Returning false for property value check (%s,%s,%s) due to problem with input literal: %s", s, p, o, e.getMessage()));
                return Bool.FALSE;
            }
        }
        return this.hasObviousObjectPropertyValue(s, p, o);
    }

    @Override
    public Bool hasObviousDataPropertyValue(ATermAppl s, ATermAppl p, Object value) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual subj = this.getIndividual(s);
        Role prop = this.getRole(p);
        if (prop.isTop()) {
            return Bool.TRUE;
        }
        if (prop.isBottom()) {
            return Bool.FALSE;
        }
        boolean onlyPositive = false;
        if (!subj.getMergeDependency(true).isIndependent()) {
            onlyPositive = true;
            subj = this.getIndividual(s);
        } else {
            subj = subj.getSame();
        }
        Bool hasValue = subj.hasDataPropertyValue(prop, value);
        if (onlyPositive && hasValue.isFalse()) {
            return Bool.UNKNOWN;
        }
        return hasValue;
    }

    @Override
    public Bool hasObviousObjectPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Role prop = this.getRole(p);
        if (prop.isTop()) {
            return Bool.TRUE;
        }
        if (prop.isBottom()) {
            return Bool.FALSE;
        }
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        this.getObjectPropertyValues(s, prop, knowns, unknowns, true);
        if (o == null) {
            if (!knowns.isEmpty()) {
                return Bool.TRUE;
            }
            if (!unknowns.isEmpty()) {
                return Bool.UNKNOWN;
            }
            return Bool.FALSE;
        }
        if (knowns.contains(o)) {
            return Bool.TRUE;
        }
        if (unknowns.contains(o)) {
            return Bool.UNKNOWN;
        }
        return Bool.FALSE;
    }

    @Override
    public boolean hasPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Bool hasObviousValue = this.hasObviousPropertyValue(s, p, o);
        if (hasObviousValue.isKnown() && (hasObviousValue.isFalse() || !this.doExplanation())) {
            return hasObviousValue.isTrue();
        }
        ATermAppl c = null;
        c = o == null ? (this._kb.isDatatypeProperty(p) ? ATermUtils.makeMin((ATerm)p, 1, (ATerm)ATermUtils.TOP_LIT) : ATermUtils.makeMin((ATerm)p, 1, (ATerm)ATermUtils.TOP)) : ATermUtils.makeHasValue(p, o);
        boolean isType = this.isType(s, c);
        return isType;
    }

    @Override
    public List<ATermAppl> getDataPropertyValues(ATermAppl s, Role role, ATermAppl datatype) {
        return this.getDataPropertyValues(s, role, datatype, false);
    }

    @Override
    public List<ATermAppl> getDataPropertyValues(ATermAppl s, Role role, ATermAppl datatype, boolean onlyObvious) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual subj = this.getIndividual(s);
        ArrayList<ATermAppl> values = new ArrayList<ATermAppl>();
        boolean isIndependent = true;
        if (subj.isMerged()) {
            isIndependent = subj.getMergeDependency(true).isIndependent();
            subj = subj.getSame();
        }
        EdgeList edges = subj.getRSuccessorEdges(role);
        for (int i = 0; i < edges.size(); ++i) {
            ATermAppl hasValue;
            Edge edge = (Edge)edges.get(i);
            DependencySet ds = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            ATermAppl literalValue = literal.getTerm();
            if (literalValue == null) continue;
            if (datatype != null && !literal.hasType(datatype)) {
                try {
                    if (!this._dtReasoner.isSatisfiable(Collections.singleton(datatype), literal.getValue())) {
                        continue;
                    }
                }
                catch (DatatypeReasonerException e) {
                    String msg = String.format("Unexpected datatype reasoner exception while fetching property values (%s,%s,%s): %s", s, role, datatype, e.getMessage());
                    _logger.severe(msg);
                    throw new InternalReasonerException(msg);
                }
            }
            if (isIndependent && ds.isIndependent()) {
                values.add(literalValue);
                continue;
            }
            if (onlyObvious || !this.isType(s, hasValue = ATermUtils.makeHasValue(role.getName(), literalValue))) continue;
            values.add(literalValue);
        }
        return values;
    }

    @Override
    public List<ATermAppl> getObviousDataPropertyValues(ATermAppl s, Role prop, ATermAppl datatype) {
        return this.getDataPropertyValues(s, prop, datatype, true);
    }

    @Override
    public void getObjectPropertyValues(ATermAppl s, Role role, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual subj = this.getIndividual(s);
        boolean isIndependent = true;
        if (subj.isMerged()) {
            isIndependent = subj.getMergeDependency(true).isIndependent();
            subj = subj.getSame();
        }
        if (role.isSimple()) {
            this.getSimpleObjectPropertyValues(subj, role, knowns, unknowns, getSames);
        } else if (!role.hasComplexSubRole()) {
            this.getTransitivePropertyValues(subj, role, knowns, unknowns, getSames, new HashMap<Individual, Set<Role>>(), true);
        } else {
            TransitionGraph<Role> tg = role.getFSM();
            this.getComplexObjectPropertyValues(subj, tg.getInitialState(), tg, knowns, unknowns, getSames, new HashMap<Individual, Set<State<Role>>>(), true);
        }
        if (!isIndependent) {
            unknowns.addAll(knowns);
            knowns.clear();
        }
    }

    @Override
    public void getSimpleObjectPropertyValues(Individual subj, Role role, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames) {
        EdgeList edges = subj.getRNeighborEdges(role);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = (Edge)edges.get(i);
            DependencySet ds = edge.getDepends();
            Individual value = (Individual)edge.getNeighbor(subj);
            if (!value.isRootNominal()) continue;
            if (ds.isIndependent()) {
                if (getSames) {
                    this.getSames(value, knowns, unknowns);
                    continue;
                }
                knowns.add(value.getName());
                continue;
            }
            if (getSames) {
                this.getSames(value, unknowns, unknowns);
                continue;
            }
            unknowns.add(value.getName());
        }
    }

    @Override
    public void getTransitivePropertyValues(Individual subj, Role prop, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames, Map<Individual, Set<Role>> visited, boolean isIndependent) {
        if (!MultiMapUtils.addAll(visited, subj, prop.getSubRoles())) {
            return;
        }
        EdgeList edges = subj.getRNeighborEdges(prop);
        for (int i = 0; i < edges.size(); ++i) {
            Role edgeRole;
            Edge edge = (Edge)edges.get(i);
            DependencySet ds = edge.getDepends();
            Individual value = (Individual)edge.getNeighbor(subj);
            Role role = edgeRole = edge.getFrom().equals(subj) ? edge.getRole() : edge.getRole().getInverse();
            if (value.isRootNominal()) {
                if (isIndependent && ds.isIndependent()) {
                    if (getSames) {
                        this.getSames(value, knowns, unknowns);
                    } else {
                        knowns.add(value.getName());
                    }
                } else if (getSames) {
                    this.getSames(value, unknowns, unknowns);
                } else {
                    unknowns.add(value.getName());
                }
            }
            if (prop.isSimple()) continue;
            Set<Role> transRoles = SetUtils.intersection(edgeRole.getSuperRoles(), prop.getTransitiveSubRoles());
            for (Role transRole : transRoles) {
                this.getTransitivePropertyValues(value, transRole, knowns, unknowns, getSames, visited, isIndependent && ds.isIndependent());
            }
        }
    }

    @Override
    public void getComplexObjectPropertyValues(Individual subj, State<Role> st, TransitionGraph<Role> tg, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames, HashMap<Individual, Set<State<Role>>> visited, boolean isIndependent) {
        if (!MultiMapUtils.add(visited, subj, st)) {
            return;
        }
        if (tg.isFinal(st) && subj.isRootNominal()) {
            _logger.fine("add " + subj);
            if (isIndependent) {
                if (getSames) {
                    this.getSames(subj, knowns, unknowns);
                } else {
                    knowns.add(subj.getName());
                }
            } else if (getSames) {
                this.getSames(subj, unknowns, unknowns);
            } else {
                unknowns.add(subj.getName());
            }
        }
        _logger.fine(subj.toString());
        for (Transition<Role> t : st.getTransitions()) {
            Role r = t.getName();
            EdgeList edges = subj.getRNeighborEdges(r);
            for (int i = 0; i < edges.size(); ++i) {
                Edge edge = (Edge)edges.get(i);
                DependencySet ds = edge.getDepends();
                Individual value = (Individual)edge.getNeighbor(subj);
                this.getComplexObjectPropertyValues(value, t.getTo(), tg, knowns, unknowns, getSames, visited, isIndependent && ds.isIndependent());
            }
        }
    }

    @Override
    public void getSames(Individual ind, Set<ATermAppl> knowns, Set<ATermAppl> unknowns) {
        knowns.add(ind.getName());
        boolean thisMerged = ind.isMerged() && !ind.getMergeDependency(true).isIndependent();
        for (Node other : ind.getMerged()) {
            boolean otherMerged;
            if (!other.isRootNominal()) continue;
            boolean bl = otherMerged = other.isMerged() && !other.getMergeDependency(true).isIndependent();
            if (thisMerged || otherMerged) {
                unknowns.add(other.getName());
                this.getSames((Individual)other, unknowns, unknowns);
                continue;
            }
            knowns.add(other.getName());
            this.getSames((Individual)other, knowns, unknowns);
        }
    }

    @Override
    public boolean isConsistent() {
        boolean isConsistent = false;
        this.checkAssertedClashes();
        isConsistent = this.isConsistent(Collections.emptySet(), null, false);
        if (isConsistent) {
            this._cache.putSat(ATermUtils.BOTTOM, false);
            assert (this.isComplete()) : "ABox not marked complete!";
        }
        return isConsistent;
    }

    private boolean checkAssertedClashes() {
        Iterator<Clash> i = this._assertedClashes.iterator();
        while (i.hasNext()) {
            Clash clash = i.next();
            Node node = clash.getNode();
            ATermAppl term = clash._args != null ? (ATermAppl)clash._args[0] : null;
            boolean resolved = true;
            switch (clash.getClashType()) {
                case ATOMIC: {
                    ATermAppl negation = ATermUtils.negate(term);
                    resolved = !node.hasType(term) || !node.hasType(negation);
                    break;
                }
                case NOMINAL: {
                    resolved = !node.isSame(this.getNode(term));
                    break;
                }
                case INVALID_LITERAL: {
                    resolved = false;
                    break;
                }
                default: {
                    _logger.warning("Unexpected asserted _clash type: " + clash);
                }
            }
            if (resolved) {
                i.remove();
                continue;
            }
            this.setClash(clash);
            return false;
        }
        return true;
    }

    private boolean isConsistent(Collection<ATermAppl> individualsParam, ATermAppl c_, boolean cacheModel) {
        boolean consistent;
        Collection<ATermAppl> individuals = individualsParam;
        ATermAppl c = c_;
        Optional<Timer> timer = this._kb.getTimers().startTimer("isConsistent");
        if (_logger.isLoggable(Level.FINE)) {
            if (c == null) {
                _logger.fine("ABox consistency for " + individuals.size() + " individuals");
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                Iterator<ATermAppl> it = individuals.iterator();
                for (int i = 0; i < 100 && it.hasNext(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ATermUtils.toString(it.next()));
                }
                if (it.hasNext()) {
                    sb.append(", ...");
                }
                sb.append("]");
                _logger.fine("Consistency " + ATermUtils.toString(c) + " for " + individuals.size() + " individuals " + sb);
            }
        }
        Expressivity expr = this._kb.getExpressivityChecker().getExpressivityWith(c);
        boolean initialConsistencyCheck = c == null;
        boolean emptyConsistencyCheck = initialConsistencyCheck && this.isEmpty();
        boolean conceptSatisfiability = individuals.isEmpty() && (!initialConsistencyCheck || emptyConsistencyCheck);
        boolean hasNominal = expr.hasNominal() && !OpenlletOptions.USE_PSEUDO_NOMINALS;
        boolean canUseEmptyABox = conceptSatisfiability && !hasNominal;
        ATermAppl x = null;
        if (conceptSatisfiability) {
            x = ATermUtils.CONCEPT_SAT_IND;
            individuals = SetUtils.singleton(x);
        }
        if (emptyConsistencyCheck) {
            c = ATermUtils.TOP;
        }
        ABoxImpl abox = canUseEmptyABox ? this.copy(x, false) : (initialConsistencyCheck ? this : this.copy(x, true));
        for (ATermAppl ind : individuals) {
            abox.setSyntacticUpdate(true);
            abox.addType(ind, c);
            abox.setSyntacticUpdate(false);
        }
        _logger.fine(() -> "Consistency check starts");
        CompletionStrategy strategy = this._kb.chooseStrategy(abox, expr);
        _logger.fine(() -> "Strategy: " + strategy.getClass().getName());
        this._kb.getTimers().execute("complete", timers -> strategy.complete(expr));
        boolean bl = consistent = !abox.isClosed();
        if (x != null && c != null && cacheModel) {
            this.cache(abox.getIndividual(x), c, consistent);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Consistent: " + consistent + " Time: " + timer.map(t -> t.getElapsed()).orElse(0L) + " Branches " + abox.getBranches().size() + " Tree depth: " + abox.getStats()._treeDepth + " Tree size: " + abox.getNodes().size() + " Restores " + abox.getStats()._globalRestores + " global " + abox.getStats()._localRestores + " local Backtracks " + abox.getStats()._backtracks + " avg backjump " + (double)abox.getStats()._backjumps / (double)abox.getStats()._backtracks);
        }
        if (consistent) {
            if (initialConsistencyCheck && this.isEmpty()) {
                this.setComplete(true);
            }
        } else {
            this._lastClash = abox.getClash();
            _logger.fine(() -> "Clash: " + abox.getClash().detailedString());
            if (this._doExplanation && OpenlletOptions.USE_TRACING) {
                if (individuals.size() == 1) {
                    ATermAppl ind;
                    ind = individuals.iterator().next();
                    ATermAppl tempAxiom = ATermUtils.makeTypeAtom(ind, c);
                    Set<ATermAppl> explanationSet = this.getExplanationSet();
                    boolean removed = explanationSet.remove(tempAxiom);
                    if (!removed && _logger.isLoggable(Level.FINE)) {
                        _logger.fine("Explanation set is missing an axiom.\n\tAxiom: " + tempAxiom + "\n\tExplantionSet: " + explanationSet);
                    }
                }
                if (_logger.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder();
                    for (ATermAppl axiom : this.getExplanationSet()) {
                        sb.append("\n\t");
                        sb.append(ATermUtils.toString(axiom));
                    }
                    _logger.fine("Explanation: " + sb);
                }
            }
        }
        ++this._stats._consistencyCount;
        this._lastCompletion = this._keepLastCompletion ? abox : null;
        timer.ifPresent(Timer::stop);
        return consistent;
    }

    @Override
    public boolean isIncConsistent() {
        boolean consistent;
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Optional<Timer> incT = this._kb.getTimers().startTimer("isIncConsistent");
        Optional<Timer> timer = this._kb.getTimers().startTimer("isConsistent");
        this._lastCompletion = null;
        _logger.fine("Consistency check starts");
        SROIQIncStrategy incStrategy = new SROIQIncStrategy(this);
        _logger.fine("Strategy: " + incStrategy.getClass().getName());
        this.setComplete(false);
        this._kb.getTimers().execute("complete", timers -> incStrategy.complete(this._kb.getExpressivityChecker().getExpressivity()));
        boolean bl = consistent = !this.isClosed();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Consistent: " + consistent + " Tree depth: " + this._stats._treeDepth + " Tree size: " + this.getNodes().size());
        }
        if (!consistent) {
            this._lastClash = this.getClash();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.getClash().detailedString());
            }
        }
        ++this._stats._consistencyCount;
        this._lastCompletion = this;
        timer.ifPresent(t -> t.stop());
        incT.ifPresent(t -> t.stop());
        return consistent;
    }

    @Override
    public EdgeList getInEdges(ATerm x) {
        return this.getNode(x).getInEdges();
    }

    @Override
    public EdgeList getOutEdges(ATerm x) {
        Node node = this.getNode(x);
        if (node instanceof Literal) {
            return new EdgeList();
        }
        return ((Individual)node).getOutEdges();
    }

    @Override
    public Individual getIndividual(ATerm x) {
        Node o = this._nodes.get(x);
        if (o instanceof Individual) {
            return (Individual)o;
        }
        return null;
    }

    @Override
    public Literal getLiteral(ATerm x) {
        Node o = this._nodes.get(x);
        if (o instanceof Literal) {
            return (Literal)o;
        }
        return null;
    }

    @Override
    public Node getNode(ATerm x) {
        return this._nodes.get(x);
    }

    @Override
    public void addType(ATermAppl x, ATermAppl c) {
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTypeAtom(x, c)) : DependencySet.INDEPENDENT;
        this.addType(x, c, ds);
    }

    @Override
    public void addType(ATermAppl x, ATermAppl cParam, DependencySet dsParam) {
        ATermAppl c = cParam;
        DependencySet ds = dsParam;
        c = ATermUtils.normalize(c);
        int remember = this._branchIndex;
        this.setBranchIndex(-1);
        Individual node = this.getIndividual(x);
        node.addType(c, ds, false);
        while (node.isMerged()) {
            ds = ds.union(node.getMergeDependency(false), this._doExplanation);
            node.addType(c, ds, !(node = (Individual)node.getMergedTo()).isMerged());
        }
        this.setBranchIndex(remember);
    }

    @Override
    public Edge addEdge(ATermAppl p, ATermAppl s, ATermAppl o, DependencySet dsParam) {
        DependencySet ds = dsParam;
        Role role = this.getRole(p);
        Individual subj = this.getIndividual(s);
        Node obj = this.getNode(o);
        if (subj.isMerged() && obj.isMerged()) {
            return null;
        }
        if (obj.isMerged()) {
            obj.addInEdge(new DefaultEdge(role, subj, obj, ds));
            ds = ds.union(obj.getMergeDependency(true), true);
            ds = ds.copy(ds.max() + 1);
            obj = obj.getSame();
        }
        DefaultEdge edge = new DefaultEdge(role, subj, obj, ds);
        Edge existingEdge = subj.getOutEdges().getExactEdge(subj, role, obj);
        if (existingEdge == null) {
            subj.addOutEdge(edge);
        } else if (!existingEdge.getDepends().isIndependent()) {
            subj.removeEdge(existingEdge);
            subj.addOutEdge(edge);
        }
        if (subj.isMerged()) {
            ds = ds.union(subj.getMergeDependency(true), true);
            ds = ds.copy(ds.max() + 1);
            subj = subj.getSame();
            edge = new DefaultEdge(role, subj, obj, ds);
            if (subj.getOutEdges().hasEdge(edge)) {
                return null;
            }
            subj.addOutEdge(edge);
            obj.addInEdge(edge);
        } else if (existingEdge == null) {
            obj.addInEdge(edge);
        } else if (!existingEdge.getDepends().isIndependent()) {
            obj.removeInEdge(existingEdge);
            obj.addInEdge(edge);
        }
        return edge;
    }

    @Override
    public boolean removeNode(ATermAppl x) {
        return this._nodes.remove(x) != null;
    }

    @Override
    public void removeType(ATermAppl x, ATermAppl c) {
        this.getNode(x).removeType(ATermUtils.normalize(c));
    }

    @Override
    public Literal addLiteral(DependencySet ds) {
        return this.createLiteral(ATermUtils.makeLiteral(this.createUniqueName(false)), ds);
    }

    @Override
    public Literal addLiteral(ATermAppl dataValue) {
        int remember = this.getBranchIndex();
        this.setBranchIndex(-1);
        Literal lit = this.addLiteral(dataValue, DependencySet.INDEPENDENT);
        this.setBranchIndex(remember);
        return lit;
    }

    @Override
    public Literal addLiteral(ATermAppl dataValue, DependencySet ds) {
        if (dataValue == null || !ATermUtils.isLiteral(dataValue)) {
            throw new InternalReasonerException("Invalid value to create a literal. Value: " + dataValue);
        }
        return this.createLiteral(dataValue, ds);
    }

    private Literal createLiteral(ATermAppl dataValue, DependencySet ds) {
        ATermAppl name;
        if (ATermUtils.NO_DATATYPE.equals(dataValue.getArgument(2))) {
            name = dataValue;
        } else {
            try {
                name = this.getDatatypeReasoner().getCanonicalRepresentation(dataValue);
            }
            catch (InvalidLiteralException e) {
                String msg = String.format("Attempt to create an invalid literal (%s): %s", dataValue, e.getMessage());
                if (OpenlletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    _logger.fine(msg);
                    name = dataValue;
                }
                _logger.severe(msg);
                throw new InternalReasonerException(msg, e);
            }
            catch (UnrecognizedDatatypeException e) {
                String msg = String.format("Attempt to create a literal with an unrecognized datatype (%s): %s", dataValue, e.getMessage());
                _logger.severe(msg);
                throw new InternalReasonerException(msg, e);
            }
        }
        Node node = this.getNode(name);
        if (node != null) {
            if (node instanceof Literal) {
                if (((Literal)node).getValue() == null && OpenlletOptions.USE_COMPLETION_QUEUE) {
                    QueueElement newElement = new QueueElement(node);
                    this._completionQueue.add(newElement, NodeSelector.LITERAL);
                }
                if (this.getBranchIndex() >= 0 && OpenlletOptions.TRACK_BRANCH_EFFECTS) {
                    this._branchEffects.add(this.getBranchIndex(), node.getName());
                }
                return (Literal)node;
            }
            throw new InternalReasonerException("Same term refers to both a literal and an _individual: " + name);
        }
        int remember = this._branchIndex;
        this.setBranchIndex(-1);
        Literal lit = new Literal(name, dataValue, this, ds);
        lit.addType(ATermUtils.TOP_LIT, ds);
        this.setBranchIndex(remember);
        this._nodes.put(name, lit);
        this._nodeList.add(name);
        if (lit.getValue() == null && OpenlletOptions.USE_COMPLETION_QUEUE) {
            QueueElement newElement = new QueueElement(lit);
            this._completionQueue.add(newElement, NodeSelector.LITERAL);
        }
        if (this.getBranchIndex() >= 0 && OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._branchEffects.add(this.getBranchIndex(), lit.getName());
        }
        return lit;
    }

    @Override
    public Individual addIndividual(ATermAppl x, DependencySet ds) {
        Individual ind = this.addIndividual(x, null, ds);
        if (this.getBranchIndex() >= 0 && OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._branchEffects.add(this.getBranchIndex(), ind.getName());
        }
        return ind;
    }

    @Override
    public Individual addFreshIndividual(Individual parent, DependencySet ds) {
        boolean isNominal = parent == null;
        ATermAppl name = this.createUniqueName(isNominal);
        Individual ind = this.addIndividual(name, parent, ds);
        if (isNominal) {
            ind.setNominalLevel(1);
        }
        return ind;
    }

    private Individual addIndividual(ATermAppl x, Individual parent, DependencySet ds) {
        if (this._nodes.containsKey(x)) {
            throw new InternalReasonerException("adding a _node twice " + x);
        }
        this.setChanged(true);
        Individual n = new Individual(x, this, parent);
        this._nodes.put(x, n);
        this._nodeList.add(x);
        if (n.getDepth() > this._stats._treeDepth) {
            this._stats._treeDepth = n.getDepth();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Depth: " + this._stats._treeDepth + " Size: " + this.size());
            }
        }
        n.addType(ATermUtils.TOP, ds);
        if (this.getBranchIndex() > 0 && OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._branchEffects.add(this.getBranchIndex(), n.getName());
        }
        return n;
    }

    @Override
    public void addSame(ATermAppl x, ATermAppl y) {
        Individual ind1 = this.getIndividual(x);
        Individual ind2 = this.getIndividual(y);
        ATermAppl sameAxiom = ATermUtils.makeSameAs(x, y);
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._kb.getSyntacticAssertions().add(sameAxiom);
        }
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(sameAxiom) : DependencySet.INDEPENDENT;
        this.getToBeMerged().add(new NodeMerge(ind1, ind2, ds));
    }

    @Override
    public void addDifferent(ATermAppl x, ATermAppl y) {
        Individual ind1 = this.getIndividual(x);
        Individual ind2 = this.getIndividual(y);
        ATermAppl diffAxiom = ATermUtils.makeDifferent(x, y);
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._kb.getSyntacticAssertions().add(diffAxiom);
        }
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(diffAxiom) : DependencySet.INDEPENDENT;
        int remember = this._branchIndex;
        this.setBranchIndex(-1);
        ind1.setDifferent(ind2, ds);
        this.setBranchIndex(remember);
    }

    @Override
    public void addAllDifferent(ATermList list) {
        ATermAppl allDifferent = ATermUtils.makeAllDifferent(list);
        ATermList outer = list;
        while (!outer.isEmpty()) {
            ATermList inner = outer.getNext();
            while (!inner.isEmpty()) {
                Individual ind1 = this.getIndividual((ATerm)outer.getFirst());
                Individual ind2 = this.getIndividual((ATerm)inner.getFirst());
                if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
                    this._kb.getSyntacticAssertions().add(allDifferent);
                }
                DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(allDifferent) : DependencySet.INDEPENDENT;
                int remember = this._branchIndex;
                this.setBranchIndex(-1);
                ind1.setDifferent(ind2, ds);
                this.setBranchIndex(remember);
                inner = inner.getNext();
            }
            outer = outer.getNext();
        }
    }

    @Override
    public boolean isNode(ATerm x) {
        return this.getNode(x) != null;
    }

    @Override
    public final ATermAppl createUniqueName(boolean isNominal) {
        ++this._anonCount;
        ATermAppl name = isNominal ? ATermUtils.makeAnonNominal(this._anonCount) : ATermUtils.makeAnon(this._anonCount);
        return name;
    }

    @Override
    public final Map<ATermAppl, Node> getNodes() {
        return this._nodes;
    }

    @Override
    public final List<ATermAppl> getNodeNames() {
        return this._nodeList;
    }

    public String toString() {
        return "[size: " + this._nodes.size() + " freeMemory: " + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + "mb]";
    }

    @Override
    public DatatypeReasoner getDatatypeReasoner() {
        return this._dtReasoner;
    }

    @Override
    public boolean isComplete() {
        return this._isComplete;
    }

    @Override
    public void setComplete(boolean isComplete) {
        this._isComplete = isComplete;
    }

    @Override
    public boolean isClosed() {
        return !OpenlletOptions.SATURATE_TABLEAU && this._initialized && this._clash != null;
    }

    @Override
    public Clash getClash() {
        return this._clash;
    }

    @Override
    public void setClash(Clash clash) {
        if (clash != null) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("CLSH: " + clash);
                if (clash.getDepends().max() > this._branchIndex && this._branchIndex != -1) {
                    _logger.severe("Invalid _clash dependency " + clash + " > " + this._branchIndex);
                }
            }
            if (this._branchIndex == -1 && clash.getDepends().getBranch() == -1) {
                this._assertedClashes.add(clash);
            }
            if (this._clash != null) {
                _logger.finer(() -> "Clash was already set \nExisting: " + this._clash + "\nNew     : " + clash);
                if (this._clash.getDepends().max() < clash.getDepends().max()) {
                    return;
                }
            }
        }
        this._clash = clash;
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._kb.getDependencyIndex().setClashDependencies(this._clash);
        }
    }

    @Override
    public KnowledgeBase getKB() {
        return this._kb;
    }

    @Override
    public Role getRole(ATerm r) {
        return this._kb.getRole(r);
    }

    @Override
    public RBox getRBox() {
        return this._kb.getRBox();
    }

    @Override
    public TBox getTBox() {
        return this._kb.getTBox();
    }

    @Override
    public int getBranchIndex() {
        return this._branchIndex;
    }

    @Override
    public void setBranchIndex(int branch) {
        this._branchIndex = branch;
    }

    @Override
    public void incrementBranch() {
        if (OpenlletOptions.USE_COMPLETION_QUEUE) {
            this._completionQueue.incrementBranch(this._branchIndex);
        }
        ++this._branchIndex;
    }

    @Override
    public boolean isInitialized() {
        return this._initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this._initialized = initialized;
    }

    @Override
    public final boolean doExplanation() {
        return this._doExplanation;
    }

    @Override
    public void setDoExplanation(boolean doExplanation) {
        this._doExplanation = doExplanation;
    }

    @Override
    public void setExplanation(DependencySet ds) {
        this._lastClash = Clash.unexplained(null, ds);
    }

    @Override
    public String getExplanation() {
        if (this._lastClash == null) {
            return "No inconsistency was found! There is no clashExplanation generated.";
        }
        return this._lastClash.detailedString();
    }

    @Override
    public Set<ATermAppl> getExplanationSet() {
        if (this._lastClash == null) {
            throw new OpenError("No clashExplanation was generated!");
        }
        return this._lastClash.getDepends().getExplain();
    }

    @Override
    public BranchEffectTracker getBranchEffectTracker() {
        if (this._branchEffects == null) {
            throw new NullPointerException();
        }
        return this._branchEffects;
    }

    @Override
    public List<Branch> getBranches() {
        return this._branches;
    }

    @Override
    public IncrementalChangeTracker getIncrementalChangeTracker() {
        if (this._incChangeTracker == null) {
            throw new NullPointerException();
        }
        return this._incChangeTracker;
    }

    @Override
    public IndividualIterator getIndIterator() {
        return new IndividualIterator(this);
    }

    @Override
    public void validate() {
        if (!OpenlletOptions.VALIDATE_ABOX) {
            return;
        }
        System.out.print("VALIDATING...");
        IndividualIterator n = this.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            if (node.isPruned()) continue;
            this.validate(node);
        }
    }

    @Override
    public void validateTypes(Individual node, List<ATermAppl> negatedTypes) {
        int n = negatedTypes.size();
        for (int i = 0; i < n; ++i) {
            ATermAppl notA;
            ATermAppl a = negatedTypes.get(i);
            if (a.getArity() == 0 || !node.hasType(notA = (ATermAppl)a.getArgument(0))) continue;
            if (!node.hasType(a)) {
                throw new InternalReasonerException("Invalid type found: " + node + "  " + a + " " + node.debugString() + " " + node._depends);
            }
            throw new InternalReasonerException("Clash found: " + node + " " + a + " " + node.debugString() + " " + node._depends);
        }
    }

    @Override
    public void validate(Individual node) {
        Edge edge;
        int e;
        DependencySet ds;
        this.validateTypes(node, node.getTypes(0));
        this.validateTypes(node, node.getTypes(2));
        this.validateTypes(node, node.getTypes(1));
        this.validateTypes(node, node.getTypes(5));
        if (!node.isRoot()) {
            boolean validPred;
            EdgeList preds = node.getInEdges();
            boolean bl = validPred = preds.size() == 1 || preds.size() == 2 && preds.hasEdgeFrom(node);
            if (!validPred) {
                throw new InternalReasonerException("Invalid blockable node: " + node + " " + node.getInEdges());
            }
        } else if (node.isNominal()) {
            Iterator<Node> nominal = ATermUtils.makeValue(node.getName());
            if (!ATermUtils.isAnonNominal(node.getName()) && !node.hasType((ATerm)((Object)nominal))) {
                throw new InternalReasonerException("Invalid nominal node: " + node + " " + node.getTypes());
            }
        }
        for (ATermAppl c : node.getDepends().keySet()) {
            ds = node.getDepends(c);
            if (ds.max() <= this._branchIndex && (OpenlletOptions.USE_SMART_RESTORE || ds.getBranch() <= this._branchIndex)) continue;
            throw new InternalReasonerException("Invalid ds found: " + node + " " + c + " " + ds + " " + this._branchIndex);
        }
        for (Node ind : node.getDifferents()) {
            ds = node.getDifferenceDependency(ind);
            if (ds.max() > this._branchIndex || ds.getBranch() > this._branchIndex) {
                throw new InternalReasonerException("Invalid ds: " + node + " != " + ind + " " + ds);
            }
            if (ind.getDifferenceDependency(node) != null) continue;
            throw new InternalReasonerException("Invalid difference: " + node + " != " + ind + " " + ds);
        }
        EdgeList edges = node.getOutEdges();
        for (e = 0; e < edges.size(); ++e) {
            edge = (Edge)edges.get(e);
            Node succ = edge.getTo();
            if (this._nodes.get(succ.getName()) != succ) {
                throw new InternalReasonerException("Invalid edge to a non-existing node: " + edge + " " + this._nodes.get(succ.getName()) + "(" + this._nodes.get(succ.getName()).hashCode() + ")" + succ + "(" + succ.hashCode() + ")");
            }
            if (!succ.getInEdges().hasEdge(edge)) {
                throw new InternalReasonerException("Invalid edge: " + edge);
            }
            if (succ.isMerged()) {
                throw new InternalReasonerException("Invalid edge to a removed node: " + edge + " " + succ.isMerged());
            }
            DependencySet ds2 = edge.getDepends();
            if (ds2.max() > this._branchIndex || ds2.getBranch() > this._branchIndex) {
                throw new InternalReasonerException("Invalid ds: " + edge + " " + ds2);
            }
            EdgeList allEdges = node.getEdgesTo(succ);
            if (allEdges.getRoles().size() == allEdges.size()) continue;
            throw new InternalReasonerException("Duplicate edges: " + allEdges);
        }
        edges = node.getInEdges();
        for (e = 0; e < edges.size(); ++e) {
            edge = (Edge)edges.get(e);
            DependencySet ds3 = edge.getDepends();
            if (ds3.max() <= this._branchIndex && ds3.getBranch() <= this._branchIndex) continue;
            throw new InternalReasonerException("Invalid ds: " + edge + " " + ds3);
        }
    }

    @Override
    public void printTree(PrintStream stream) {
        if (!OpenlletOptions.PRINT_ABOX) {
            return;
        }
        stream.println("PRINTING... " + DependencySet.INDEPENDENT);
        for (Node node : this._nodes.values()) {
            if (!node.isRoot() || node instanceof Literal) continue;
            this.printNode(stream, (Individual)node, new HashSet<Individual>(), "   ");
        }
    }

    private void printNode(PrintStream stream, Individual node, Set<Individual> printed, String indentLvl) {
        boolean printOnlyName = node.isNominal() && !printed.isEmpty();
        stream.print(node);
        if (!printed.add(node)) {
            stream.println();
            return;
        }
        if (node.isMerged()) {
            stream.println(" -> " + node.getMergedTo() + " " + node.getMergeDependency(false));
            return;
        }
        if (node.isPruned()) {
            throw new InternalReasonerException("Pruned node: " + node);
        }
        stream.print(" = ");
        for (int i = 0; i < 7; ++i) {
            for (ATermAppl c : node.getTypes(i)) {
                stream.print(ATermUtils.toString(c));
                stream.print(", ");
            }
        }
        stream.println(node.getDifferents());
        if (printOnlyName) {
            return;
        }
        String indent = indentLvl + "  ";
        for (Edge edge : node.getOutEdges()) {
            Node succ = edge.getTo();
            EdgeList edges = node.getEdgesTo(succ);
            stream.print(indent + "[");
            for (int e = 0; e < edges.size(); ++e) {
                if (e > 0) {
                    stream.print(", ");
                }
                stream.print(((Edge)edges.get(e)).getRole());
            }
            stream.print("] ");
            if (succ instanceof Individual) {
                this.printNode(stream, (Individual)succ, printed, indent);
                continue;
            }
            stream.println(" (Literal) " + ATermUtils.toString(succ.getName()) + " " + ATermUtils.toString(succ.getTypes()));
        }
    }

    @Override
    public Clash getLastClash() {
        return this._lastClash;
    }

    @Override
    public ABox getLastCompletion() {
        return this._lastCompletion;
    }

    @Override
    public boolean isKeepLastCompletion() {
        return this._keepLastCompletion;
    }

    @Override
    public void setKeepLastCompletion(boolean keepLastCompletion) {
        this._keepLastCompletion = keepLastCompletion;
    }

    @Override
    public int size() {
        return this._nodes.size();
    }

    @Override
    public boolean isEmpty() {
        return this._nodes.isEmpty();
    }

    @Override
    public void setLastCompletion(ABox comp) {
        this._lastCompletion = comp;
    }

    @Override
    public void setSyntacticUpdate(boolean val) {
        this._syntacticUpdate = val;
    }

    @Override
    public boolean isSyntacticUpdate() {
        return this._syntacticUpdate;
    }

    @Override
    public CompletionQueue getCompletionQueue() {
        return this._completionQueue;
    }

    @Override
    public void reset() {
        if (!this.isComplete()) {
            return;
        }
        this.setComplete(false);
        Iterator<ATermAppl> i = this._nodeList.iterator();
        while (i.hasNext()) {
            ATermAppl nodeName = i.next();
            Node node = this._nodes.get(nodeName);
            if (!node.isRootNominal()) {
                i.remove();
                this._nodes.remove(nodeName);
                continue;
            }
            node.reset(false);
        }
        this.setComplete(false);
        this.setInitialized(false);
        this.setClash(null);
        this.setBranchIndex(-1);
        this._branches.clear();
        this._disjBranchStats.clear();
        this._rulesNotApplied = true;
    }

    @Override
    public void resetQueue() {
        for (Node node : this._nodes.values()) {
            node.reset(true);
        }
    }

    @Override
    public int setAnonCount(int anonCount) {
        this._anonCount = anonCount;
        return this._anonCount;
    }

    @Override
    public int getAnonCount() {
        return this._anonCount;
    }

    @Override
    public Map<ATermAppl, int[]> getDisjBranchStats() {
        return this._disjBranchStats;
    }

    @Override
    public void setChanged(boolean changed) {
        this._changed = changed;
    }

    @Override
    public boolean isChanged() {
        return this._changed;
    }

    @Override
    public List<NodeMerge> getToBeMerged() {
        return this._toBeMerged;
    }
}

