/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.abox;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.tableau.completion.queue.NodeSelector;

public class IndividualIterator
implements Iterator<Individual> {
    protected volatile ABox _abox;
    private final List<ATermAppl> _nodeList;
    private int _index = 0;
    private final int _stop;

    public IndividualIterator(ABox abox) {
        this._abox = abox;
        this._nodeList = abox.getNodeNames();
        this._stop = this._nodeList.size();
        this.findNext();
    }

    private void findNext() {
        Node node;
        while (this._index < this._stop && ((node = this._abox.getNode(this._nodeList.get(this._index))).isPruned() || !node.isIndividual())) {
            ++this._index;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this._index < this._stop;
    }

    public void reset(NodeSelector s) {
        this._index = 0;
        this.findNext();
    }

    @Override
    public Individual next() {
        this.findNext();
        return this._abox.getIndividual(this._nodeList.get(this._index++));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Stream<Individual> nodes() {
        return new ArrayList<ATermAppl>(this._nodeList).parallelStream().filter(term -> {
            Node node = this._abox.getNode((ATerm)term);
            return !node.isPruned() && node.isIndividual();
        }).map(this._abox::getIndividual);
    }

    public int size() {
        return this._nodeList.size();
    }
}

