/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.tbox.impl;

import java.util.Map;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.tbox.impl.TBoxExpImpl;
import openllet.core.boxes.tbox.impl.TermDefinition;
import openllet.core.utils.CollectionUtils;
import openllet.shared.tools.Log;
import openllet.shared.tools.Logging;

public class TBoxBase
implements Logging {
    public static Logger _logger = Log.getLogger(TBoxBase.class);
    protected final KnowledgeBase _kb;
    protected final TBoxExpImpl _tbox;
    protected Map<ATermAppl, TermDefinition> _termhash = CollectionUtils.makeIdentityMap();

    public TBoxBase(TBoxExpImpl tbox) {
        this._tbox = tbox;
        this._kb = tbox.getKB();
    }

    @Override
    public Logger getLogger() {
        return _logger;
    }

    public boolean addDef(ATermAppl def) {
        ATermAppl name = (ATermAppl)def.getArgument(0);
        if (this._termhash.containsKey(name)) {
            this.getTD(name).addDef(def);
        } else {
            TermDefinition td = new TermDefinition();
            td.addDef(def);
            this._termhash.put(name, td);
        }
        return true;
    }

    public boolean removeDef(ATermAppl axiom) {
        boolean removed = false;
        ATermAppl name = (ATermAppl)axiom.getArgument(0);
        TermDefinition td = this.getTD(name);
        if (td != null) {
            removed = td.removeDef(axiom);
        }
        return removed;
    }

    public TermDefinition getTD(ATerm name) {
        return this._termhash.get(name);
    }

    public boolean isEmpty() {
        return this._termhash.size() == 0;
    }

    public int size() {
        return this._termhash.size();
    }
}

