/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.utils.ATermUtils;

public abstract class AbstractBaseDatatype<T>
implements Datatype<T> {
    private final int _hashCode;
    private final ATermAppl _name;

    protected AbstractBaseDatatype(ATermAppl name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.getArity() != 0) {
            throw new IllegalArgumentException();
        }
        this._name = name;
        this._hashCode = name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    protected static String getLexicalForm(ATermAppl input) {
        if (!ATermUtils.isLiteral(input)) {
            throw new IllegalArgumentException();
        }
        return ATermUtils.getLiteralValue(input);
    }

    @Override
    public ATermAppl getName() {
        return this._name;
    }

    public int hashCode() {
        return this._hashCode;
    }
}

