/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import openllet.core.datatypes.DataRange;

public class DataValueEnumeration<T>
implements DataRange<T> {
    private final Set<T> _values;
    private final int _size;

    public DataValueEnumeration(Collection<? extends T> values) {
        if (values == null) {
            throw new NullPointerException();
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this._values = Collections.unmodifiableSet(new LinkedHashSet<T>(values));
        this._size = this._values.size();
    }

    @Override
    public boolean contains(Object value) {
        return this._values.contains(value);
    }

    @Override
    public boolean containsAtLeast(int n) {
        return this._size >= n;
    }

    @Override
    @Deprecated
    public T getValue(int i) {
        if (i >= this._size) {
            throw new NoSuchElementException();
        }
        Iterator<T> it = this._values.iterator();
        for (int j = 0; j < i; ++j) {
            it.next();
        }
        return it.next();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    @Deprecated
    public int size() {
        return this._size;
    }

    @Override
    public Iterator<T> valueIterator() {
        return this._values.iterator();
    }

    public String toString() {
        return String.format("OneOf%s", this._values);
    }
}

