/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import openllet.core.datatypes.FloatingPointType;
import openllet.shared.tools.Log;

public class FloatingPointInterval<T extends Number> {
    private static final Logger _logger = Log.getLogger(FloatingPointInterval.class);
    private final T _lower;
    private final FloatingPointType<T> _type;
    private final T _upper;

    public static <U extends Number> FloatingPointInterval<U> unconstrained(FloatingPointType<U> type) {
        return new FloatingPointInterval<U>(type, type.getNegativeInfinity(), type.getPositiveInfinity());
    }

    public FloatingPointInterval(FloatingPointType<T> type, T point) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (point == null) {
            throw new NullPointerException();
        }
        if (type.isNaN(point)) {
            throw new IllegalArgumentException();
        }
        this._type = type;
        this._lower = point;
        this._upper = point;
    }

    public FloatingPointInterval(FloatingPointType<T> type, T lower, T upper) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (lower == null) {
            throw new NullPointerException();
        }
        if (upper == null) {
            throw new NullPointerException();
        }
        if (type.isNaN(lower)) {
            throw new IllegalArgumentException();
        }
        if (type.isNaN(upper)) {
            throw new IllegalArgumentException();
        }
        int cmp = ((Comparable)lower).compareTo(upper);
        if (cmp > 0) {
            String msg = String.format("Lower bound of interval (%s) should not be greater than _upper bound of interval (%s)", lower, upper);
            _logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this._type = type;
        this._lower = lower;
        this._upper = upper;
    }

    public boolean canUnionWith(FloatingPointInterval<T> other) {
        int ll = ((Comparable)this._lower).compareTo(other._lower);
        int uu = ((Comparable)this._upper).compareTo(other._upper);
        if (ll <= 0) {
            if (uu < 0) {
                if (((Comparable)this._upper).compareTo(other._lower) < 0) {
                    return this._type.increment(this._upper).equals(other._lower);
                }
                return true;
            }
            return true;
        }
        if (uu > 0) {
            if (((Comparable)this._lower).compareTo(other._upper) > 0) {
                return this._type.increment(other._upper).equals(this._lower);
            }
            return true;
        }
        return true;
    }

    public boolean contains(T n) {
        if (this._type.isNaN(n)) {
            return false;
        }
        int lcmp = ((Comparable)this.getLower()).compareTo(n);
        if (lcmp > 0) {
            return false;
        }
        if (lcmp == 0) {
            return true;
        }
        int ucmp = ((Comparable)this.getUpper()).compareTo(n);
        return ucmp >= 0;
    }

    private FloatingPointInterval<T> create(T lower, T upper) {
        return new FloatingPointInterval<T>(this._type, lower, upper);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatingPointInterval other = (FloatingPointInterval)obj;
        if (!this._lower.equals(other._lower)) {
            return false;
        }
        return this._upper.equals(other._upper);
    }

    public T getLower() {
        return this._lower;
    }

    public T getUpper() {
        return this._upper;
    }

    public FloatingPointInterval<T> greater(T n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (this._type.isNaN(n)) {
            throw new IllegalArgumentException();
        }
        if (((Comparable)this.getLower()).compareTo(n) >= 0) {
            return this;
        }
        if (((Comparable)this.getUpper()).compareTo(n) <= 0) {
            return null;
        }
        return this.create(this._type.increment(n), this.getUpper());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        result = 31 * result + (this._lower == null ? 0 : this._lower.hashCode());
        result = 31 * result + (this._upper == null ? 0 : this._upper.hashCode());
        return result;
    }

    public FloatingPointInterval<T> intersection(FloatingPointInterval<T> that) {
        int ll = ((Comparable)this._lower).compareTo(that._lower);
        int uu = ((Comparable)this._upper).compareTo(that._upper);
        if (ll <= 0) {
            if (uu < 0) {
                if (((Comparable)this._upper).compareTo(that._lower) < 0) {
                    return null;
                }
                return this.create(that._lower, this._upper);
            }
            return that;
        }
        if (uu > 0) {
            if (((Comparable)this._lower).compareTo(that._upper) > 0) {
                return null;
            }
            return this.create(this._lower, that._upper);
        }
        return this;
    }

    public FloatingPointInterval<T> less(T n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (this._type.isNaN(n)) {
            throw new IllegalArgumentException();
        }
        if (((Comparable)this.getUpper()).compareTo(n) <= 0) {
            return this;
        }
        if (((Comparable)this.getLower()).compareTo(n) >= 0) {
            return null;
        }
        return this.create(this.getLower(), this._type.decrement(n));
    }

    public List<FloatingPointInterval<T>> remove(FloatingPointInterval<T> other) {
        Object after;
        FloatingPointInterval<T> before;
        int ll = ((Comparable)this._lower).compareTo(other._lower);
        int lu = ((Comparable)this._lower).compareTo(other._upper);
        int ul = ((Comparable)this._upper).compareTo(other._lower);
        int uu = ((Comparable)this._upper).compareTo(other._upper);
        if (ll < 0) {
            if (ul < 0) {
                before = this;
                after = null;
            } else {
                T f = this._type.decrement(other._lower);
                before = f.equals(this._type.getNegativeInfinity()) ? null : this.create(this._lower, f);
                after = uu <= 0 ? null : ((f = this._type.increment(other._upper)).equals(this._type.getPositiveInfinity()) ? null : super.create(this._type.increment(other._upper), this._upper));
            }
        } else if (lu > 0) {
            before = null;
            after = this;
        } else if (uu <= 0) {
            before = null;
            after = null;
        } else {
            before = null;
            T f = this._type.increment(other._upper);
            after = f.equals(this._type.getPositiveInfinity()) ? super.create(this._type.increment(other._upper), this._upper) : null;
        }
        if (before == null) {
            if (after == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(after);
        }
        if (after == null) {
            return Collections.singletonList(before);
        }
        return Arrays.asList(before, after);
    }

    public Number size() {
        return this._type.intervalSize(this._lower, this._upper);
    }

    public List<FloatingPointInterval<T>> union(FloatingPointInterval<T> other) {
        FloatingPointInterval<T> second;
        FloatingPointInterval<T> first;
        int ll = ((Comparable)this._lower).compareTo(other._lower);
        int lu = ((Comparable)this._lower).compareTo(other._upper);
        int ul = ((Comparable)this._upper).compareTo(other._lower);
        int uu = ((Comparable)this._upper).compareTo(other._upper);
        if (ll < 0) {
            if (ul < 0) {
                first = this;
                second = other;
            } else {
                second = null;
                first = uu < 0 ? super.create(this._lower, other._upper) : this;
            }
        } else if (lu > 0) {
            first = other;
            second = this;
        } else {
            second = null;
            first = uu <= 0 ? other : super.create(other._lower, this._upper);
        }
        if (first == null) {
            if (second == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(second);
        }
        if (second == null) {
            return Collections.singletonList(first);
        }
        return Arrays.asList(first, second);
    }

    public Iterator<T> valueIterator() {
        return new ValueIterator(this, this._lower, this._upper);
    }

    public static class ValueIterator
    implements Iterator<T> {
        private final T _last;
        private T _next;
        final /* synthetic */ FloatingPointInterval this$0;

        public ValueIterator(T lower, T upper) {
            this.this$0 = this$0;
            if (lower == null) {
                throw new NullPointerException();
            }
            if (upper == null) {
                throw new NullPointerException();
            }
            this._next = lower;
            this._last = upper;
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public T next() {
            Object ret = this._next;
            this._next = this._next.equals(this._last) ? null : this.this$0._type.increment(this._next);
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

