/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.OWLRealInterval;
import openllet.core.datatypes.OWLRealUtils;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.RestrictedRealDatatype;
import openllet.core.datatypes.XSDDecimal;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.utils.ATermUtils;
import openllet.shared.tools.Log;

public class XSDLong
implements Datatype<Number> {
    private static final XSDLong instance = new XSDLong();
    private static final Logger _logger = Log.getLogger(XSDLong.class);
    private final RestrictedDatatype<Number> dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#long");

    public static XSDLong getInstance() {
        return instance;
    }

    private XSDLong() {
        this.hashCode = this.name.hashCode();
        OWLRealInterval i = new OWLRealInterval(Long.MIN_VALUE, Long.MAX_VALUE, true, true, OWLRealInterval.LineType.INTEGER_ONLY);
        this.dataRange = new RestrictedRealDatatype(this, i);
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(input)) {
            throw new IllegalArgumentException();
        }
        if (!input.getArgument(2).equals(this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(input);
        try {
            DatatypeConverter.parseLong((String)lexicalForm);
        }
        catch (NumberFormatException e) {
            _logger.severe(String.format("Number format exception (%s) cause while parsing long %s", e.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
        return XSDDecimal.getInstance().getCanonicalRepresentation(ATermUtils.makeTypedLiteral(lexicalForm, XSDDecimal.getInstance().getName()));
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return XSDDecimal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(literal)) {
            throw new IllegalArgumentException();
        }
        if (!literal.getArgument(2).equals(this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(literal);
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseLong((String)lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.name, lexicalForm, e);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

