/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.duration;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.Facet;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidConstrainingFacetException;
import openllet.shared.tools.Log;

public class RestrictedDurationDatatype
implements RestrictedDatatype<Duration> {
    private static final Logger _logger = Log.getLogger(RestrictedDurationDatatype.class);
    private final Datatype<Duration> _dt;
    protected final Predicate<Duration> _check;

    public RestrictedDurationDatatype(Datatype<Duration> dt, Predicate<Duration> check) {
        this._dt = dt;
        this._check = check;
    }

    public RestrictedDurationDatatype(Datatype<Duration> dt) {
        this(dt, x -> true);
    }

    @Override
    public RestrictedDatatype<Duration> applyConstrainingFacet(ATermAppl facet, Object value) throws InvalidConstrainingFacetException {
        if (!(value instanceof Duration)) {
            String msg = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), facet, value);
            _logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        Facet f = Facet.Registry.get(facet);
        if (f == null) {
            String msg = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), facet, value);
            _logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        Facet.XSD xsd = (Facet.XSD)f;
        Duration duration = (Duration)value;
        switch (xsd) {
            case LENGTH: 
            case MAX_LENGTH: 
            case MAX_EXCLUSIVE: {
                return new RestrictedDurationDatatype(this._dt, anotherDuration -> duration.compare((Duration)anotherDuration) > 0);
            }
            case MAX_INCLUSIVE: {
                return new RestrictedDurationDatatype(this._dt, anotherDuration -> duration.compare((Duration)anotherDuration) >= 0);
            }
            case MIN_LENGTH: 
            case MIN_EXCLUSIVE: {
                return new RestrictedDurationDatatype(this._dt, anotherDuration -> duration.compare((Duration)anotherDuration) < 0);
            }
            case MIN_INCLUSIVE: {
                return new RestrictedDurationDatatype(this._dt, anotherDuration -> duration.compare((Duration)anotherDuration) <= 0);
            }
            case PATTERN: {
                _logger.severe("Duration as regexp pattern will come in future developpement.");
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object duration) {
        if (!(duration instanceof Duration)) {
            return false;
        }
        return this._check.test((Duration)duration);
    }

    @Override
    public boolean containsAtLeast(int n) {
        return true;
    }

    @Override
    public RestrictedDatatype<Duration> exclude(Collection<?> values) {
        return new RestrictedDurationDatatype(this._dt, this._check.and(duration -> !values.contains(duration)));
    }

    @Override
    public RestrictedDatatype<Duration> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedDurationDatatype) {
            return new RestrictedDurationDatatype(this._dt, this._check.and(((RestrictedDurationDatatype)other)._check));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public RestrictedDatatype<Duration> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedDurationDatatype) {
            return new RestrictedDurationDatatype(this._dt, this._check.or(((RestrictedDurationDatatype)other)._check));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<? extends Duration> getDatatype() {
        return this._dt;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public Iterator<Duration> valueIterator() {
        throw new IllegalStateException();
    }
}

