/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.ContinuousRealInterval;
import openllet.core.datatypes.types.real.IntegerInterval;
import openllet.core.datatypes.types.real.OWLRational;
import openllet.core.datatypes.types.real.Rational;
import openllet.core.datatypes.types.real.RestrictedRealDatatype;
import openllet.core.datatypes.types.real.XSDDecimal;
import openllet.core.utils.ATermUtils;

public class OWLReal
extends AbstractBaseDatatype<Number> {
    private static final OWLReal instance = new OWLReal();
    private final RestrictedRealDatatype dataRange = new RestrictedRealDatatype(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());

    public static OWLReal getInstance() {
        return instance;
    }

    private OWLReal() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#real"));
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        String lexicalForm = OWLReal.getLexicalForm(input);
        throw new InvalidLiteralException(this.getName(), lexicalForm);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof Rational) {
            return OWLRational.getInstance().getLiteral(value);
        }
        if (value instanceof Number) {
            try {
                return XSDDecimal.getInstance().getLiteral(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = OWLReal.getLexicalForm(literal);
        throw new InvalidLiteralException(this.getName(), lexicalForm);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

