/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.DiscreteInterval;
import openllet.core.datatypes.EmptyRestrictedDatatype;
import openllet.core.datatypes.Facet;
import openllet.core.datatypes.OWLRealUtils;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.types.real.ContinuousRealInterval;
import openllet.core.datatypes.types.real.IntegerInterval;
import openllet.shared.tools.Log;

public class RestrictedRealDatatype
implements RestrictedDatatype<Number> {
    private static final Logger _logger = Log.getLogger(RestrictedRealDatatype.class);
    private final Datatype<? extends Number> _datatype;
    private final RestrictedDatatype<Number> _empty;
    private final boolean _enumerable;
    private final boolean _finite;
    private final List<IntegerInterval> _intIntervals;
    private final List<ContinuousRealInterval> _decimalIntervals;
    private final List<ContinuousRealInterval> _rationalIntervals;

    public RestrictedRealDatatype(Datatype<? extends Number> datatype, IntegerInterval ints, ContinuousRealInterval decimals, ContinuousRealInterval rationals) {
        this._datatype = datatype;
        this._empty = new EmptyRestrictedDatatype<Number>(datatype);
        this._intIntervals = ints == null ? Collections.emptyList() : Collections.singletonList(ints);
        this._decimalIntervals = decimals == null ? Collections.emptyList() : Collections.singletonList(decimals);
        this._rationalIntervals = rationals == null ? Collections.emptyList() : Collections.singletonList(rationals);
        this._finite = !(ints != null && !ints.isFinite() || decimals != null && !decimals.isPoint() || rationals != null && !rationals.isPoint());
        this._enumerable = this._finite || decimals == null && rationals == null;
    }

    private RestrictedRealDatatype(RestrictedRealDatatype other, List<IntegerInterval> intIntervals, List<ContinuousRealInterval> decimalIntervals, List<ContinuousRealInterval> rationalIntervals) {
        this._datatype = other._datatype;
        this._empty = other._empty;
        this._intIntervals = intIntervals;
        this._decimalIntervals = decimalIntervals;
        this._rationalIntervals = rationalIntervals;
        if (other._enumerable) {
            this._enumerable = true;
        } else {
            boolean allEnumerable = true;
            block0: for (List l : new List[]{decimalIntervals, rationalIntervals}) {
                if (!allEnumerable) continue;
                Iterator iterator = l.iterator();
                while (iterator.hasNext()) {
                    ContinuousRealInterval i = (ContinuousRealInterval)iterator.next();
                    if (i.isPoint()) continue;
                    allEnumerable = false;
                    continue block0;
                }
            }
            this._enumerable = allEnumerable;
        }
        if (other._finite) {
            this._finite = true;
        } else if (this._enumerable) {
            boolean allFinite = true;
            for (IntegerInterval i : intIntervals) {
                if (i.isFinite()) continue;
                allFinite = false;
                break;
            }
            this._finite = allFinite;
        } else {
            this._finite = false;
        }
    }

    @Override
    public RestrictedDatatype<Number> applyConstrainingFacet(ATermAppl facet, Object value) {
        boolean inclusiveUpper;
        Number upper;
        boolean inclusiveLower;
        Number lower;
        Facet f = Facet.Registry.get(facet);
        if (f == null) {
            String msg = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), facet, value);
            _logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        Number n = null;
        if (value instanceof Number && !OWLRealUtils.acceptable((n = (Number)value).getClass())) {
            n = null;
        }
        if (n == null) {
            String msg = String.format("Attempt to constrain datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), f, value);
            _logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (Facet.XSD.MAX_EXCLUSIVE.equals(f)) {
            lower = null;
            inclusiveLower = false;
            upper = n;
            inclusiveUpper = false;
        } else if (Facet.XSD.MAX_INCLUSIVE.equals(f)) {
            lower = null;
            inclusiveLower = false;
            upper = n;
            inclusiveUpper = true;
        } else if (Facet.XSD.MIN_EXCLUSIVE.equals(f)) {
            lower = n;
            inclusiveLower = false;
            upper = null;
            inclusiveUpper = false;
        } else if (Facet.XSD.MIN_INCLUSIVE.equals(f)) {
            lower = n;
            inclusiveLower = true;
            upper = null;
            inclusiveUpper = false;
        } else {
            throw new IllegalStateException();
        }
        ContinuousRealInterval continuousRestriction = new ContinuousRealInterval(lower, upper, inclusiveLower, inclusiveUpper);
        IntegerInterval integerRestriction = RestrictedRealDatatype.asIntegerInterval(continuousRestriction);
        boolean changes = false;
        ArrayList<IntegerInterval> revisedInts = new ArrayList<IntegerInterval>();
        for (IntegerInterval integerInterval : this._intIntervals) {
            IntegerInterval j = integerInterval.intersection(integerRestriction);
            if (j != null) {
                revisedInts.add(j);
                if (integerInterval.equals(j)) continue;
                changes = true;
                continue;
            }
            changes = true;
        }
        ArrayList<ContinuousRealInterval> revisedDecimals = new ArrayList<ContinuousRealInterval>();
        for (ContinuousRealInterval i : this._decimalIntervals) {
            ContinuousRealInterval j = i.intersection(continuousRestriction);
            if (j != null) {
                revisedDecimals.add(j);
                if (i.equals(j)) continue;
                changes = true;
                continue;
            }
            changes = true;
        }
        ArrayList<ContinuousRealInterval> arrayList = new ArrayList<ContinuousRealInterval>();
        for (ContinuousRealInterval i : this._rationalIntervals) {
            ContinuousRealInterval j = i.intersection(continuousRestriction);
            if (j != null) {
                arrayList.add(j);
                if (i.equals(j)) continue;
                changes = true;
                continue;
            }
            changes = true;
        }
        if (changes) {
            if (revisedInts.isEmpty() && revisedDecimals.isEmpty() && arrayList.isEmpty()) {
                return this._empty;
            }
            return new RestrictedRealDatatype(this, revisedInts, revisedDecimals, arrayList);
        }
        return this;
    }

    private static IntegerInterval asIntegerInterval(ContinuousRealInterval continuousRestriction) {
        Number cu;
        Number cl;
        Number lower = continuousRestriction.boundLower() ? (Number)(OWLRealUtils.isInteger(cl = continuousRestriction.getLower()) ? (Number)(continuousRestriction.inclusiveLower() ? (Number)cl : (Number)OWLRealUtils.integerIncrement(cl)) : (Number)OWLRealUtils.roundCeiling(cl)) : (Number)null;
        Number upper = continuousRestriction.boundUpper() ? (Number)(OWLRealUtils.isInteger(cu = continuousRestriction.getUpper()) ? (Number)(continuousRestriction.inclusiveUpper() ? (Number)cu : (Number)OWLRealUtils.integerDecrement(cu)) : (Number)OWLRealUtils.roundFloor(cu)) : (Number)null;
        if (lower != null && upper != null && OWLRealUtils.compare(lower, upper) > 0) {
            return null;
        }
        return new IntegerInterval(lower, upper);
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            if (OWLRealUtils.acceptable(n.getClass())) {
                if (OWLRealUtils.isInteger(n)) {
                    for (IntegerInterval i : this._intIntervals) {
                        if (!i.contains(n)) continue;
                        return true;
                    }
                } else if (OWLRealUtils.isDecimal(n)) {
                    for (ContinuousRealInterval i : this._decimalIntervals) {
                        if (!i.contains(n)) continue;
                        return true;
                    }
                } else if (OWLRealUtils.isRational(n)) {
                    for (ContinuousRealInterval i : this._rationalIntervals) {
                        if (!i.contains(n)) continue;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (!this._finite || n <= 0) {
            return true;
        }
        Number sum = 0;
        for (IntegerInterval integerInterval : this._intIntervals) {
            sum = OWLRealUtils.integerSum(sum, integerInterval.size());
            if (OWLRealUtils.compare(n, sum) > 0) continue;
            return true;
        }
        for (ContinuousRealInterval continuousRealInterval : this._decimalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower())) continue;
            sum = OWLRealUtils.integerIncrement(sum);
            if (OWLRealUtils.compare(n, sum) > 0) continue;
            return true;
        }
        for (ContinuousRealInterval continuousRealInterval : this._rationalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower()) || OWLRealUtils.isRational(continuousRealInterval.getLower())) continue;
            sum = OWLRealUtils.integerIncrement(sum);
            if (OWLRealUtils.compare(n, sum) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<Number> exclude(Collection<?> values) {
        boolean changes = false;
        ArrayList<IntegerInterval> revisedInts = new ArrayList<IntegerInterval>(this._intIntervals);
        ArrayList<ContinuousRealInterval> revisedDecimals = new ArrayList<ContinuousRealInterval>(this._decimalIntervals);
        ArrayList<ContinuousRealInterval> revisedRationals = new ArrayList<ContinuousRealInterval>(this._rationalIntervals);
        block0: for (Object o : values) {
            ArrayList<ContinuousRealInterval> revised;
            Number n;
            if (!(o instanceof Number) || !OWLRealUtils.acceptable((n = (Number)o).getClass())) continue;
            if (OWLRealUtils.isInteger(n)) {
                Iterator it = revisedInts.iterator();
                while (it.hasNext()) {
                    IntegerInterval greater;
                    IntegerInterval i = (IntegerInterval)it.next();
                    if (!i.contains(n)) continue;
                    changes = true;
                    it.remove();
                    IntegerInterval less = (IntegerInterval)i.less(n);
                    if (less != null) {
                        revisedInts.add(less);
                    }
                    if ((greater = (IntegerInterval)i.greater(n)) == null) continue block0;
                    revisedInts.add(greater);
                    continue block0;
                }
                continue;
            }
            if (OWLRealUtils.isDecimal(n)) {
                revised = revisedDecimals;
            } else if (OWLRealUtils.isRational(n)) {
                revised = revisedRationals;
            } else {
                throw new IllegalStateException();
            }
            Iterator it = revised.iterator();
            while (it.hasNext()) {
                ContinuousRealInterval greater;
                ContinuousRealInterval i = (ContinuousRealInterval)it.next();
                if (!i.contains(n)) continue;
                changes = true;
                it.remove();
                ContinuousRealInterval less = i.less(n);
                if (less != null) {
                    revised.add(less);
                }
                if ((greater = i.greater(n)) == null) continue block0;
                revised.add(greater);
                continue block0;
            }
        }
        if (changes) {
            if (revisedInts.isEmpty() && revisedDecimals.isEmpty() && revisedRationals.isEmpty()) {
                return this._empty;
            }
            return new RestrictedRealDatatype(this, revisedInts, revisedDecimals, revisedRationals);
        }
        return this;
    }

    @Override
    public Datatype<? extends Number> getDatatype() {
        return this._datatype;
    }

    @Override
    @Deprecated
    public Number getValue(int i) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RestrictedDatatype<Number> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedRealDatatype) {
            Object tmp;
            Object decimalIntersectWith;
            Object k;
            Object j;
            Object tmp2;
            Object intIntersectWith;
            RestrictedRealDatatype otherRRD = (RestrictedRealDatatype)other;
            ArrayList<IntegerInterval> revisedInts = new ArrayList<IntegerInterval>();
            ArrayList<ContinuousRealInterval> revisedDecimals = new ArrayList<ContinuousRealInterval>();
            ArrayList<ContinuousRealInterval> revisedRationals = new ArrayList<ContinuousRealInterval>();
            if (negated) {
                intIntersectWith = Collections.singletonList(IntegerInterval.allIntegers());
                for (IntegerInterval integerInterval : otherRRD._intIntervals) {
                    tmp2 = new ArrayList(2 * intIntersectWith.size());
                    Iterator<IntegerInterval> iterator = intIntersectWith.iterator();
                    while (iterator.hasNext()) {
                        j = iterator.next();
                        tmp2.addAll(((DiscreteInterval)j).remove(integerInterval));
                    }
                    intIntersectWith = tmp2;
                }
            } else {
                intIntersectWith = otherRRD._intIntervals;
            }
            for (IntegerInterval integerInterval : this._intIntervals) {
                tmp2 = intIntersectWith.iterator();
                while (tmp2.hasNext()) {
                    IntegerInterval j2 = tmp2.next();
                    k = integerInterval.intersection(j2);
                    if (k == null) continue;
                    revisedInts.add((IntegerInterval)k);
                }
            }
            if (negated) {
                decimalIntersectWith = Collections.singletonList(ContinuousRealInterval.allReals());
                for (ContinuousRealInterval i : otherRRD._decimalIntervals) {
                    tmp = new ArrayList(2 * decimalIntersectWith.size());
                    k = decimalIntersectWith.iterator();
                    while (k.hasNext()) {
                        ContinuousRealInterval j3 = (ContinuousRealInterval)k.next();
                        tmp.addAll(j3.remove(i));
                    }
                    decimalIntersectWith = tmp;
                }
            } else {
                decimalIntersectWith = otherRRD._decimalIntervals;
            }
            for (ContinuousRealInterval i : this._decimalIntervals) {
                tmp = decimalIntersectWith.iterator();
                while (tmp.hasNext()) {
                    j = tmp.next();
                    ContinuousRealInterval k2 = i.intersection((ContinuousRealInterval)j);
                    if (k2 == null) continue;
                    revisedDecimals.add(k2);
                }
            }
            if (negated) {
                List<ContinuousRealInterval> list = Collections.singletonList(ContinuousRealInterval.allReals());
                for (ContinuousRealInterval i : otherRRD._rationalIntervals) {
                    void var9_16;
                    ArrayList<ContinuousRealInterval> tmp3 = new ArrayList<ContinuousRealInterval>(2 * var9_16.size());
                    for (ContinuousRealInterval j4 : var9_16) {
                        tmp3.addAll(j4.remove(i));
                    }
                    ArrayList<ContinuousRealInterval> arrayList = tmp3;
                }
            } else {
                List<ContinuousRealInterval> list = otherRRD._rationalIntervals;
            }
            for (ContinuousRealInterval i : this._rationalIntervals) {
                void var9_19;
                for (ContinuousRealInterval j2 : var9_19) {
                    ContinuousRealInterval k3 = i.intersection(j2);
                    if (k3 == null) continue;
                    revisedRationals.add(k3);
                }
            }
            if (revisedInts.equals(this._intIntervals) && revisedDecimals.equals(this._decimalIntervals) && revisedRationals.equals(this._rationalIntervals)) {
                return this;
            }
            if (revisedInts.isEmpty() && revisedDecimals.isEmpty() && revisedRationals.isEmpty()) {
                return this._empty;
            }
            return new RestrictedRealDatatype(this, revisedInts, revisedDecimals, revisedRationals);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return this._enumerable;
    }

    @Override
    public boolean isFinite() {
        return this._finite;
    }

    @Override
    @Deprecated
    public int size() {
        if (!this._finite) {
            throw new IllegalStateException();
        }
        Number sum = 0;
        for (IntegerInterval integerInterval : this._intIntervals) {
            sum = OWLRealUtils.integerSum(sum, integerInterval.size());
            if (OWLRealUtils.compare(Integer.MAX_VALUE, sum) > 0) continue;
            return Integer.MAX_VALUE;
        }
        for (ContinuousRealInterval continuousRealInterval : this._decimalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower())) continue;
            sum = OWLRealUtils.integerIncrement(sum);
            if (OWLRealUtils.compare(Integer.MAX_VALUE, sum) > 0) continue;
            return Integer.MAX_VALUE;
        }
        for (ContinuousRealInterval continuousRealInterval : this._rationalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower()) || OWLRealUtils.isRational(continuousRealInterval.getLower())) continue;
            sum = OWLRealUtils.integerIncrement(sum);
            if (OWLRealUtils.compare(Integer.MAX_VALUE, sum) > 0) continue;
            return Integer.MAX_VALUE;
        }
        return sum.intValue();
    }

    @Override
    public RestrictedDatatype<Number> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedRealDatatype) {
            HashSet<Object> tmp;
            Object j;
            Iterator jt;
            ArrayList<Object> unionWith;
            RestrictedRealDatatype otherRRD = (RestrictedRealDatatype)other;
            ArrayList<IntegerInterval> revisedInts = new ArrayList<IntegerInterval>(this._intIntervals);
            ArrayList<ContinuousRealInterval> revisedDecimals = new ArrayList<ContinuousRealInterval>(this._decimalIntervals);
            ArrayList<ContinuousRealInterval> revisedRationals = new ArrayList<ContinuousRealInterval>(this._rationalIntervals);
            for (IntegerInterval integerInterval : otherRRD._intIntervals) {
                unionWith = new ArrayList<Object>();
                jt = revisedInts.iterator();
                while (jt.hasNext()) {
                    j = (IntegerInterval)jt.next();
                    if (!integerInterval.canUnionWith(j)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedInts.add(integerInterval);
                    continue;
                }
                tmp = new HashSet<Object>();
                for (IntegerInterval j2 : unionWith) {
                    tmp.addAll(integerInterval.union(j2));
                }
                revisedInts.addAll(tmp);
            }
            for (ContinuousRealInterval continuousRealInterval : otherRRD._decimalIntervals) {
                unionWith = new ArrayList();
                jt = revisedDecimals.iterator();
                while (jt.hasNext()) {
                    j = (ContinuousRealInterval)jt.next();
                    if (!continuousRealInterval.canUnionWith((ContinuousRealInterval)j)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedDecimals.add(continuousRealInterval);
                    continue;
                }
                tmp = new HashSet();
                for (ContinuousRealInterval j2 : unionWith) {
                    tmp.addAll(continuousRealInterval.union(j2));
                }
                revisedDecimals.addAll(tmp);
            }
            for (ContinuousRealInterval continuousRealInterval : otherRRD._rationalIntervals) {
                unionWith = new ArrayList();
                jt = revisedRationals.iterator();
                while (jt.hasNext()) {
                    j = (ContinuousRealInterval)jt.next();
                    if (!continuousRealInterval.canUnionWith((ContinuousRealInterval)j)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedRationals.add(continuousRealInterval);
                    continue;
                }
                tmp = new HashSet();
                for (ContinuousRealInterval j2 : unionWith) {
                    tmp.addAll(continuousRealInterval.union(j2));
                }
                revisedRationals.addAll(tmp);
            }
            if (revisedInts.equals(this._intIntervals) && revisedDecimals.equals(this._decimalIntervals) && revisedRationals.equals(this._rationalIntervals)) {
                return this;
            }
            return new RestrictedRealDatatype(this, revisedInts, revisedDecimals, revisedRationals);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Number> valueIterator() {
        if (!this._enumerable) {
            throw new IllegalStateException();
        }
        return new Iterator<Number>(){
            final Iterator<IntegerInterval> intit;
            final Iterator<ContinuousRealInterval> decit;
            final Iterator<ContinuousRealInterval> ratit;
            private Iterator<Number> nit;
            private boolean intOk;
            private boolean decOk;
            private Number next;
            {
                this.intit = RestrictedRealDatatype.this._intIntervals.iterator();
                this.decit = RestrictedRealDatatype.this._decimalIntervals.iterator();
                this.ratit = RestrictedRealDatatype.this._rationalIntervals.iterator();
                this.nit = null;
                this.intOk = true;
                this.decOk = true;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (this.nit != null && this.nit.hasNext()) {
                        this.next = this.nit.next();
                        if (!this.intOk && OWLRealUtils.isInteger(this.next)) {
                            this.next = null;
                        }
                        if (this.decOk || !OWLRealUtils.isDecimal(this.next)) continue;
                        this.next = null;
                        continue;
                    }
                    if (this.intit.hasNext()) {
                        this.nit = this.intit.next().valueIterator();
                        continue;
                    }
                    this.intOk = false;
                    if (this.decit.hasNext()) {
                        this.nit = this.decit.next().valueIterator();
                        continue;
                    }
                    this.decOk = false;
                    if (this.ratit.hasNext()) {
                        this.nit = this.ratit.next().valueIterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Number next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Number ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return String.format("{%s,%s,%s,%s}", this._datatype, this._intIntervals, this._decimalIntervals, this._rationalIntervals);
    }
}

