/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.AbstractDerivedIntegerType;
import openllet.core.utils.ATermUtils;

public class XSDNegativeInteger
extends AbstractDerivedIntegerType {
    private static final XSDNegativeInteger instance = new XSDNegativeInteger();

    public static XSDNegativeInteger getInstance() {
        return instance;
    }

    private XSDNegativeInteger() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#negativeInteger"), null, -1);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            BigInteger n = DatatypeConverter.parseInteger((String)lexicalForm);
            if (BigInteger.ZERO.compareTo(n) <= 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e);
        }
    }
}

