/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.uri;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidConstrainingFacetException;
import openllet.core.datatypes.types.uri.XSDAnyURI;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.SetUtils;

public class RestrictedURIDatatype
implements RestrictedDatatype<ATermAppl> {
    private final Datatype<ATermAppl> _dt;
    private final Set<Object> _excludedValues;

    public RestrictedURIDatatype(Datatype<ATermAppl> dt) {
        this(dt, Collections.emptySet());
    }

    private RestrictedURIDatatype(Datatype<ATermAppl> dt, Set<Object> excludedValues) {
        this._dt = dt;
        this._excludedValues = excludedValues;
    }

    @Override
    public RestrictedDatatype<ATermAppl> applyConstrainingFacet(ATermAppl facet, Object value) throws InvalidConstrainingFacetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)value;
            if (this._excludedValues.contains(a)) {
                return false;
            }
            if (ATermUtils.isLiteral(a) && XSDAnyURI.NAME.equals(a.getArgument(2))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        return true;
    }

    @Override
    public RestrictedDatatype<ATermAppl> exclude(Collection<?> values) {
        Set<Object> newExcludedValues = SetUtils.create(values);
        newExcludedValues.addAll(this._excludedValues);
        return new RestrictedURIDatatype(this._dt, newExcludedValues);
    }

    @Override
    public Datatype<? extends ATermAppl> getDatatype() {
        return this._dt;
    }

    @Override
    public RestrictedDatatype<ATermAppl> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedURIDatatype) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public RestrictedDatatype<ATermAppl> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedURIDatatype) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<ATermAppl> valueIterator() {
        throw new IllegalStateException();
    }
}

